/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.mobilefuse.sdk.AdError;
import com.mobilefuse.sdk.MobileFuse;
import com.mobilefuse.sdk.MobileFuseBannerAd;
import com.mobilefuse.sdk.MobileFuseInterstitialAd;
import com.mobilefuse.sdk.MobileFuseNativeAd;
import com.mobilefuse.sdk.MobileFuseRewardedAd;
import com.mobilefuse.sdk.MobileFuseSettings;
import com.mobilefuse.sdk.SdkInitListener;
import com.mobilefuse.sdk.internal.MobileFuseBiddingTokenProvider;
import com.mobilefuse.sdk.internal.MobileFuseBiddingTokenRequest;
import com.mobilefuse.sdk.internal.TokenGeneratorListener;
import com.mobilefuse.sdk.privacy.MobileFusePrivacyPreferences;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MobileFuseMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus initializationStatus;
    private MobileFuseInterstitialAd interstitialAd;
    private MobileFuseRewardedAd rewardedAd;
    private MobileFuseBannerAd adView;
    private MobileFuseNativeAd nativeAd;

    public MobileFuseMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            this.log("Initializing MobileFuse SDK");
            initializationStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            MobileFuseSettings.setTestMode((boolean)parameters.isTesting());
            MobileFuseSettings.setSdkAdapter((String)"applovin_bidding", (String)this.getAdapterVersion());
            MobileFuse.init((SdkInitListener)new SdkInitListener(){

                public void onInitSuccess() {
                    MobileFuseMediationAdapter.this.log("MobileFuse SDK initialized");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(initializationStatus, null);
                }

                public void onInitError() {
                    MobileFuseMediationAdapter.this.log("MobileFuse SDK failed to initialize");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(initializationStatus, null);
                }
            });
        } else {
            onCompletionListener.onCompletion(initializationStatus, null);
        }
    }

    public String getSdkVersion() {
        return MobileFuse.getSdkVersion();
    }

    public String getAdapterVersion() {
        return "1.9.0.0";
    }

    public void onDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.setListener(null);
            this.interstitialAd = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.setListener(null);
            this.rewardedAd = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView.setListener(null);
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.unregisterViews();
            this.nativeAd.setAdListener(null);
            this.nativeAd = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, final MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        MobileFuseBiddingTokenRequest tokenRequest = new MobileFuseBiddingTokenRequest(MobileFuse.getPrivacyPreferences(), parameters.isTesting());
        MobileFuseBiddingTokenProvider.getToken((MobileFuseBiddingTokenRequest)tokenRequest, (Context)this.getContext(activity), (TokenGeneratorListener)new TokenGeneratorListener(){

            public void onTokenGenerated(@NonNull String signal) {
                MobileFuseMediationAdapter.this.log("Signal collection successful");
                callback.onSignalCollected(signal);
            }

            public void onTokenGenerationFailed(@NonNull String errorMessage) {
                MobileFuseMediationAdapter.this.log("Signal collection failed: " + errorMessage);
                callback.onSignalCollectionFailed(errorMessage);
            }
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        this.interstitialAd = new MobileFuseInterstitialAd(this.getContext(activity), placementId);
        this.interstitialAd.setListener((MobileFuseInterstitialAd.Listener)new InterstitialAdListener(listener));
        this.interstitialAd.loadAdFromBiddingToken(parameters.getBidResponse());
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad: " + parameters.getThirdPartyAdPlacementId());
        if (!this.interstitialAd.isLoaded()) {
            this.log("Unable to show interstitial - ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
            return;
        }
        this.interstitialAd.showAd();
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        this.rewardedAd = new MobileFuseRewardedAd(this.getContext(activity), placementId);
        this.rewardedAd.setListener((MobileFuseRewardedAd.Listener)new RewardedAdListener(listener));
        this.rewardedAd.loadAdFromBiddingToken(parameters.getBidResponse());
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad: " + parameters.getThirdPartyAdPlacementId());
        if (!this.rewardedAd.isLoaded()) {
            this.log("Unable to show rewarded ad - ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
            return;
        }
        this.configureReward(parameters);
        this.rewardedAd.showAd();
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading " + (isNative ? "native " : "") + adFormat.getLabel() + " ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        if (isNative) {
            this.nativeAd = new MobileFuseNativeAd(this.getContext(activity), placementId);
            this.nativeAd.setAdListener((MobileFuseNativeAd.Listener)new NativeAdViewListener(adFormat, parameters, listener));
            this.nativeAd.loadAdFromBiddingToken(parameters.getBidResponse());
        } else {
            this.adView = new MobileFuseBannerAd(this.getContext(activity), placementId, this.toAdSize(adFormat));
            this.adView.setListener((MobileFuseBannerAd.Listener)new AdViewAdListener(listener));
            this.adView.setAutorefreshEnabled(false);
            this.adView.setMuted(true);
            this.adView.loadAdFromBiddingToken(parameters.getBidResponse());
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxNativeAdAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading native ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        this.nativeAd = new MobileFuseNativeAd(this.getContext(activity), placementId);
        this.nativeAd.setAdListener((MobileFuseNativeAd.Listener)new NativeAdListener(parameters, listener));
        this.nativeAd.loadAdFromBiddingToken(parameters.getBidResponse());
    }

    private MaxAdapterError toMaxError(AdError mobileFuseError) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        if (mobileFuseError == null) {
            return adapterError;
        }
        switch (mobileFuseError) {
            case AD_ALREADY_LOADED: 
            case AD_LOAD_ERROR: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case AD_ALREADY_RENDERED: 
            case AD_RUNTIME_ERROR: {
                adapterError = MaxAdapterError.AD_DISPLAY_FAILED;
            }
        }
        return new MaxAdapterError(adapterError, mobileFuseError.getErrorCode(), mobileFuseError.getErrorMessage());
    }

    private void updatePrivacyPreferences(MaxAdapterParameters parameters) {
        MobileFusePrivacyPreferences.Builder privacyPreferencesBuilder = new MobileFusePrivacyPreferences.Builder();
        Boolean isDoNotSell = parameters.isDoNotSell();
        if (isDoNotSell != null) {
            privacyPreferencesBuilder.setUsPrivacyConsentString(isDoNotSell != false ? "1YY-" : "1YN-");
        } else {
            privacyPreferencesBuilder.setUsPrivacyConsentString("1---");
        }
        MobileFuse.setPrivacyPreferences((MobileFusePrivacyPreferences)privacyPreferencesBuilder.build());
    }

    private MobileFuseBannerAd.AdSize toAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return MobileFuseBannerAd.AdSize.BANNER_300x50;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return MobileFuseBannerAd.AdSize.BANNER_728x90;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return MobileFuseBannerAd.AdSize.BANNER_300x250;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private List<View> getClickableViews(MaxNativeAdView maxNativeAdView) {
        ArrayList<View> clickableViews = new ArrayList<View>(6);
        if (maxNativeAdView.getTitleTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getTitleTextView());
        }
        if (maxNativeAdView.getAdvertiserTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
        }
        if (maxNativeAdView.getBodyTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getBodyTextView());
        }
        if (maxNativeAdView.getCallToActionButton() != null) {
            clickableViews.add((View)maxNativeAdView.getCallToActionButton());
        }
        if (maxNativeAdView.getIconImageView() != null) {
            clickableViews.add((View)maxNativeAdView.getIconImageView());
        }
        if (maxNativeAdView.getMediaContentViewGroup() != null) {
            clickableViews.add((View)maxNativeAdView.getMediaContentViewGroup());
        }
        return clickableViews;
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class InterstitialAdListener
    implements MobileFuseInterstitialAd.Listener {
        private final MaxInterstitialAdapterListener listener;

        public InterstitialAdListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded() {
            MobileFuseMediationAdapter.this.log("Interstitial ad loaded");
            this.listener.onInterstitialAdLoaded();
        }

        public void onAdNotFilled() {
            MobileFuseMediationAdapter.this.log("Interstitial ad failed to load - no fill");
            this.listener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onAdExpired() {
            MobileFuseMediationAdapter.this.log("Interstitial ad expired");
        }

        public void onAdRendered() {
            MobileFuseMediationAdapter.this.log("Interstitial ad displayed");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            MobileFuseMediationAdapter.this.log("Interstitial ad clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onAdClosed() {
            MobileFuseMediationAdapter.this.log("Interstitial ad hidden");
            this.listener.onInterstitialAdHidden();
        }

        public void onAdError(AdError adError) {
            MaxAdapterError adapterError = MobileFuseMediationAdapter.this.toMaxError(adError);
            if (adError == AdError.AD_ALREADY_LOADED || adError == AdError.AD_LOAD_ERROR) {
                MobileFuseMediationAdapter.this.log("Interstitial ad failed to load with error (" + adapterError + ")");
                this.listener.onInterstitialAdLoadFailed(adapterError);
            } else {
                MobileFuseMediationAdapter.this.log("Interstitial ad failed to display with error (" + adapterError + ")");
                this.listener.onInterstitialAdDisplayFailed(adapterError);
            }
        }
    }

    private class RewardedAdListener
    implements MobileFuseRewardedAd.Listener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        public RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded() {
            MobileFuseMediationAdapter.this.log("Rewarded ad loaded");
            this.listener.onRewardedAdLoaded();
        }

        public void onAdNotFilled() {
            MobileFuseMediationAdapter.this.log("Rewarded ad failed to load - no fill");
            this.listener.onRewardedAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onAdExpired() {
            MobileFuseMediationAdapter.this.log("Rewarded ad expired");
        }

        public void onAdRendered() {
            MobileFuseMediationAdapter.this.log("Rewarded ad displayed");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked() {
            MobileFuseMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onUserEarnedReward() {
            MobileFuseMediationAdapter.this.log("Rewarded ad should grant reward");
            this.hasGrantedReward = true;
        }

        public void onAdClosed() {
            MobileFuseMediationAdapter.this.log("Rewarded ad hidden");
            if (this.hasGrantedReward || MobileFuseMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = MobileFuseMediationAdapter.this.getReward();
                MobileFuseMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            this.listener.onRewardedAdHidden();
        }

        public void onAdError(AdError adError) {
            MaxAdapterError adapterError = MobileFuseMediationAdapter.this.toMaxError(adError);
            if (adError == AdError.AD_ALREADY_LOADED || adError == AdError.AD_LOAD_ERROR) {
                MobileFuseMediationAdapter.this.log("Rewarded ad failed to load with error (" + adapterError + ")");
                this.listener.onRewardedAdLoadFailed(adapterError);
            } else {
                MobileFuseMediationAdapter.this.log("Rewarded ad failed to display with error (" + adapterError + ")");
                this.listener.onRewardedAdDisplayFailed(adapterError);
            }
        }
    }

    private class NativeAdViewListener
    implements MobileFuseNativeAd.Listener {
        private final MaxAdFormat adFormat;
        private final Bundle serverParameters;
        private final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdFormat adFormat, MaxAdapterResponseParameters parameters, MaxAdViewAdapterListener listener) {
            this.adFormat = adFormat;
            this.serverParameters = parameters.getServerParameters();
            this.listener = listener;
        }

        public void onAdLoaded() {
            MaxNativeAdView maxNativeAdView;
            if (MobileFuseMediationAdapter.this.nativeAd == null) {
                MobileFuseMediationAdapter.this.e("Native " + this.adFormat.getLabel() + " ad is null");
                return;
            }
            MobileFuseMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded");
            if (!MobileFuseMediationAdapter.this.nativeAd.hasTitle()) {
                MobileFuseMediationAdapter.this.e("Native " + this.adFormat.getLabel() + " ad (" + MobileFuseMediationAdapter.this.nativeAd + ") does not have required assets.");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setTitle(MobileFuseMediationAdapter.this.nativeAd.getTitle()).setBody(MobileFuseMediationAdapter.this.nativeAd.getDescriptionText()).setAdvertiser(MobileFuseMediationAdapter.this.nativeAd.getSponsoredText()).setCallToAction(MobileFuseMediationAdapter.this.nativeAd.getCtaButtonText()).setIconView(MobileFuseMediationAdapter.this.nativeAd.getIconView()).setMediaView(MobileFuseMediationAdapter.this.nativeAd.getMainContentView());
            MaxMobileFuseNativeAd maxMobileFuseNativeAd = new MaxMobileFuseNativeAd(builder);
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            if (templateName.equals("vertical")) {
                String verticalTemplateName = this.adFormat == MaxAdFormat.LEADER ? "vertical_leader_template" : "vertical_media_banner_template";
                maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxMobileFuseNativeAd, verticalTemplateName, MobileFuseMediationAdapter.this.getApplicationContext());
            } else {
                maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxMobileFuseNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "media_banner_template", MobileFuseMediationAdapter.this.getApplicationContext());
            }
            maxMobileFuseNativeAd.prepareForInteraction(MobileFuseMediationAdapter.this.getClickableViews(maxNativeAdView), (ViewGroup)maxNativeAdView);
            this.listener.onAdViewAdLoaded((View)maxNativeAdView);
        }

        public void onAdNotFilled() {
            MobileFuseMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load - no fill");
            this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onAdExpired() {
            MobileFuseMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad expired");
        }

        public void onAdRendered() {
            MobileFuseMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad displayed");
            this.listener.onAdViewAdDisplayed(null);
        }

        public void onAdClicked() {
            MobileFuseMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdError(@NonNull AdError adError) {
            MaxAdapterError adapterError = MobileFuseMediationAdapter.this.toMaxError(adError);
            if (adError == AdError.AD_ALREADY_LOADED || adError == AdError.AD_LOAD_ERROR) {
                MobileFuseMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load with error (" + adapterError + ")");
                this.listener.onAdViewAdLoadFailed(adapterError);
            } else {
                MobileFuseMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to display with error (" + adapterError + ")");
                this.listener.onAdViewAdDisplayFailed(adapterError);
            }
        }
    }

    private class AdViewAdListener
    implements MobileFuseBannerAd.Listener {
        private final MaxAdViewAdapterListener listener;

        public AdViewAdListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded() {
            MobileFuseMediationAdapter.this.log("AdView ad loaded");
            this.listener.onAdViewAdLoaded((View)MobileFuseMediationAdapter.this.adView);
        }

        public void onAdNotFilled() {
            MobileFuseMediationAdapter.this.log("AdView ad failed to load - no fill");
            this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onAdExpired() {
            MobileFuseMediationAdapter.this.log("AdView ad expired");
        }

        public void onAdRendered() {
            MobileFuseMediationAdapter.this.log("AdView ad displayed");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked() {
            MobileFuseMediationAdapter.this.log("AdView ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdExpanded() {
            MobileFuseMediationAdapter.this.log("AdView ad expanded");
            this.listener.onAdViewAdExpanded();
        }

        public void onAdCollapsed() {
            MobileFuseMediationAdapter.this.log("AdView ad collapsed");
            this.listener.onAdViewAdCollapsed();
        }

        public void onAdError(AdError adError) {
            MaxAdapterError adapterError = MobileFuseMediationAdapter.this.toMaxError(adError);
            if (adError == AdError.AD_ALREADY_LOADED || adError == AdError.AD_LOAD_ERROR) {
                MobileFuseMediationAdapter.this.log("AdView ad failed to load with error (" + adapterError + ")");
                this.listener.onAdViewAdLoadFailed(adapterError);
            } else {
                MobileFuseMediationAdapter.this.log("AdView ad failed to display with error (" + adapterError + ")");
                this.listener.onAdViewAdDisplayFailed(adapterError);
            }
        }
    }

    private class NativeAdListener
    implements MobileFuseNativeAd.Listener {
        private final Bundle serverParameters;
        private final MaxNativeAdAdapterListener listener;

        public NativeAdListener(MaxAdapterResponseParameters parameters, MaxNativeAdAdapterListener listener) {
            this.serverParameters = parameters.getServerParameters();
            this.listener = listener;
        }

        public void onAdLoaded() {
            if (MobileFuseMediationAdapter.this.nativeAd == null) {
                MobileFuseMediationAdapter.this.e("Native ad is null");
                return;
            }
            MobileFuseMediationAdapter.this.log("Native ad loaded");
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && !MobileFuseMediationAdapter.this.nativeAd.hasTitle()) {
                MobileFuseMediationAdapter.this.e("Native ad (" + MobileFuseMediationAdapter.this.nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(MobileFuseMediationAdapter.this.nativeAd.getTitle()).setAdvertiser(MobileFuseMediationAdapter.this.nativeAd.getSponsoredText()).setBody(MobileFuseMediationAdapter.this.nativeAd.getDescriptionText()).setCallToAction(MobileFuseMediationAdapter.this.nativeAd.getCtaButtonText()).setIcon(new MaxNativeAd.MaxNativeAdImage(MobileFuseMediationAdapter.this.nativeAd.getIconDrawable())).setMediaView(MobileFuseMediationAdapter.this.nativeAd.getMainContentView());
            MaxMobileFuseNativeAd maxNativeAd = new MaxMobileFuseNativeAd(builder);
            this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
        }

        public void onAdNotFilled() {
            MobileFuseMediationAdapter.this.log("Native ad failed to load - no fill");
            this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onAdExpired() {
            MobileFuseMediationAdapter.this.log("Native ad expired");
        }

        public void onAdRendered() {
            MobileFuseMediationAdapter.this.log("Native ad displayed");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked() {
            MobileFuseMediationAdapter.this.log("Native ad clicked");
            this.listener.onNativeAdClicked();
        }

        public void onAdError(@NonNull AdError adError) {
            MaxAdapterError adapterError = MobileFuseMediationAdapter.this.toMaxError(adError);
            if (adError == AdError.AD_ALREADY_LOADED || adError == AdError.AD_LOAD_ERROR) {
                MobileFuseMediationAdapter.this.log("Native ad failed to load with error (" + adapterError + ")");
            } else {
                MobileFuseMediationAdapter.this.log("Native ad failed to display with error (" + adapterError + ")");
            }
            this.listener.onNativeAdLoadFailed(adapterError);
        }
    }

    private class MaxMobileFuseNativeAd
    extends MaxNativeAd {
        public MaxMobileFuseNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            MobileFuseNativeAd nativeAd = MobileFuseMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                MobileFuseMediationAdapter.this.e("Failed to register native ad view: native ad is null.");
                return false;
            }
            MobileFuseMediationAdapter.this.d("Preparing views for interaction: " + clickableViews + " with container: " + container);
            nativeAd.registerViewForInteraction((View)container, clickableViews);
            return true;
        }
    }
}

