/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.ImageViewUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.moloco.sdk.BuildConfig;
import com.moloco.sdk.publisher.AdLoad;
import com.moloco.sdk.publisher.AdShowListener;
import com.moloco.sdk.publisher.Banner;
import com.moloco.sdk.publisher.BannerAdShowListener;
import com.moloco.sdk.publisher.Initialization;
import com.moloco.sdk.publisher.InterstitialAd;
import com.moloco.sdk.publisher.InterstitialAdShowListener;
import com.moloco.sdk.publisher.MediationInfo;
import com.moloco.sdk.publisher.Moloco;
import com.moloco.sdk.publisher.MolocoAd;
import com.moloco.sdk.publisher.MolocoAdError;
import com.moloco.sdk.publisher.NativeAd;
import com.moloco.sdk.publisher.RewardedInterstitialAd;
import com.moloco.sdk.publisher.RewardedInterstitialAdShowListener;
import com.moloco.sdk.publisher.init.MolocoInitParams;
import com.moloco.sdk.publisher.privacy.MolocoPrivacy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;

public class MolocoMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter,
MaxNativeAdAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus initializationStatus;
    private InterstitialAd interstitialAd;
    private RewardedInterstitialAd rewardedAd;
    private Banner adView;
    private NativeAd nativeAd;
    private InterstitialAdListener interstitialAdListener;
    private RewardedAdListener rewardedAdListener;

    public MolocoMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            initializationStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            Bundle serverParameters = parameters.getServerParameters();
            String appKey = serverParameters.getString("app_key");
            MediationInfo mediationInfo = new MediationInfo("MAX");
            MolocoInitParams initParams = new MolocoInitParams(this.getContext(activity), appKey, mediationInfo);
            Moloco.initialize((MolocoInitParams)initParams, initStatus -> {
                if (initStatus.getInitialization() == Initialization.SUCCESS) {
                    this.log("Moloco SDK initialized");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(initializationStatus, null);
                } else {
                    this.log("Moloco SDK failed to initialize with error: " + initStatus.getDescription());
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(initializationStatus, initStatus.getDescription());
                }
            });
        } else {
            onCompletionListener.onCompletion(initializationStatus, null);
        }
    }

    public String getSdkVersion() {
        return this.getVersionString(BuildConfig.class, "SDK_VERSION_NAME");
    }

    public String getAdapterVersion() {
        return "3.6.0.1";
    }

    public void onDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
            this.interstitialAd = null;
            this.interstitialAdListener = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
            this.rewardedAd = null;
            this.rewardedAdListener = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
            this.nativeAd = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal");
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        Moloco.getBidToken((Context)this.getContext(activity), (signal, errorType) -> {
            if (errorType == null) {
                this.log("Signal collection successful");
                callback.onSignalCollected(signal);
            } else {
                this.log("Signal collection failed: " + errorType.getDescription());
                callback.onSignalCollectionFailed(errorType.getDescription());
            }
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        Function2 createCallback = (interstitialAd, error) -> {
            if (interstitialAd == null) {
                MaxAdapterError adapterError = this.toMaxError((MolocoAdError.AdCreateError)error);
                this.log("Interstitial ad load failed with error (" + adapterError + ")");
                listener.onInterstitialAdLoadFailed(adapterError);
            } else {
                this.interstitialAd = interstitialAd;
                this.interstitialAdListener = new InterstitialAdListener(listener);
                interstitialAd.load(parameters.getBidResponse(), (AdLoad.Listener)this.interstitialAdListener);
            }
            return Unit.INSTANCE;
        };
        Moloco.createInterstitial((String)placementId, null, (Function2)createCallback);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad: " + parameters.getThirdPartyAdPlacementId());
        if (!this.interstitialAd.isLoaded()) {
            this.log("Unable to show interstitial - ad not ready");
            listener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            return;
        }
        this.interstitialAd.show((AdShowListener)this.interstitialAdListener);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        Function2 createCallback = (rewardedAd, error) -> {
            if (rewardedAd == null) {
                MaxAdapterError adapterError = this.toMaxError((MolocoAdError.AdCreateError)error);
                this.log("Rewarded ad load failed with error (" + adapterError + ")");
                listener.onRewardedAdLoadFailed(adapterError);
            } else {
                this.rewardedAd = rewardedAd;
                this.rewardedAdListener = new RewardedAdListener(listener);
                rewardedAd.load(parameters.getBidResponse(), (AdLoad.Listener)this.rewardedAdListener);
            }
            return Unit.INSTANCE;
        };
        Moloco.createRewardedInterstitial((String)placementId, null, (Function2)createCallback);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad: " + parameters.getThirdPartyAdPlacementId());
        if (!this.rewardedAd.isLoaded()) {
            this.log("Unable to show rewarded ad - ad not ready");
            listener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            return;
        }
        this.configureReward(parameters);
        this.rewardedAd.show((AdShowListener)this.rewardedAdListener);
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading " + (isNative ? "native " : "") + adFormat.getLabel() + " ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        if (isNative) {
            Function2 createCallback = (nativeAd, error) -> {
                if (nativeAd == null) {
                    MaxAdapterError adapterError = this.toMaxError((MolocoAdError.AdCreateError)error);
                    this.log("Native " + adFormat.getLabel() + " ad load failed with error (" + adapterError + ")");
                    listener.onAdViewAdLoadFailed(adapterError);
                } else {
                    this.nativeAd = nativeAd;
                    NativeAdViewListener nativeAdViewListener = new NativeAdViewListener(adFormat, parameters, this.getContext(activity), listener);
                    nativeAd.setInteractionListener((NativeAd.InteractionListener)nativeAdViewListener);
                    nativeAd.load(parameters.getBidResponse(), (AdLoad.Listener)nativeAdViewListener);
                }
                return Unit.INSTANCE;
            };
            Moloco.createNativeAd((String)placementId, null, (Function2)createCallback);
        } else {
            Function2 createCallback = (adView, error) -> {
                if (adView == null) {
                    MaxAdapterError adapterError = this.toMaxError((MolocoAdError.AdCreateError)error);
                    this.log(adFormat.getLabel() + " ad load failed with error (" + adapterError + ")");
                    listener.onAdViewAdLoadFailed(adapterError);
                } else {
                    this.adView = adView;
                    AdViewAdListener adViewAdListener = new AdViewAdListener(listener);
                    adView.setAdShowListener((BannerAdShowListener)adViewAdListener);
                    adView.load(parameters.getBidResponse(), (AdLoad.Listener)adViewAdListener);
                }
                return Unit.INSTANCE;
            };
            if (adFormat == MaxAdFormat.BANNER) {
                Moloco.createBanner((String)placementId, null, (Function2)createCallback);
            } else if (adFormat == MaxAdFormat.LEADER) {
                Moloco.createBannerTablet((String)placementId, null, (Function2)createCallback);
            } else if (adFormat == MaxAdFormat.MREC) {
                Moloco.createMREC((String)placementId, null, (Function2)createCallback);
            } else {
                throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
            }
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxNativeAdAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading native ad: " + placementId);
        this.updatePrivacyPreferences((MaxAdapterParameters)parameters);
        Function2 createCallback = (nativeAd, error) -> {
            if (nativeAd == null) {
                MaxAdapterError adapterError = this.toMaxError((MolocoAdError.AdCreateError)error);
                this.log("Native ad load failed with error (" + adapterError + ")");
                listener.onNativeAdLoadFailed(adapterError);
            } else {
                this.nativeAd = nativeAd;
                NativeAdListener nativeAdListener = new NativeAdListener(parameters, this.getContext(activity), listener);
                nativeAd.setInteractionListener((NativeAd.InteractionListener)nativeAdListener);
                nativeAd.load(parameters.getBidResponse(), (AdLoad.Listener)nativeAdListener);
            }
            return Unit.INSTANCE;
        };
        Moloco.createNativeAd((String)placementId, null, (Function2)createCallback);
    }

    private MaxAdapterError toMaxError(MolocoAdError molocoAdError) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (molocoAdError.getErrorType()) {
            case UNKNOWN: {
                break;
            }
            case SDK_INIT_ERROR: 
            case AD_LOAD_FAILED_SDK_NOT_INIT: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case SDK_PERSISTENT_HTTP_REQUEST_FAILED_TO_INIT: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case SDK_INVALID_CONFIGURATION: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case AD_LOAD_FAILED: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case AD_LOAD_TIMEOUT_ERROR: {
                adapterError = MaxAdapterError.TIMEOUT;
                break;
            }
            case AD_LOAD_LIMIT_REACHED: {
                adapterError = MaxAdapterError.AD_FREQUENCY_CAPPED;
                break;
            }
            case AD_SHOW_ERROR: 
            case AD_SHOW_ERROR_ALREADY_DISPLAYING: {
                adapterError = MaxAdapterError.AD_DISPLAY_FAILED;
                break;
            }
            case AD_SHOW_ERROR_NOT_LOADED: {
                adapterError = MaxAdapterError.AD_NOT_READY;
                break;
            }
            case AD_BID_PARSE_ERROR: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case AD_SIGNAL_COLLECTION_FAILED: {
                adapterError = MaxAdapterError.SIGNAL_COLLECTION_TIMEOUT;
            }
        }
        return new MaxAdapterError(adapterError, molocoAdError.getErrorType().getErrorCode(), molocoAdError.getDescription());
    }

    private MaxAdapterError toMaxError(@Nullable MolocoAdError.AdCreateError error) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        if (error == null) {
            return adapterError;
        }
        switch (error) {
            case INVALID_AD_UNIT_ID: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case SDK_INIT_FAILED: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case SDK_INIT_WAS_NOT_COMPLETED: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
            }
        }
        return new MaxAdapterError(adapterError, error.getErrorCode(), error.getDescription());
    }

    private void updatePrivacyPreferences(MaxAdapterParameters parameters) {
        Boolean hasUserConsent = parameters.hasUserConsent();
        Boolean isDoNotSell = parameters.isDoNotSell();
        MolocoPrivacy.PrivacySettings privacySettings = new MolocoPrivacy.PrivacySettings(hasUserConsent, null, isDoNotSell);
        MolocoPrivacy.setPrivacy((MolocoPrivacy.PrivacySettings)privacySettings);
    }

    private List<View> getClickableViews(MaxNativeAdView maxNativeAdView) {
        ArrayList<View> clickableViews = new ArrayList<View>(6);
        if (maxNativeAdView.getTitleTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getTitleTextView());
        }
        if (maxNativeAdView.getAdvertiserTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
        }
        if (maxNativeAdView.getBodyTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getBodyTextView());
        }
        if (maxNativeAdView.getCallToActionButton() != null) {
            clickableViews.add((View)maxNativeAdView.getCallToActionButton());
        }
        if (maxNativeAdView.getIconImageView() != null) {
            clickableViews.add((View)maxNativeAdView.getIconImageView());
        }
        if (maxNativeAdView.getMediaContentViewGroup() != null) {
            clickableViews.add((View)maxNativeAdView.getMediaContentViewGroup());
        }
        return clickableViews;
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class InterstitialAdListener
    implements AdLoad.Listener,
    InterstitialAdShowListener {
        private final MaxInterstitialAdapterListener listener;

        public InterstitialAdListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoadSuccess(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Interstitial ad loaded");
            this.listener.onInterstitialAdLoaded();
        }

        public void onAdLoadFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("Interstitial ad failed to load with error: " + adapterError);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onAdShowSuccess(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Interstitial ad displayed");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdShowFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("Interstitial ad failed to display with error: " + adapterError);
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdClicked(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Interstitial ad clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onAdHidden(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Interstitial ad hidden");
            this.listener.onInterstitialAdHidden();
        }
    }

    private class RewardedAdListener
    implements AdLoad.Listener,
    RewardedInterstitialAdShowListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        public RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoadSuccess(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Rewarded ad loaded");
            this.listener.onRewardedAdLoaded();
        }

        public void onAdLoadFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("Rewarded ad failed to load with error: " + adapterError);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onAdShowSuccess(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Rewarded ad displayed");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdShowFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("Rewarded ad failed to display error: " + adapterError);
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onAdClicked(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onRewardedVideoStarted(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Rewarded video started");
        }

        public void onRewardedVideoCompleted(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Rewarded video completed");
        }

        public void onUserRewarded(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("Rewarded video granted reward");
            this.hasGrantedReward = true;
        }

        public void onAdHidden(@NonNull MolocoAd molocoAd) {
            if (this.hasGrantedReward || MolocoMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = MolocoMediationAdapter.this.getReward();
                MolocoMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            MolocoMediationAdapter.this.log("Rewarded ad hidden");
            this.listener.onRewardedAdHidden();
        }
    }

    private class NativeAdListener
    implements AdLoad.Listener,
    NativeAd.InteractionListener {
        private final Bundle serverParameters;
        private final Context context;
        private final MaxNativeAdAdapterListener listener;

        public NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onAdLoadSuccess(@NonNull MolocoAd molocoAd) {
            NativeAd loadedNativeAd = MolocoMediationAdapter.this.nativeAd;
            if (loadedNativeAd == null) {
                MolocoMediationAdapter.this.e("Native ad is null");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
                return;
            }
            MolocoMediationAdapter.this.log("Native ad loaded");
            NativeAd.Assets assets = loadedNativeAd.getAssets();
            if (assets == null) {
                MolocoMediationAdapter.this.e("Native ad assets object is null");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)assets.getTitle())) {
                MolocoMediationAdapter.this.e("Native ad (" + loadedNativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(assets.getTitle()).setBody(assets.getDescription()).setAdvertiser(assets.getSponsorText()).setCallToAction(assets.getCallToActionText()).setStarRating(assets.getRating() != null ? Double.valueOf(assets.getRating().doubleValue()) : null);
            if (assets.getIconUri() != null) {
                builder.setIcon(new MaxNativeAd.MaxNativeAdImage(assets.getIconUri()));
            }
            if (assets.getMediaView() != null) {
                builder.setMediaView(assets.getMediaView());
            } else if (assets.getMainImageUri() != null) {
                ImageView imageView = new ImageView(this.context);
                ImageViewUtils.setImageUri((ImageView)imageView, (Uri)assets.getMainImageUri(), null);
                builder.setMediaView((View)imageView);
                builder.setMainImage(new MaxNativeAd.MaxNativeAdImage(assets.getMainImageUri()));
            }
            MaxMolocoNativeAd maxNativeAd = new MaxMolocoNativeAd(builder);
            this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
        }

        public void onAdLoadFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("Native ad failed to load with error: " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onImpressionHandled() {
            MolocoMediationAdapter.this.log("Native ad displayed");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onGeneralClickHandled() {
            MolocoMediationAdapter.this.log("Native ad clicked");
            this.listener.onNativeAdClicked();
        }
    }

    private class AdViewAdListener
    implements AdLoad.Listener,
    BannerAdShowListener {
        private final MaxAdViewAdapterListener listener;

        public AdViewAdListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoadSuccess(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("AdView ad loaded");
            this.listener.onAdViewAdLoaded((View)MolocoMediationAdapter.this.adView);
        }

        public void onAdLoadFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("AdView ad failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdShowSuccess(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("AdView ad displayed");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdShowFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("AdView ad failed to display with error: " + adapterError);
            this.listener.onAdViewAdDisplayFailed(adapterError);
        }

        public void onAdClicked(@NonNull MolocoAd molocoAd) {
            MolocoMediationAdapter.this.log("AdView ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdHidden(@NonNull MolocoAd molocoAd) {
        }
    }

    private class NativeAdViewListener
    implements AdLoad.Listener,
    NativeAd.InteractionListener {
        private final MaxAdFormat adFormat;
        private final Bundle serverParameters;
        private final Context context;
        private final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdFormat adFormat, MaxAdapterResponseParameters parameters, Context context, MaxAdViewAdapterListener listener) {
            this.adFormat = adFormat;
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onAdLoadSuccess(@NonNull MolocoAd molocoAd) {
            NativeAd loadedNativeAd = MolocoMediationAdapter.this.nativeAd;
            if (loadedNativeAd == null) {
                MolocoMediationAdapter.this.e("Native " + this.adFormat.getLabel() + " ad is null");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
                return;
            }
            MolocoMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded");
            NativeAd.Assets assets = loadedNativeAd.getAssets();
            if (assets == null) {
                MolocoMediationAdapter.this.e("Native " + this.adFormat.getLabel() + " ad assets object is null");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)assets.getTitle())) {
                MolocoMediationAdapter.this.e("Native " + this.adFormat.getLabel() + " ad (" + MolocoMediationAdapter.this.nativeAd + ") does not have required assets.");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setTitle(assets.getTitle()).setBody(assets.getDescription()).setAdvertiser(assets.getSponsorText()).setCallToAction(assets.getCallToActionText()).setStarRating(assets.getRating() != null ? Double.valueOf(assets.getRating().doubleValue()) : null);
            if (assets.getIconUri() != null) {
                builder.setIcon(new MaxNativeAd.MaxNativeAdImage(assets.getIconUri()));
            }
            if (assets.getMediaView() != null) {
                builder.setMediaView(assets.getMediaView());
            } else if (assets.getMainImageUri() != null) {
                ImageView imageView = new ImageView(this.context);
                ImageViewUtils.setImageUri((ImageView)imageView, (Uri)assets.getMainImageUri(), null);
                builder.setMediaView((View)imageView);
                builder.setMainImage(new MaxNativeAd.MaxNativeAdImage(assets.getMainImageUri()));
            }
            MaxMolocoNativeAd maxMolocoNativeAd = new MaxMolocoNativeAd(builder);
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            MaxNativeAdView maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxMolocoNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "media_banner_template", MolocoMediationAdapter.this.getApplicationContext());
            maxMolocoNativeAd.prepareForInteraction(MolocoMediationAdapter.this.getClickableViews(maxNativeAdView), (ViewGroup)maxNativeAdView);
            this.listener.onAdViewAdLoaded((View)maxNativeAdView);
            MolocoMediationAdapter.this.nativeAd.handleImpression();
        }

        public void onAdLoadFailed(@NonNull MolocoAdError molocoAdError) {
            MaxAdapterError adapterError = MolocoMediationAdapter.this.toMaxError(molocoAdError);
            MolocoMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onImpressionHandled() {
            MolocoMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad displayed");
            this.listener.onAdViewAdDisplayed();
        }

        public void onGeneralClickHandled() {
            MolocoMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked");
            this.listener.onAdViewAdClicked();
        }
    }

    private class MaxMolocoNativeAd
    extends MaxNativeAd {
        public MaxMolocoNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = MolocoMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                MolocoMediationAdapter.this.e("Failed to register native ad view: native ad is null.");
                return false;
            }
            MolocoMediationAdapter.this.d("Preparing views for interaction: " + clickableViews + " with container: " + container);
            for (View clickableView : clickableViews) {
                clickableView.setOnClickListener(view -> nativeAd.handleGeneralAdClick());
            }
            if (this.getFormat() == MaxAdFormat.NATIVE) {
                nativeAd.handleImpression();
            }
            return true;
        }
    }
}

