/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.ogury.core.OguryError;
import com.ogury.ed.OguryAdImpressionListener;
import com.ogury.ed.OguryBannerAdListener;
import com.ogury.ed.OguryBannerAdSize;
import com.ogury.ed.OguryBannerAdView;
import com.ogury.ed.OguryInterstitialAd;
import com.ogury.ed.OguryInterstitialAdListener;
import com.ogury.ed.OguryOptinVideoAd;
import com.ogury.ed.OguryOptinVideoAdListener;
import com.ogury.ed.OguryReward;
import com.ogury.sdk.Ogury;
import com.ogury.sdk.OguryConfiguration;
import io.presage.common.Mediation;
import io.presage.common.token.OguryTokenProvider;
import java.util.concurrent.atomic.AtomicBoolean;

public class OguryPresageMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private OguryInterstitialAd interstitialAd;
    private OguryOptinVideoAd rewardedAd;
    private OguryBannerAdView adView;
    private boolean isFinishedLoading;

    public OguryPresageMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (INITIALIZED.compareAndSet(false, true)) {
            String assetKey = parameters.getServerParameters().getString("asset_key");
            this.log("Initializing Ogury Presage SDK with asset key: " + assetKey + "...");
            OguryConfiguration.Builder oguryConfigurationBuilder = new OguryConfiguration.Builder(this.getContext(activity), assetKey).putMonitoringInfo("max_applovin_mediation_version", AppLovinSdk.VERSION);
            Ogury.start((OguryConfiguration)oguryConfigurationBuilder.build());
        }
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    public String getSdkVersion() {
        return Ogury.getSdkVersion();
    }

    public String getAdapterVersion() {
        return "5.8.0.0";
    }

    public void onDestroy() {
        this.interstitialAd = null;
        this.rewardedAd = null;
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        String bidderToken = OguryTokenProvider.getBidderToken((Context)this.getContext(activity));
        callback.onSignalCollected(bidderToken);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + "interstitial ad: " + placementId + "...");
        this.interstitialAd = new OguryInterstitialAd(this.getContext(activity), placementId, new Mediation("AppLovin MAX", AppLovinSdk.VERSION));
        InterstitialAdListener adListener = new InterstitialAdListener(placementId, listener);
        this.interstitialAd.setListener((OguryInterstitialAdListener)adListener);
        this.interstitialAd.setAdImpressionListener((OguryAdImpressionListener)adListener);
        if (this.interstitialAd.isLoaded()) {
            this.log("Ad is available already");
            listener.onInterstitialAdLoaded();
        } else {
            if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
                this.interstitialAd.setAdMarkup(bidResponse);
            }
            this.interstitialAd.load();
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad: " + placementId + "...");
        if (this.interstitialAd.isLoaded()) {
            this.isFinishedLoading = true;
            this.interstitialAd.show();
        } else {
            this.log("Interstitial ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + "rewarded ad: " + placementId + "...");
        this.rewardedAd = new OguryOptinVideoAd(this.getContext(activity), placementId, new Mediation("AppLovin MAX", AppLovinSdk.VERSION));
        RewardedAdListener adListener = new RewardedAdListener(placementId, listener);
        this.rewardedAd.setListener((OguryOptinVideoAdListener)adListener);
        this.rewardedAd.setAdImpressionListener((OguryAdImpressionListener)adListener);
        if (this.rewardedAd.isLoaded()) {
            this.log("Ad is available already");
            listener.onRewardedAdLoaded();
        } else {
            if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
                this.rewardedAd.setAdMarkup(bidResponse);
            }
            this.rewardedAd.load();
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad: " + placementId + "...");
        if (this.rewardedAd.isLoaded()) {
            this.configureReward(parameters);
            this.isFinishedLoading = true;
            this.rewardedAd.show();
        } else {
            this.log("Rewarded ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + adFormat.getLabel() + " ad: " + placementId + "...");
        this.adView = new OguryBannerAdView(this.getContext(activity), new Mediation("AppLovin MAX", AppLovinSdk.VERSION));
        this.adView.setAdSize(this.toAdSize(adFormat));
        this.adView.setAdUnit(placementId);
        AdViewListener adListener = new AdViewListener(placementId, listener);
        this.adView.setListener((OguryBannerAdListener)adListener);
        this.adView.setAdImpressionListener((OguryAdImpressionListener)adListener);
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            this.adView.setAdMarkup(bidResponse);
        }
        this.adView.loadAd();
    }

    private static MaxAdapterError toMaxError(OguryError oguryError) {
        int oguryErrorCode = oguryError.getErrorCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (oguryErrorCode) {
            case 0: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 2000: {
                adapterError = MaxAdapterError.UNSPECIFIED;
                break;
            }
            case 2001: 
            case 2002: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case 2003: {
                adapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case 2004: 
            case 2006: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case 2005: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case 2007: 
            case 2010: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 2008: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 2009: {
                adapterError = MaxAdapterError.AD_NOT_READY;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), oguryErrorCode, oguryError.getMessage());
    }

    private OguryBannerAdSize toAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER || adFormat == MaxAdFormat.LEADER) {
            return OguryBannerAdSize.SMALL_BANNER_320x50;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return OguryBannerAdSize.MPU_300x250;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private Context getContext(Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class InterstitialAdListener
    implements OguryInterstitialAdListener,
    OguryAdImpressionListener {
        private final String placementId;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(String placementId, MaxInterstitialAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdLoaded() {
            OguryPresageMediationAdapter.this.log("Interstitial loaded: " + this.placementId);
            this.listener.onInterstitialAdLoaded();
        }

        public void onAdDisplayed() {
            OguryPresageMediationAdapter.this.log("Interstitial shown: " + this.placementId);
        }

        public void onAdImpression() {
            OguryPresageMediationAdapter.this.log("Interstitial triggered impression: " + this.placementId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            OguryPresageMediationAdapter.this.log("Interstitial clicked: " + this.placementId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdClosed() {
            OguryPresageMediationAdapter.this.log("Interstitial hidden: " + this.placementId);
            this.listener.onInterstitialAdHidden();
        }

        public void onAdError(OguryError oguryError) {
            if (OguryPresageMediationAdapter.this.isFinishedLoading) {
                OguryPresageMediationAdapter.this.log("Interstitial (" + this.placementId + ") failed to show with error: " + oguryError);
                this.listener.onInterstitialAdDisplayFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            } else {
                OguryPresageMediationAdapter.this.log("Interstitial (" + this.placementId + ") failed to load with error: " + oguryError);
                this.listener.onInterstitialAdLoadFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            }
        }
    }

    private class RewardedAdListener
    implements OguryOptinVideoAdListener,
    OguryAdImpressionListener {
        private final String placementId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(String placementId, MaxRewardedAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdLoaded() {
            OguryPresageMediationAdapter.this.log("Rewarded ad loaded: " + this.placementId);
            this.listener.onRewardedAdLoaded();
        }

        public void onAdDisplayed() {
            OguryPresageMediationAdapter.this.log("Rewarded ad shown: " + this.placementId);
        }

        public void onAdImpression() {
            OguryPresageMediationAdapter.this.log("Rewarded ad triggered impression: " + this.placementId);
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked() {
            OguryPresageMediationAdapter.this.log("Rewarded ad clicked: " + this.placementId);
            this.listener.onRewardedAdClicked();
        }

        public void onAdClosed() {
            if (this.hasGrantedReward || OguryPresageMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = OguryPresageMediationAdapter.this.getReward();
                OguryPresageMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            OguryPresageMediationAdapter.this.log("Rewarded ad hidden: " + this.placementId);
            this.listener.onRewardedAdHidden();
        }

        public void onAdRewarded(OguryReward oguryReward) {
            OguryPresageMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") granted reward with rewardName: " + oguryReward.getName() + ", rewardValue: " + oguryReward.getValue());
            this.hasGrantedReward = true;
        }

        public void onAdError(OguryError oguryError) {
            if (OguryPresageMediationAdapter.this.isFinishedLoading) {
                OguryPresageMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") failed to show with error: " + oguryError);
                this.listener.onRewardedAdDisplayFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            } else {
                OguryPresageMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") failed to load with error: " + oguryError);
                this.listener.onRewardedAdLoadFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            }
        }
    }

    private class AdViewListener
    implements OguryBannerAdListener,
    OguryAdImpressionListener {
        private final String placementId;
        private final MaxAdViewAdapterListener listener;

        AdViewListener(String placementId, MaxAdViewAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdLoaded() {
            OguryPresageMediationAdapter.this.log("AdView loaded: " + this.placementId);
            OguryPresageMediationAdapter.this.isFinishedLoading = true;
            this.listener.onAdViewAdLoaded((View)OguryPresageMediationAdapter.this.adView);
        }

        public void onAdDisplayed() {
            OguryPresageMediationAdapter.this.log("AdView shown: " + this.placementId);
        }

        public void onAdImpression() {
            OguryPresageMediationAdapter.this.log("AdView triggered impression: " + this.placementId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked() {
            OguryPresageMediationAdapter.this.log("AdView clicked: " + this.placementId);
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed() {
            OguryPresageMediationAdapter.this.log("AdView ad hidden: " + this.placementId);
        }

        public void onAdError(OguryError oguryError) {
            if (OguryPresageMediationAdapter.this.isFinishedLoading) {
                OguryPresageMediationAdapter.this.log("AdView ad (" + this.placementId + ") failed to show with error: " + oguryError);
                this.listener.onAdViewAdDisplayFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            } else {
                OguryPresageMediationAdapter.this.log("AdView ad (" + this.placementId + ") failed to load with error: " + oguryError);
                this.listener.onAdViewAdLoadFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            }
        }
    }
}

