/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.ogury.ad.OguryAdError;
import com.ogury.ad.OguryBannerAdSize;
import com.ogury.ad.OguryBannerAdView;
import com.ogury.ad.OguryBannerAdViewListener;
import com.ogury.ad.OguryBidTokenListener;
import com.ogury.ad.OguryBidTokenProvider;
import com.ogury.ad.OguryInterstitialAd;
import com.ogury.ad.OguryInterstitialAdListener;
import com.ogury.ad.OguryReward;
import com.ogury.ad.OguryRewardedAd;
import com.ogury.ad.OguryRewardedAdListener;
import com.ogury.ad.common.OguryMediation;
import com.ogury.core.OguryError;
import com.ogury.sdk.Ogury;
import com.ogury.sdk.OguryOnStartListener;
import java.util.concurrent.atomic.AtomicBoolean;

public class OguryPresageMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private OguryInterstitialAd interstitialAd;
    private OguryRewardedAd rewardedAd;
    private OguryBannerAdView adView;

    public OguryPresageMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            String assetKey = parameters.getServerParameters().getString("asset_key");
            this.log("Initializing Ogury Presage SDK with asset key: " + assetKey + "...");
            Ogury.start((Context)this.getContext(activity), (String)assetKey, (OguryOnStartListener)new OguryOnStartListener(){

                public void onStarted() {
                    OguryPresageMediationAdapter.this.log("Ogury Presage SDK initialized");
                    status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(status, null);
                }

                public void onFailed(@NonNull OguryError oguryError) {
                    OguryPresageMediationAdapter.this.log("Ogury Presage SDK failed to initialize with error: " + oguryError);
                    status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(status, oguryError.getMessage());
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return Ogury.getSdkVersion();
    }

    public String getAdapterVersion() {
        return "6.0.0.0";
    }

    public void onDestroy() {
        this.interstitialAd = null;
        this.rewardedAd = null;
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, final MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        OguryBidTokenProvider.getBidToken((Context)this.getContext(activity), (OguryBidTokenListener)new OguryBidTokenListener(){

            public void onBidTokenGenerated(@NonNull String signal) {
                OguryPresageMediationAdapter.this.log("Signal collection successful");
                callback.onSignalCollected(signal);
            }

            public void onBidTokenGenerationFailed(@NonNull OguryError oguryError) {
                OguryPresageMediationAdapter.this.log("Signal collection failed with error: " + oguryError);
                callback.onSignalCollectionFailed(oguryError.getMessage());
            }
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + "interstitial ad: " + placementId + "...");
        this.interstitialAd = new OguryInterstitialAd(this.getContext(activity), placementId, new OguryMediation("AppLovin MAX", AppLovinSdk.VERSION));
        InterstitialAdListener adListener = new InterstitialAdListener(placementId, listener);
        this.interstitialAd.setListener((OguryInterstitialAdListener)adListener);
        if (this.interstitialAd.isLoaded()) {
            this.log("Ad is available already");
            listener.onInterstitialAdLoaded();
            return;
        }
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            this.interstitialAd.load(bidResponse);
        } else {
            this.interstitialAd.load();
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad: " + placementId + "...");
        if (!this.interstitialAd.isLoaded()) {
            this.log("Interstitial ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
            return;
        }
        this.interstitialAd.show();
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + "rewarded ad: " + placementId + "...");
        this.rewardedAd = new OguryRewardedAd(this.getContext(activity), placementId, new OguryMediation("AppLovin MAX", AppLovinSdk.VERSION));
        RewardedAdListener adListener = new RewardedAdListener(placementId, listener);
        this.rewardedAd.setListener((OguryRewardedAdListener)adListener);
        if (this.rewardedAd.isLoaded()) {
            this.log("Ad is available already");
            listener.onRewardedAdLoaded();
            return;
        }
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            this.rewardedAd.load(bidResponse);
        } else {
            this.rewardedAd.load();
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad: " + placementId + "...");
        if (!this.rewardedAd.isLoaded()) {
            this.log("Rewarded ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
            return;
        }
        this.configureReward(parameters);
        this.rewardedAd.show();
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + adFormat.getLabel() + " ad: " + placementId + "...");
        this.adView = new OguryBannerAdView(this.getContext(activity), placementId, this.toAdSize(adFormat));
        AdViewListener adListener = new AdViewListener(placementId, listener);
        this.adView.setListener((OguryBannerAdViewListener)adListener);
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            this.adView.load(bidResponse);
        } else {
            this.adView.load();
        }
    }

    private static MaxAdapterError toMaxError(OguryAdError oguryError) {
        int oguryErrorCode = oguryError.getCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (oguryErrorCode) {
            case 2104: {
                adapterError = MaxAdapterError.UNSPECIFIED;
                break;
            }
            case 2002: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 2100: 
            case 2101: 
            case 2102: 
            case 2103: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case 2000: 
            case 2001: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case 2200: {
                adapterError = MaxAdapterError.SERVER_ERROR;
                break;
            }
            case 2202: 
            case 2300: 
            case 2301: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 2201: {
                adapterError = MaxAdapterError.NO_FILL;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), oguryErrorCode, oguryError.getMessage());
    }

    private OguryBannerAdSize toAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER || adFormat == MaxAdFormat.LEADER) {
            return OguryBannerAdSize.SMALL_BANNER_320x50;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return OguryBannerAdSize.MREC_300x250;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class InterstitialAdListener
    implements OguryInterstitialAdListener {
        private final String placementId;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(String placementId, MaxInterstitialAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull OguryInterstitialAd interstitialAd) {
            OguryPresageMediationAdapter.this.log("Interstitial loaded: " + this.placementId);
            this.listener.onInterstitialAdLoaded();
        }

        public void onAdImpression(@NonNull OguryInterstitialAd interstitialAd) {
            OguryPresageMediationAdapter.this.log("Interstitial triggered impression: " + this.placementId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked(@NonNull OguryInterstitialAd interstitialAd) {
            OguryPresageMediationAdapter.this.log("Interstitial clicked: " + this.placementId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdClosed(@NonNull OguryInterstitialAd interstitialAd) {
            OguryPresageMediationAdapter.this.log("Interstitial hidden: " + this.placementId);
            this.listener.onInterstitialAdHidden();
        }

        public void onAdError(@NonNull OguryInterstitialAd interstitialAd, @NonNull OguryAdError oguryError) {
            if (oguryError.getType() == OguryAdError.Type.SHOW_ERROR) {
                OguryPresageMediationAdapter.this.log("Interstitial (" + this.placementId + ") failed to show with error: " + oguryError);
                this.listener.onInterstitialAdDisplayFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            } else {
                OguryPresageMediationAdapter.this.log("Interstitial (" + this.placementId + ") failed to load with error: " + oguryError);
                this.listener.onInterstitialAdLoadFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            }
        }
    }

    private class RewardedAdListener
    implements OguryRewardedAdListener {
        private final String placementId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(String placementId, MaxRewardedAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull OguryRewardedAd rewardedAd) {
            OguryPresageMediationAdapter.this.log("Rewarded ad loaded: " + this.placementId);
            this.listener.onRewardedAdLoaded();
        }

        public void onAdImpression(@NonNull OguryRewardedAd rewardedAd) {
            OguryPresageMediationAdapter.this.log("Rewarded ad triggered impression: " + this.placementId);
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked(@NonNull OguryRewardedAd rewardedAd) {
            OguryPresageMediationAdapter.this.log("Rewarded ad clicked: " + this.placementId);
            this.listener.onRewardedAdClicked();
        }

        public void onAdClosed(@NonNull OguryRewardedAd rewardedAd) {
            if (this.hasGrantedReward || OguryPresageMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = OguryPresageMediationAdapter.this.getReward();
                OguryPresageMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            OguryPresageMediationAdapter.this.log("Rewarded ad hidden: " + this.placementId);
            this.listener.onRewardedAdHidden();
        }

        public void onAdRewarded(@NonNull OguryRewardedAd rewardedAd, OguryReward oguryReward) {
            OguryPresageMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") granted reward with rewardName: " + oguryReward.getName() + ", rewardValue: " + oguryReward.getValue());
            this.hasGrantedReward = true;
        }

        public void onAdError(@NonNull OguryRewardedAd rewardedAd, OguryAdError oguryError) {
            if (oguryError.getType() == OguryAdError.Type.SHOW_ERROR) {
                OguryPresageMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") failed to show with error: " + oguryError);
                this.listener.onRewardedAdDisplayFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            } else {
                OguryPresageMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") failed to load with error: " + oguryError);
                this.listener.onRewardedAdLoadFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            }
        }
    }

    private class AdViewListener
    implements OguryBannerAdViewListener {
        private final String placementId;
        private final MaxAdViewAdapterListener listener;

        AdViewListener(String placementId, MaxAdViewAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull OguryBannerAdView bannerAd) {
            OguryPresageMediationAdapter.this.log("AdView loaded: " + this.placementId);
            this.listener.onAdViewAdLoaded((View)OguryPresageMediationAdapter.this.adView);
        }

        public void onAdImpression(@NonNull OguryBannerAdView bannerAd) {
            OguryPresageMediationAdapter.this.log("AdView triggered impression: " + this.placementId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked(@NonNull OguryBannerAdView bannerAd) {
            OguryPresageMediationAdapter.this.log("AdView clicked: " + this.placementId);
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed(@NonNull OguryBannerAdView bannerAd) {
            OguryPresageMediationAdapter.this.log("AdView ad hidden: " + this.placementId);
        }

        public void onAdError(@NonNull OguryBannerAdView bannerAd, @NonNull OguryAdError oguryError) {
            if (oguryError.getType() == OguryAdError.Type.SHOW_ERROR) {
                OguryPresageMediationAdapter.this.log("AdView ad (" + this.placementId + ") failed to show with error: " + oguryError);
                this.listener.onAdViewAdDisplayFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            } else {
                OguryPresageMediationAdapter.this.log("AdView ad (" + this.placementId + ") failed to load with error: " + oguryError);
                this.listener.onAdViewAdLoadFailed(OguryPresageMediationAdapter.toMaxError(oguryError));
            }
        }
    }
}

