/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.banners.BannerErrorCode;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class UnityAdsMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus initializationStatus;
    private String biddingAdId;
    private BannerView bannerView;

    public UnityAdsMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        Context context = this.getContext(activity);
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, context);
        if (initialized.compareAndSet(false, true)) {
            Bundle serverParameters = parameters.getServerParameters();
            String gameId = serverParameters.getString("game_id", null);
            this.log("Initializing UnityAds SDK with game id: " + gameId + "...");
            initializationStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            MediationMetaData mediationMetaData = new MediationMetaData(context);
            mediationMetaData.setName("MAX");
            mediationMetaData.setVersion(AppLovinSdk.VERSION);
            mediationMetaData.set("adapter_version", (Object)this.getAdapterVersion());
            mediationMetaData.commit();
            UnityAds.setDebugMode((boolean)parameters.isTesting());
            UnityAds.initialize((Context)context, (String)gameId, (boolean)parameters.isTesting(), (IUnityAdsInitializationListener)new IUnityAdsInitializationListener(){

                public void onInitializationComplete() {
                    UnityAdsMediationAdapter.this.log("UnityAds SDK initialized");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
                }

                public void onInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
                    UnityAdsMediationAdapter.this.log("UnityAds SDK failed to initialize with error: " + message);
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, message);
                }
            });
        } else {
            this.log("UnityAds SDK already initialized");
            onCompletionListener.onCompletion(initializationStatus, null);
        }
    }

    public String getSdkVersion() {
        return UnityAds.getVersion();
    }

    public String getAdapterVersion() {
        return "4.12.3.0";
    }

    public void onDestroy() {
        if (this.bannerView != null) {
            this.bannerView.destroy();
            this.bannerView = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, final MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        UnityAds.getToken((IUnityAdsTokenListener)new IUnityAdsTokenListener(){

            public void onUnityAdsTokenReady(String token) {
                UnityAdsMediationAdapter.this.log("Collected signal");
                callback.onSignalCollected(token);
            }
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "interstitial ad for placement \"" + placementId + "\"...");
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        this.biddingAdId = UUID.randomUUID().toString();
        UnityAds.load((String)placementId, (UnityAdsLoadOptions)this.createAdLoadOptions(parameters), (IUnityAdsLoadListener)new IUnityAdsLoadListener(){

            public void onUnityAdsAdLoaded(String placementId) {
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" loaded");
                listener.onInterstitialAdLoaded();
            }

            public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" failed to load with error: " + error + ": " + message);
                listener.onInterstitialAdLoadFailed(UnityAdsMediationAdapter.toMaxError(error, message));
            }
        });
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad for placement \"" + placementId + "\"...");
        UnityAds.show((Activity)activity, (String)placementId, (UnityAdsShowOptions)this.createAdShowOptions(), (IUnityAdsShowListener)new IUnityAdsShowListener(){

            public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" failed to display with error: " + error + ": " + message);
                listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", error.ordinal(), message));
            }

            public void onUnityAdsShowStart(String placementId) {
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" displayed");
                listener.onInterstitialAdDisplayed();
            }

            public void onUnityAdsShowClick(String placementId) {
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" clicked");
                listener.onInterstitialAdClicked();
            }

            public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" hidden with completion state: " + state);
                listener.onInterstitialAdHidden();
            }
        });
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "rewarded ad for placement \"" + placementId + "\"...");
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        this.biddingAdId = UUID.randomUUID().toString();
        UnityAds.load((String)placementId, (UnityAdsLoadOptions)this.createAdLoadOptions(parameters), (IUnityAdsLoadListener)new IUnityAdsLoadListener(){

            public void onUnityAdsAdLoaded(String placementId) {
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" loaded");
                listener.onRewardedAdLoaded();
            }

            public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" failed to load with error: " + error + ": " + message);
                listener.onRewardedAdLoadFailed(UnityAdsMediationAdapter.toMaxError(error, message));
            }
        });
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad for placement \"" + placementId + "\"...");
        this.configureReward(parameters);
        UnityAds.show((Activity)activity, (String)placementId, (UnityAdsShowOptions)this.createAdShowOptions(), (IUnityAdsShowListener)new IUnityAdsShowListener(){

            public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" failed to display with error: " + error + ": " + message);
                listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", error.ordinal(), message));
            }

            public void onUnityAdsShowStart(String placementId) {
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" displayed");
                listener.onRewardedAdDisplayed();
            }

            public void onUnityAdsShowClick(String placementId) {
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" clicked");
                listener.onRewardedAdClicked();
            }

            public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" hidden with completion state: " + state);
                if (state == UnityAds.UnityAdsShowCompletionState.COMPLETED || UnityAdsMediationAdapter.this.shouldAlwaysRewardUser()) {
                    listener.onUserRewarded(UnityAdsMediationAdapter.this.getReward());
                }
                listener.onRewardedAdHidden();
            }
        });
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, final MaxAdFormat adFormat, Activity activity, final MaxAdViewAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + adFormat.getLabel() + " ad for placement \"" + placementId + "\"...");
        if (activity == null) {
            this.log(adFormat.getLabel() + " ad placement \"" + placementId + "\" load failed: Activity is null");
            MaxAdapterError error = new MaxAdapterError(-5601, "Missing Activity");
            listener.onAdViewAdLoadFailed(error);
            return;
        }
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        this.biddingAdId = UUID.randomUUID().toString();
        this.bannerView = new BannerView(activity, placementId, this.toUnityBannerSize(adFormat));
        this.bannerView.setListener(new BannerView.IListener(){

            public void onBannerLoaded(BannerView bannerAdView) {
                UnityAdsMediationAdapter.this.log(adFormat.getLabel() + " ad placement \"" + placementId + "\" loaded");
                listener.onAdViewAdLoaded((View)bannerAdView);
            }

            public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
                UnityAdsMediationAdapter.this.log(adFormat.getLabel() + " ad placement \"" + placementId + "\" failed to load");
                listener.onAdViewAdLoadFailed(UnityAdsMediationAdapter.toMaxError(errorInfo));
            }

            public void onBannerShown(BannerView bannerAdView) {
                UnityAdsMediationAdapter.this.log(adFormat.getLabel() + " ad placement \"" + placementId + "\" shown");
                listener.onAdViewAdDisplayed();
            }

            public void onBannerClick(BannerView bannerAdView) {
                UnityAdsMediationAdapter.this.log(adFormat.getLabel() + " ad placement \"" + placementId + "\" clicked");
                listener.onAdViewAdClicked();
            }

            public void onBannerLeftApplication(BannerView bannerView) {
                UnityAdsMediationAdapter.this.log(adFormat.getLabel() + " ad placement \"" + placementId + "\" left application");
            }
        });
        this.bannerView.load(this.createAdLoadOptions(parameters));
    }

    private UnityAdsLoadOptions createAdLoadOptions(MaxAdapterResponseParameters parameters) {
        UnityAdsLoadOptions options = new UnityAdsLoadOptions();
        String bidResponse = parameters.getBidResponse();
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            options.setAdMarkup(bidResponse);
        }
        if (AppLovinSdkUtils.isValidString((String)this.biddingAdId)) {
            options.setObjectId(this.biddingAdId);
        }
        return options;
    }

    private UnityAdsShowOptions createAdShowOptions() {
        UnityAdsShowOptions options = new UnityAdsShowOptions();
        if (AppLovinSdkUtils.isValidString((String)this.biddingAdId)) {
            options.setObjectId(this.biddingAdId);
        }
        return options;
    }

    private UnityBannerSize toUnityBannerSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return new UnityBannerSize(320, 50);
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return new UnityBannerSize(728, 90);
        }
        if (adFormat == MaxAdFormat.MREC) {
            return new UnityBannerSize(300, 250);
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    private static MaxAdapterError toMaxError(BannerErrorInfo unityAdsBannerError) {
        MaxAdapterError adapterError = unityAdsBannerError.errorCode == BannerErrorCode.NO_FILL ? MaxAdapterError.NO_FILL : (unityAdsBannerError.errorCode == BannerErrorCode.NATIVE_ERROR ? MaxAdapterError.INTERNAL_ERROR : (unityAdsBannerError.errorCode == BannerErrorCode.WEBVIEW_ERROR ? MaxAdapterError.WEBVIEW_ERROR : MaxAdapterError.UNSPECIFIED));
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), unityAdsBannerError.errorCode.ordinal(), unityAdsBannerError.errorMessage);
    }

    private static MaxAdapterError toMaxError(UnityAds.UnityAdsLoadError loadError, String errorMessage) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (loadError) {
            case INITIALIZE_FAILED: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case INTERNAL_ERROR: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case INVALID_ARGUMENT: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case NO_FILL: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case TIMEOUT: {
                adapterError = MaxAdapterError.TIMEOUT;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), loadError.ordinal(), errorMessage);
    }

    private static MaxAdapterError toMaxError(UnityAds.UnityAdsShowError showError, String errorMessage) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (showError) {
            case NOT_INITIALIZED: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case NOT_READY: {
                adapterError = MaxAdapterError.AD_NOT_READY;
                break;
            }
            case VIDEO_PLAYER_ERROR: {
                adapterError = MaxAdapterError.WEBVIEW_ERROR;
                break;
            }
            case INVALID_ARGUMENT: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case NO_CONNECTION: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case ALREADY_SHOWING: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case INTERNAL_ERROR: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), showError.ordinal(), errorMessage);
    }

    private void updatePrivacyConsent(MaxAdapterParameters parameters, Context context) {
        Boolean isDoNotSell;
        MetaData privacyMetaData = new MetaData(context);
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            privacyMetaData.set("gdpr.consent", (Object)hasUserConsent);
            privacyMetaData.commit();
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null) {
            privacyMetaData.set("privacy.consent", (Object)(isDoNotSell == false ? 1 : 0));
            privacyMetaData.commit();
        }
        privacyMetaData.set("privacy.mode", (Object)"mixed");
        privacyMetaData.commit();
    }

    private Context getContext(Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }
}

