/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.vungle.ads.AdConfig;
import com.vungle.ads.BannerAdListener;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.BuildConfig;
import com.vungle.ads.InitializationListener;
import com.vungle.ads.InterstitialAd;
import com.vungle.ads.InterstitialAdListener;
import com.vungle.ads.NativeAd;
import com.vungle.ads.NativeAdListener;
import com.vungle.ads.RewardedAd;
import com.vungle.ads.RewardedAdListener;
import com.vungle.ads.VungleAdSize;
import com.vungle.ads.VungleAds;
import com.vungle.ads.VungleBannerView;
import com.vungle.ads.VungleError;
import com.vungle.ads.VunglePrivacySettings;
import com.vungle.ads.internal.ui.view.MediaView;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class VungleMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus initializationStatus;
    private VungleBannerView adViewAd;
    private InterstitialAd interstitialAd;
    private RewardedAd rewardedAd;
    private NativeAd nativeAd;
    private InterstitialAd appOpenAd;

    public VungleMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.updateUserPrivacySettings((MaxAdapterParameters)parameters);
        if (initialized.compareAndSet(false, true)) {
            String appId = parameters.getServerParameters().getString("app_id", null);
            this.log("Initializing Vungle SDK with app id: " + appId + "...");
            initializationStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            VungleAds.setIntegrationName((VungleAds.WrapperFramework)VungleAds.WrapperFramework.max, (String)this.getAdapterVersion());
            VungleAds.init((Context)this.getContext(activity), (String)appId, (InitializationListener)new InitializationListener(){

                public void onSuccess() {
                    VungleMediationAdapter.this.log("Vungle SDK initialized");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(initializationStatus, null);
                }

                public void onError(@NonNull VungleError vungleError) {
                    initialized.set(false);
                    VungleMediationAdapter.this.log("Vungle SDK failed to initialize with error: ", (Throwable)vungleError);
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(initializationStatus, vungleError.getErrorMessage());
                }
            });
        } else {
            this.log("Vungle SDK already initialized");
            onCompletionListener.onCompletion(initializationStatus, null);
        }
    }

    public String getSdkVersion() {
        return this.getVersionString(BuildConfig.class, "VERSION_NAME");
    }

    public String getAdapterVersion() {
        return "7.4.1.4";
    }

    public void onDestroy() {
        if (this.adViewAd != null) {
            this.adViewAd.setAdListener(null);
            this.adViewAd.finishAd();
            this.adViewAd = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.setAdListener(null);
            this.nativeAd.unregisterView();
            this.nativeAd = null;
        }
        if (this.interstitialAd != null) {
            this.interstitialAd.setAdListener(null);
            this.interstitialAd = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.setAdListener(null);
            this.rewardedAd = null;
        }
        if (this.appOpenAd != null) {
            this.appOpenAd.setAdListener(null);
            this.appOpenAd = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updateUserPrivacySettings((MaxAdapterParameters)parameters);
        String signal = VungleAds.getBiddingToken((Context)this.getContext(activity));
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "interstitial ad for placement: " + placementId + "...");
        if (this.shouldFailAdLoadWhenSdkNotInitialized(parameters) && !VungleAds.isInitialized()) {
            this.log("Vungle SDK not successfully initialized: failing interstitial ad load...");
            listener.onInterstitialAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserPrivacySettings((MaxAdapterParameters)parameters);
        this.interstitialAd = new InterstitialAd(this.getContext(activity), placementId, new AdConfig());
        this.interstitialAd.setAdListener((BaseAdListener)new InterstitialListener(listener));
        this.interstitialAd.load(bidResponse);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        if (this.interstitialAd != null && this.interstitialAd.canPlayAd().booleanValue()) {
            this.log("Showing interstitial ad for placement: " + parameters.getThirdPartyAdPlacementId() + "...");
            this.interstitialAd.play(this.getContext(activity));
        } else {
            this.log("Interstitial ad is not ready: " + parameters.getThirdPartyAdPlacementId() + "...");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad is not ready"));
        }
    }

    public void loadAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "app open ad for placement: " + placementId + "...");
        if (this.shouldFailAdLoadWhenSdkNotInitialized(parameters) && !VungleAds.isInitialized()) {
            this.log("Vungle SDK not successfully initialized: failing app open ad load...");
            listener.onAppOpenAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserPrivacySettings((MaxAdapterParameters)parameters);
        this.appOpenAd = new InterstitialAd(this.getContext(activity), placementId, new AdConfig());
        this.appOpenAd.setAdListener((BaseAdListener)new AppOpenAdListener(listener));
        this.appOpenAd.load(bidResponse);
    }

    public void showAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        if (this.appOpenAd != null && this.appOpenAd.canPlayAd().booleanValue()) {
            this.log("Showing app open ad for placement: " + parameters.getThirdPartyAdPlacementId() + "...");
            this.appOpenAd.play(this.getContext(activity));
        } else {
            this.log("App open ad is not ready: " + parameters.getThirdPartyAdPlacementId() + "...");
            listener.onAppOpenAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "App open ad is not ready"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "rewarded ad for placement: " + placementId + "...");
        if (this.shouldFailAdLoadWhenSdkNotInitialized(parameters) && !VungleAds.isInitialized()) {
            this.log("Vungle SDK not successfully initialized: failing rewarded ad load...");
            listener.onRewardedAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserPrivacySettings((MaxAdapterParameters)parameters);
        this.rewardedAd = new RewardedAd(this.getContext(activity), placementId, new AdConfig());
        this.rewardedAd.setAdListener((BaseAdListener)new RewardedListener(listener));
        this.rewardedAd.load(bidResponse);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        if (this.rewardedAd != null && this.rewardedAd.canPlayAd().booleanValue()) {
            this.log("Showing rewarded ad for placement: " + parameters.getThirdPartyAdPlacementId() + "...");
            this.configureReward(parameters);
            this.rewardedAd.play(this.getContext(activity));
        } else {
            this.log("Rewarded ad is not ready: " + parameters.getThirdPartyAdPlacementId() + "...");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad is not ready"));
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        String adFormatLabel = adFormat.getLabel();
        String placementId = parameters.getThirdPartyAdPlacementId();
        Context context = this.getContext(activity);
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + (isNative ? "native " : "") + adFormatLabel + " ad for placement: " + placementId + "...");
        if (this.shouldFailAdLoadWhenSdkNotInitialized(parameters) && !VungleAds.isInitialized()) {
            this.log("Vungle SDK not successfully initialized: failing " + adFormatLabel + " ad load...");
            listener.onAdViewAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserPrivacySettings((MaxAdapterParameters)parameters);
        if (isNative) {
            NativeAdViewListener nativeAdViewListener = new NativeAdViewListener(parameters, adFormat, context, listener);
            this.nativeAd = new NativeAd(this.getContext(activity), placementId);
            this.nativeAd.setAdListener((BaseAdListener)nativeAdViewListener);
            this.nativeAd.load(bidResponse);
            return;
        }
        VungleAdSize adSize = VungleMediationAdapter.vungleAdSize(adFormat);
        this.adViewAd = new VungleBannerView(context, placementId, adSize);
        this.adViewAd.setAdListener((BannerAdListener)new AdViewAdListener(adFormatLabel, listener));
        this.adViewAd.load(bidResponse);
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxNativeAdAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "native ad for placement: " + placementId + "...");
        if (this.shouldFailAdLoadWhenSdkNotInitialized(parameters) && !VungleAds.isInitialized()) {
            this.log("Vungle SDK not successfully initialized: failing interstitial ad load...");
            listener.onNativeAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserPrivacySettings((MaxAdapterParameters)parameters);
        this.nativeAd = new NativeAd(this.getContext(activity), placementId);
        this.nativeAd.setAdListener((BaseAdListener)new NativeListener(parameters, this.getContext(activity), listener));
        this.nativeAd.load(bidResponse);
    }

    private boolean shouldFailAdLoadWhenSdkNotInitialized(MaxAdapterResponseParameters parameters) {
        return parameters.getServerParameters().getBoolean("fail_ad_load_when_sdk_not_initialized", true);
    }

    private void updateUserPrivacySettings(MaxAdapterParameters parameters) {
        Boolean isDoNotSell;
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            VunglePrivacySettings.setGDPRStatus((boolean)hasUserConsent, (String)"");
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null) {
            VunglePrivacySettings.setCCPAStatus((isDoNotSell == false ? 1 : 0) != 0);
        }
    }

    private static VungleAdSize vungleAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return VungleAdSize.BANNER;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return VungleAdSize.BANNER_LEADERBOARD;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return VungleAdSize.MREC;
        }
        throw new IllegalArgumentException("Unsupported ad view ad format: " + adFormat.getLabel());
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private List<View> getClickableViews(MaxNativeAdView maxNativeAdView) {
        ArrayList<View> clickableViews = new ArrayList<View>(6);
        if (maxNativeAdView.getTitleTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getTitleTextView());
        }
        if (maxNativeAdView.getAdvertiserTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
        }
        if (maxNativeAdView.getBodyTextView() != null) {
            clickableViews.add((View)maxNativeAdView.getBodyTextView());
        }
        if (maxNativeAdView.getCallToActionButton() != null) {
            clickableViews.add((View)maxNativeAdView.getCallToActionButton());
        }
        if (maxNativeAdView.getIconImageView() != null) {
            clickableViews.add((View)maxNativeAdView.getIconImageView());
        }
        if (maxNativeAdView.getMediaContentViewGroup() != null) {
            clickableViews.add((View)maxNativeAdView.getMediaContentViewGroup());
        }
        return clickableViews;
    }

    private static MaxAdapterError toMaxError(VungleError vungleError) {
        int vungleErrorCode = vungleError.getCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (vungleErrorCode) {
            case 10001: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 0: {
                adapterError = MaxAdapterError.UNSPECIFIED;
                break;
            }
            case 2: 
            case 207: 
            case 10003: 
            case 10013: 
            case 10019: 
            case 10028: 
            case 10034: 
            case 10035: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case 304: {
                adapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case 3: 
            case 6: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case 113: 
            case 130: 
            case 3001: 
            case 10010: 
            case 10040: 
            case 10041: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 10011: 
            case 10020: 
            case 10024: 
            case 10033: 
            case 10038: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 10014: {
                adapterError = MaxAdapterError.SERVER_ERROR;
                break;
            }
            case 10015: 
            case 10042: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case 10031: 
            case 10032: {
                adapterError = MaxAdapterError.WEBVIEW_ERROR;
                break;
            }
            case 10047: {
                adapterError = MaxAdapterError.TIMEOUT;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), vungleErrorCode, vungleError.getLocalizedMessage());
    }

    @Nullable
    private Bundle maybeCreateExtraInfoBundle(BaseAd baseAd) {
        String creativeId = baseAd.getCreativeId();
        if (TextUtils.isEmpty((CharSequence)creativeId)) {
            return null;
        }
        Bundle extraInfo = new Bundle(1);
        extraInfo.putString("creative_id", creativeId);
        return extraInfo;
    }

    private class InterstitialListener
    implements InterstitialAdListener {
        private final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Interstitial ad loaded");
            Bundle extraInfo = VungleMediationAdapter.this.maybeCreateExtraInfoBundle(baseAd);
            this.listener.onInterstitialAdLoaded(extraInfo);
        }

        public void onAdFailedToLoad(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("Interstitial ad failed to load with error: " + error);
            this.listener.onInterstitialAdLoadFailed(error);
        }

        public void onAdStart(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Interstitial ad started");
        }

        public void onAdImpression(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Interstitial ad displayed");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdFailedToPlay(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("Interstitial ad failed to display with error: " + error);
            this.listener.onInterstitialAdDisplayFailed(error);
        }

        public void onAdClicked(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Interstitial ad clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onAdLeftApplication(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Interstitial ad left application");
        }

        public void onAdEnd(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Interstitial ad hidden");
            this.listener.onInterstitialAdHidden();
        }
    }

    private class AppOpenAdListener
    implements InterstitialAdListener {
        private final MaxAppOpenAdapterListener listener;

        AppOpenAdListener(MaxAppOpenAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(BaseAd baseAd) {
            VungleMediationAdapter.this.log("App Open ad loaded");
            Bundle extraInfo = VungleMediationAdapter.this.maybeCreateExtraInfoBundle(baseAd);
            this.listener.onAppOpenAdLoaded(extraInfo);
        }

        public void onAdFailedToLoad(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("App Open ad failed to load with error: " + error);
            this.listener.onAppOpenAdLoadFailed(error);
        }

        public void onAdStart(BaseAd baseAd) {
            VungleMediationAdapter.this.log("App Open ad started");
        }

        public void onAdImpression(BaseAd baseAd) {
            VungleMediationAdapter.this.log("App Open ad displayed");
            this.listener.onAppOpenAdDisplayed();
        }

        public void onAdFailedToPlay(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("App Open ad failed to display with error: " + error);
            this.listener.onAppOpenAdDisplayFailed(error);
        }

        public void onAdClicked(BaseAd baseAd) {
            VungleMediationAdapter.this.log("App Open ad clicked");
            this.listener.onAppOpenAdClicked();
        }

        public void onAdLeftApplication(BaseAd baseAd) {
            VungleMediationAdapter.this.log("App Open ad left application");
        }

        public void onAdEnd(BaseAd baseAd) {
            VungleMediationAdapter.this.log("App Open ad hidden");
            this.listener.onAppOpenAdHidden();
        }
    }

    private class RewardedListener
    implements RewardedAdListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Rewarded ad loaded");
            Bundle extraInfo = VungleMediationAdapter.this.maybeCreateExtraInfoBundle(baseAd);
            this.listener.onRewardedAdLoaded(extraInfo);
        }

        public void onAdFailedToLoad(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("Rewarded ad failed to load with error: " + error);
            this.listener.onRewardedAdLoadFailed(error);
        }

        public void onAdStart(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Rewarded ad started");
        }

        public void onAdImpression(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Rewarded ad displayed");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdFailedToPlay(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("Rewarded ad failed to display with error: " + error);
            this.listener.onRewardedAdDisplayFailed(error);
        }

        public void onAdClicked(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onAdLeftApplication(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Rewarded ad left application");
        }

        public void onAdEnd(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Rewarded ad video completed");
            if (this.hasGrantedReward || VungleMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = VungleMediationAdapter.this.getReward();
                VungleMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            VungleMediationAdapter.this.log("Rewarded ad hidden");
            this.listener.onRewardedAdHidden();
        }

        public void onAdRewarded(BaseAd baseAd) {
            VungleMediationAdapter.this.log("User was rewarded");
            this.hasGrantedReward = true;
        }
    }

    private class NativeAdViewListener
    implements NativeAdListener {
        private final Context applicationContext;
        private final Bundle serverParameters;
        private final MaxAdFormat adFormat;
        private final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Context applicationContext, MaxAdViewAdapterListener listener) {
            this.serverParameters = parameters.getServerParameters();
            this.adFormat = adFormat;
            this.applicationContext = applicationContext;
            this.listener = listener;
        }

        public void onAdLoaded(BaseAd ad) {
            MaxNativeAdView maxNativeAdView;
            if (VungleMediationAdapter.this.nativeAd == null || VungleMediationAdapter.this.nativeAd != ad) {
                VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load: no fill");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)VungleMediationAdapter.this.nativeAd.getAdTitle())) {
                VungleMediationAdapter.this.e("Native " + this.adFormat.getLabel() + " ad (" + VungleMediationAdapter.this.nativeAd + ") does not have required assets.");
                this.listener.onAdViewAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + VungleMediationAdapter.this.nativeAd.getPlacementId());
            MediaView mediaView = new MediaView(this.applicationContext);
            String iconUrl = VungleMediationAdapter.this.nativeAd.getAppIcon();
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setTitle(VungleMediationAdapter.this.nativeAd.getAdTitle()).setAdvertiser(VungleMediationAdapter.this.nativeAd.getAdSponsoredText()).setBody(VungleMediationAdapter.this.nativeAd.getAdBodyText()).setCallToAction(VungleMediationAdapter.this.nativeAd.getAdCallToActionText()).setIcon(new MaxNativeAd.MaxNativeAdImage(Uri.parse((String)iconUrl))).setMediaView((View)mediaView);
            MaxVungleNativeAd maxVungleNativeAd = new MaxVungleNativeAd(builder);
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            if (templateName.contains("vertical")) {
                if (templateName.equals("vertical")) {
                    String verticalTemplateName = this.adFormat == MaxAdFormat.LEADER ? "vertical_leader_template" : "vertical_media_banner_template";
                    maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxVungleNativeAd, verticalTemplateName, this.applicationContext);
                } else {
                    maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxVungleNativeAd, templateName, this.applicationContext);
                }
            } else {
                maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxVungleNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "media_banner_template", this.applicationContext);
            }
            maxVungleNativeAd.prepareForInteraction(VungleMediationAdapter.this.getClickableViews(maxNativeAdView), (ViewGroup)maxNativeAdView);
            Bundle extraInfo = VungleMediationAdapter.this.maybeCreateExtraInfoBundle(ad);
            this.listener.onAdViewAdLoaded((View)maxNativeAdView, extraInfo);
        }

        public void onAdFailedToLoad(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError adapterError = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load with error " + adapterError + " with placement id: " + baseAd.getPlacementId());
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdStart(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad start with placement id: " + baseAd.getPlacementId());
        }

        public void onAdImpression(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad shown with placement id: " + baseAd.getPlacementId());
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdFailedToPlay(BaseAd baseAd, VungleError vungleError) {
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to play with error " + VungleMediationAdapter.toMaxError(vungleError) + " with placement id: " + baseAd.getPlacementId());
        }

        public void onAdClicked(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked with placement id: " + baseAd.getPlacementId());
            this.listener.onAdViewAdClicked();
        }

        public void onAdLeftApplication(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad left application with placement id: " + baseAd.getPlacementId());
        }

        public void onAdEnd(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad end with placement id: " + baseAd.getPlacementId());
        }
    }

    private class AdViewAdListener
    implements BannerAdListener {
        private final String adFormatLabel;
        private final MaxAdViewAdapterListener listener;

        AdViewAdListener(String adFormatLabel, MaxAdViewAdapterListener listener) {
            this.adFormatLabel = adFormatLabel;
            this.listener = listener;
        }

        public void onAdLoaded(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Showing " + this.adFormatLabel + " ad for placement: " + baseAd.getPlacementId() + "...");
            if (VungleMediationAdapter.this.adViewAd != null) {
                VungleMediationAdapter.this.adViewAd.setGravity(17);
                VungleMediationAdapter.this.log(this.adFormatLabel + " ad loaded");
                Bundle extraInfo = VungleMediationAdapter.this.maybeCreateExtraInfoBundle(baseAd);
                this.listener.onAdViewAdLoaded((View)VungleMediationAdapter.this.adViewAd, extraInfo);
            } else {
                MaxAdapterError error = MaxAdapterError.INVALID_LOAD_STATE;
                VungleMediationAdapter.this.log(this.adFormatLabel + " ad failed to load: " + error);
                this.listener.onAdViewAdLoadFailed(error);
            }
        }

        public void onAdFailedToLoad(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log(this.adFormatLabel + " ad failed to load with error: " + error);
            this.listener.onAdViewAdLoadFailed(error);
        }

        public void onAdStart(BaseAd baseAd) {
            VungleMediationAdapter.this.log(this.adFormatLabel + " ad started");
        }

        public void onAdImpression(BaseAd baseAd) {
            VungleMediationAdapter.this.log(this.adFormatLabel + " ad displayed");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdFailedToPlay(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError error = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log(this.adFormatLabel + " ad display failed with error: " + error);
            this.listener.onAdViewAdDisplayFailed(error);
        }

        public void onAdClicked(BaseAd baseAd) {
            VungleMediationAdapter.this.log(this.adFormatLabel + " ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdLeftApplication(BaseAd baseAd) {
            VungleMediationAdapter.this.log(this.adFormatLabel + " ad left application");
        }

        public void onAdEnd(BaseAd baseAd) {
            VungleMediationAdapter.this.log(this.adFormatLabel + " ad hidden");
            this.listener.onAdViewAdHidden();
        }
    }

    private class NativeListener
    implements NativeAdListener {
        private final Context applicationContext;
        private final MaxNativeAdAdapterListener listener;
        private final Bundle serverParameters;

        NativeListener(MaxAdapterResponseParameters parameters, Context applicationContext, MaxNativeAdAdapterListener listener) {
            this.serverParameters = parameters.getServerParameters();
            this.applicationContext = applicationContext;
            this.listener = listener;
        }

        public void onAdLoaded(BaseAd ad) {
            if (VungleMediationAdapter.this.nativeAd == null || VungleMediationAdapter.this.nativeAd != ad) {
                VungleMediationAdapter.this.log("Native ad failed to load: no fill");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)VungleMediationAdapter.this.nativeAd.getAdTitle())) {
                VungleMediationAdapter.this.e("Native ad (" + VungleMediationAdapter.this.nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            VungleMediationAdapter.this.log("Native ad loaded: " + VungleMediationAdapter.this.nativeAd.getPlacementId());
            MediaView mediaView = new MediaView(this.applicationContext);
            String iconUrl = VungleMediationAdapter.this.nativeAd.getAppIcon();
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(VungleMediationAdapter.this.nativeAd.getAdTitle()).setAdvertiser(VungleMediationAdapter.this.nativeAd.getAdSponsoredText()).setBody(VungleMediationAdapter.this.nativeAd.getAdBodyText()).setCallToAction(VungleMediationAdapter.this.nativeAd.getAdCallToActionText()).setIcon(new MaxNativeAd.MaxNativeAdImage(Uri.parse((String)iconUrl))).setMediaView((View)mediaView);
            MaxVungleNativeAd maxVungleNativeAd = new MaxVungleNativeAd(builder);
            Bundle extraInfo = VungleMediationAdapter.this.maybeCreateExtraInfoBundle(ad);
            this.listener.onNativeAdLoaded((MaxNativeAd)maxVungleNativeAd, extraInfo);
        }

        public void onAdFailedToLoad(BaseAd baseAd, VungleError vungleError) {
            MaxAdapterError adapterError = VungleMediationAdapter.toMaxError(vungleError);
            VungleMediationAdapter.this.log("Native ad failed to load with error " + adapterError + " with placement id: " + baseAd.getPlacementId());
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdStart(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native ad start with placement id: " + baseAd.getPlacementId());
        }

        public void onAdImpression(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native ad shown with placement id: " + baseAd.getPlacementId());
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdFailedToPlay(BaseAd baseAd, VungleError vungleError) {
            VungleMediationAdapter.this.log("Native ad failed to play with error " + VungleMediationAdapter.toMaxError(vungleError) + " with placement id: " + baseAd.getPlacementId());
        }

        public void onAdClicked(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native ad clicked with placement id: " + baseAd.getPlacementId());
            this.listener.onNativeAdClicked();
        }

        public void onAdLeftApplication(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native ad left application with placement id: " + baseAd.getPlacementId());
        }

        public void onAdEnd(BaseAd baseAd) {
            VungleMediationAdapter.this.log("Native ad end with placement id: " + baseAd.getPlacementId());
        }
    }

    private class MaxVungleNativeAd
    extends MaxNativeAd {
        public MaxVungleNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = VungleMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                VungleMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            if (!nativeAd.canPlayAd().booleanValue()) {
                VungleMediationAdapter.this.e("Failed to play native ad or native ad is registered.");
                return false;
            }
            View mediaView = this.getMediaView();
            if (mediaView == null) {
                VungleMediationAdapter.this.e("Failed to register native ad views: mediaView is null.");
                return false;
            }
            if (container instanceof MaxNativeAdView) {
                MaxNativeAdView maxNativeAdView;
                ViewGroup contentViewGroup;
                if (mediaView.getParent() != null) {
                    ((ViewGroup)mediaView.getParent()).removeView(mediaView);
                }
                if ((contentViewGroup = (maxNativeAdView = (MaxNativeAdView)container).getMediaContentViewGroup()) != null) {
                    contentViewGroup.removeAllViews();
                    contentViewGroup.addView(mediaView);
                }
                nativeAd.registerViewForInteraction((FrameLayout)maxNativeAdView, (MediaView)mediaView, maxNativeAdView.getIconImageView(), clickableViews);
            } else {
                FrameLayout frameLayout = new FrameLayout(container.getContext());
                container.addView((View)frameLayout, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                ImageView iconImageView = null;
                for (View clickableView : clickableViews) {
                    if (!(clickableView instanceof ImageView)) continue;
                    iconImageView = (ImageView)clickableView;
                    break;
                }
                nativeAd.registerViewForInteraction(frameLayout, (MediaView)mediaView, iconImageView, clickableViews);
            }
            return true;
        }
    }
}

