/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.yandex.mobile.ads.banner.BannerAdEventListener;
import com.yandex.mobile.ads.banner.BannerAdSize;
import com.yandex.mobile.ads.banner.BannerAdView;
import com.yandex.mobile.ads.common.AdError;
import com.yandex.mobile.ads.common.AdRequest;
import com.yandex.mobile.ads.common.AdRequestConfiguration;
import com.yandex.mobile.ads.common.AdRequestError;
import com.yandex.mobile.ads.common.AdType;
import com.yandex.mobile.ads.common.BidderTokenLoadListener;
import com.yandex.mobile.ads.common.BidderTokenLoader;
import com.yandex.mobile.ads.common.BidderTokenRequestConfiguration;
import com.yandex.mobile.ads.common.ImpressionData;
import com.yandex.mobile.ads.common.InitializationListener;
import com.yandex.mobile.ads.common.MobileAds;
import com.yandex.mobile.ads.interstitial.InterstitialAd;
import com.yandex.mobile.ads.interstitial.InterstitialAdEventListener;
import com.yandex.mobile.ads.interstitial.InterstitialAdLoadListener;
import com.yandex.mobile.ads.interstitial.InterstitialAdLoader;
import com.yandex.mobile.ads.nativeads.MediaView;
import com.yandex.mobile.ads.nativeads.NativeAd;
import com.yandex.mobile.ads.nativeads.NativeAdAssets;
import com.yandex.mobile.ads.nativeads.NativeAdEventListener;
import com.yandex.mobile.ads.nativeads.NativeAdException;
import com.yandex.mobile.ads.nativeads.NativeAdLoadListener;
import com.yandex.mobile.ads.nativeads.NativeAdLoader;
import com.yandex.mobile.ads.nativeads.NativeAdRequestConfiguration;
import com.yandex.mobile.ads.nativeads.NativeAdView;
import com.yandex.mobile.ads.nativeads.NativeAdViewBinder;
import com.yandex.mobile.ads.rewarded.Reward;
import com.yandex.mobile.ads.rewarded.RewardedAd;
import com.yandex.mobile.ads.rewarded.RewardedAdEventListener;
import com.yandex.mobile.ads.rewarded.RewardedAdLoadListener;
import com.yandex.mobile.ads.rewarded.RewardedAdLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class YandexMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static final Map<String, String> adRequestParameters = new HashMap<String, String>(3);
    private static MaxAdapter.InitializationStatus status;
    private InterstitialAd interstitialAd;
    private RewardedAd rewardedAd;
    private BannerAdView adView;
    private NativeAd nativeAd;
    private NativeAdView nativeAdView;
    private InterstitialAdListener interstitialAdListener;
    private RewardedAdListener rewardedAdListener;

    public YandexMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public String getSdkVersion() {
        return MobileAds.getLibraryVersion();
    }

    public String getAdapterVersion() {
        return "7.3.0.0";
    }

    @Nullable
    public Boolean shouldLoadAdsOnUiThread(MaxAdFormat adFormat) {
        return true;
    }

    public void onDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.setAdEventListener(null);
            this.interstitialAdListener = null;
            this.interstitialAd = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.setAdEventListener(null);
            this.rewardedAdListener = null;
            this.rewardedAd = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        this.nativeAd = null;
        this.nativeAdView = null;
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (INITIALIZED.compareAndSet(false, true)) {
            this.log("Initializing Yandex SDK" + (parameters.isTesting() ? " in test mode " : "") + "...");
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            this.updatePrivacySettings((MaxAdapterParameters)parameters);
            if (parameters.isTesting()) {
                MobileAds.enableLogging((boolean)true);
            }
            Context context = this.getContext(activity);
            MobileAds.initialize((Context)context, (InitializationListener)new InitializationListener(){

                public void onInitializationCompleted() {
                    YandexMediationAdapter.this.log("Yandex SDK initialized");
                    status = MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN;
                    onCompletionListener.onCompletion(status, null);
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
        adRequestParameters.put("adapter_network_name", "applovin");
        adRequestParameters.put("adapter_version", this.getAdapterVersion());
        adRequestParameters.put("adapter_network_sdk_version", AppLovinSdk.VERSION);
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, final MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        BidderTokenRequestConfiguration bidderTokenRequest = this.createBidderTokenRequestConfiguration((Context)activity, parameters.getAdFormat());
        BidderTokenLoader.loadBidderToken((Context)activity, (BidderTokenRequestConfiguration)bidderTokenRequest, (BidderTokenLoadListener)new BidderTokenLoadListener(){

            public void onBidderTokenLoaded(@NonNull String bidderToken) {
                YandexMediationAdapter.this.log("Signal collection successful");
                callback.onSignalCollected(bidderToken);
            }

            public void onBidderTokenFailedToLoad(@NonNull String failureReason) {
                YandexMediationAdapter.this.log("Signal collection failed: " + failureReason);
                callback.onSignalCollectionFailed(failureReason);
            }
        });
    }

    public void loadInterstitialAd(final MaxAdapterResponseParameters parameters, final Activity activity, final MaxInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "interstitial ad for placement: " + placementId + "...");
        if (activity == null) {
            this.log("Interstitial ad load failed: Activity is null");
            MaxAdapterError error = new MaxAdapterError(-5601, "Missing Activity");
            listener.onInterstitialAdLoadFailed(error);
            return;
        }
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        Runnable loadInterstitialAdRunnable = new Runnable(){

            @Override
            public void run() {
                InterstitialAdLoader interstitialAdLoader = new InterstitialAdLoader(YandexMediationAdapter.this.getContext(activity));
                YandexMediationAdapter.this.interstitialAdListener = new InterstitialAdListener(parameters, listener);
                interstitialAdLoader.setAdLoadListener((InterstitialAdLoadListener)YandexMediationAdapter.this.interstitialAdListener);
                interstitialAdLoader.loadAd(YandexMediationAdapter.this.createAdRequestConfiguration(placementId, parameters));
            }
        };
        this.loadAdOnUiThread(loadInterstitialAdRunnable);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad...");
        if (this.interstitialAd == null) {
            this.log("Interstitial ad failed to load - ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
            return;
        }
        this.interstitialAd.setAdEventListener((InterstitialAdEventListener)this.interstitialAdListener);
        this.interstitialAd.show(activity);
    }

    public void loadRewardedAd(final MaxAdapterResponseParameters parameters, final Activity activity, final MaxRewardedAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "rewarded ad for placement: " + placementId + "...");
        if (activity == null) {
            this.log("Rewarded ad load failed: Activity is null");
            MaxAdapterError error = new MaxAdapterError(-5601, "Missing Activity");
            listener.onRewardedAdLoadFailed(error);
            return;
        }
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        Runnable loadRewardedAdRunnable = new Runnable(){

            @Override
            public void run() {
                RewardedAdLoader rewardedAdLoader = new RewardedAdLoader((Context)activity);
                YandexMediationAdapter.this.rewardedAdListener = new RewardedAdListener(parameters, listener);
                rewardedAdLoader.setAdLoadListener((RewardedAdLoadListener)YandexMediationAdapter.this.rewardedAdListener);
                rewardedAdLoader.loadAd(YandexMediationAdapter.this.createAdRequestConfiguration(placementId, parameters));
            }
        };
        this.loadAdOnUiThread(loadRewardedAdRunnable);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedAd == null) {
            this.log("Rewarded ad failed to load - ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
            return;
        }
        this.configureReward(parameters);
        this.rewardedAd.setAdEventListener((RewardedAdEventListener)this.rewardedAdListener);
        this.rewardedAd.show(activity);
    }

    public void loadAdViewAd(final MaxAdapterResponseParameters parameters, final MaxAdFormat adFormat, final Activity activity, final MaxAdViewAdapterListener listener) {
        final String adFormatLabel = adFormat.getLabel();
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + adFormatLabel + " ad for placement: " + placementId + "...");
        final Context applicationContext = this.getContext(activity);
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        Runnable loadAdViewAdRunnable = new Runnable(){

            @Override
            public void run() {
                YandexMediationAdapter.this.adView = new BannerAdView(applicationContext);
                YandexMediationAdapter.this.adView.setAdUnitId(placementId);
                YandexMediationAdapter.this.adView.setAdSize(YandexMediationAdapter.toBannerAdSize(adFormat, YandexMediationAdapter.this.getContext(activity)));
                YandexMediationAdapter.this.adView.setBannerAdEventListener((BannerAdEventListener)new AdViewListener(adFormatLabel, listener));
                YandexMediationAdapter.this.adView.loadAd(YandexMediationAdapter.this.createAdRequest(parameters));
            }
        };
        this.loadAdOnUiThread(loadAdViewAdRunnable);
    }

    public void loadNativeAd(final MaxAdapterResponseParameters parameters, Activity activity, final MaxNativeAdAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + "native ad for placement: " + placementId + "...");
        final Context applicationContext = this.getContext(activity);
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        Runnable loadNativeAdRunnable = new Runnable(){

            @Override
            public void run() {
                NativeAdLoader nativeAdLoader = new NativeAdLoader(applicationContext);
                nativeAdLoader.setNativeAdLoadListener((NativeAdLoadListener)new NativeAdListener(parameters, applicationContext, listener));
                nativeAdLoader.loadAd(YandexMediationAdapter.this.createNativeAdRequestConfiguration(placementId, parameters));
            }
        };
        this.loadAdOnUiThread(loadNativeAdRunnable);
    }

    private Context getContext(Activity activity) {
        return activity != null ? activity.getApplication() : this.getApplicationContext();
    }

    private void loadAdOnUiThread(Runnable loadOrShowRunnable) {
        if (AppLovinSdk.VERSION_CODE >= 11080300) {
            loadOrShowRunnable.run();
        } else {
            AppLovinSdkUtils.runOnUiThread((Runnable)loadOrShowRunnable);
        }
    }

    private void updatePrivacySettings(MaxAdapterParameters parameters) {
        Boolean isAgeRestrictedUser;
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            MobileAds.setUserConsent((boolean)hasUserConsent);
        }
        if ((isAgeRestrictedUser = parameters.isAgeRestrictedUser()) != null) {
            MobileAds.setAgeRestrictedUser((boolean)isAgeRestrictedUser);
        }
    }

    private AdRequest createAdRequest(MaxAdapterResponseParameters parameters) {
        AdRequest.Builder builder = new AdRequest.Builder().setParameters(adRequestParameters);
        String bidResponse = parameters.getBidResponse();
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            builder.setBiddingData(bidResponse);
        }
        return builder.build();
    }

    private AdRequestConfiguration createAdRequestConfiguration(String placementId, MaxAdapterResponseParameters parameters) {
        AdRequestConfiguration.Builder builder = new AdRequestConfiguration.Builder(placementId).setParameters(adRequestParameters);
        String bidResponse = parameters.getBidResponse();
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            builder.setBiddingData(bidResponse);
        }
        return builder.build();
    }

    private NativeAdRequestConfiguration createNativeAdRequestConfiguration(String placementId, MaxAdapterResponseParameters parameters) {
        NativeAdRequestConfiguration.Builder builder = new NativeAdRequestConfiguration.Builder(placementId).setParameters(adRequestParameters).setShouldLoadImagesAutomatically(true);
        String bidResponse = parameters.getBidResponse();
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            builder.setBiddingData(bidResponse);
        }
        return builder.build();
    }

    private BidderTokenRequestConfiguration createBidderTokenRequestConfiguration(Context context, MaxAdFormat adFormat) {
        AdType adType = YandexMediationAdapter.toAdType(adFormat);
        BidderTokenRequestConfiguration.Builder requestBuilder = new BidderTokenRequestConfiguration.Builder(adType);
        if (adType == AdType.BANNER) {
            requestBuilder.setBannerAdSize(YandexMediationAdapter.toBannerAdSize(adFormat, context));
        }
        return requestBuilder.setParameters(adRequestParameters).build();
    }

    private static AdType toAdType(MaxAdFormat adFormat) {
        if (adFormat.isAdViewAd()) {
            return AdType.BANNER;
        }
        if (adFormat == MaxAdFormat.INTERSTITIAL) {
            return AdType.INTERSTITIAL;
        }
        if (adFormat == MaxAdFormat.REWARDED || adFormat == MaxAdFormat.REWARDED_INTERSTITIAL) {
            return AdType.REWARDED;
        }
        if (adFormat == MaxAdFormat.APP_OPEN) {
            return AdType.APP_OPEN_AD;
        }
        if (adFormat == MaxAdFormat.NATIVE) {
            return AdType.NATIVE;
        }
        return AdType.UNKNOWN;
    }

    private static BannerAdSize toBannerAdSize(MaxAdFormat adFormat, Context context) {
        if (adFormat == MaxAdFormat.BANNER) {
            return BannerAdSize.fixedSize((Context)context, (int)320, (int)50);
        }
        if (adFormat == MaxAdFormat.MREC) {
            return BannerAdSize.fixedSize((Context)context, (int)300, (int)250);
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return BannerAdSize.fixedSize((Context)context, (int)728, (int)90);
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private static MaxAdapterError toMaxError(AdRequestError yandexError) {
        int yandexErrorCode = yandexError.getCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (yandexErrorCode) {
            case 1: 
            case 5: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 2: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case 3: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 4: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 0: {
                adapterError = MaxAdapterError.UNSPECIFIED;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), yandexError.getCode(), yandexError.getDescription());
    }

    private class RewardedAdListener
    implements RewardedAdLoadListener,
    RewardedAdEventListener {
        private final MaxAdapterResponseParameters parameters;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(MaxAdapterResponseParameters parameters, MaxRewardedAdapterListener listener) {
            this.parameters = parameters;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            YandexMediationAdapter.this.log("Rewarded ad loaded");
            YandexMediationAdapter.this.rewardedAd = rewardedAd;
            this.listener.onRewardedAdLoaded();
        }

        public void onAdFailedToLoad(@NonNull AdRequestError adRequestError) {
            YandexMediationAdapter.this.log("Rewarded ad failed to load with error code " + adRequestError.getCode() + " and description: " + adRequestError.getDescription());
            MaxAdapterError adapterError = YandexMediationAdapter.toMaxError(adRequestError);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onAdShown() {
            YandexMediationAdapter.this.log("Rewarded ad shown");
            if (this.parameters.isTesting()) {
                this.listener.onRewardedAdDisplayed();
            }
        }

        public void onAdImpression(@Nullable ImpressionData impressionData) {
            YandexMediationAdapter.this.log("Rewarded ad impression tracked");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdFailedToShow(@NonNull AdError adError) {
            YandexMediationAdapter.this.log("Rewarded ad failed to show with error description: " + adError.getDescription());
            this.listener.onRewardedAdDisplayFailed(new MaxAdapterError(-5200, adError.getDescription()));
        }

        public void onAdClicked() {
            YandexMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onRewarded(@NonNull Reward reward) {
            YandexMediationAdapter.this.log("Rewarded user with reward: " + reward.getAmount() + " " + reward.getType());
            this.hasGrantedReward = true;
        }

        public void onAdDismissed() {
            YandexMediationAdapter.this.log("Rewarded ad hidden");
            if (this.hasGrantedReward || YandexMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = YandexMediationAdapter.this.getReward();
                YandexMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            this.listener.onRewardedAdHidden();
        }
    }

    private class InterstitialAdListener
    implements InterstitialAdLoadListener,
    InterstitialAdEventListener {
        private final MaxAdapterResponseParameters parameters;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(MaxAdapterResponseParameters parameters, MaxInterstitialAdapterListener listener) {
            this.parameters = parameters;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            YandexMediationAdapter.this.log("Interstitial ad loaded");
            YandexMediationAdapter.this.interstitialAd = interstitialAd;
            this.listener.onInterstitialAdLoaded();
        }

        public void onAdFailedToLoad(@NonNull AdRequestError adRequestError) {
            YandexMediationAdapter.this.log("Interstitial ad failed to load with error code " + adRequestError.getCode() + " and description: " + adRequestError.getDescription());
            MaxAdapterError adapterError = YandexMediationAdapter.toMaxError(adRequestError);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onAdShown() {
            YandexMediationAdapter.this.log("Interstitial ad shown");
            if (this.parameters.isTesting()) {
                this.listener.onInterstitialAdDisplayed();
            }
        }

        public void onAdImpression(@Nullable ImpressionData impressionData) {
            YandexMediationAdapter.this.log("Interstitial ad impression tracked");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdFailedToShow(@NonNull AdError adError) {
            YandexMediationAdapter.this.log("Interstitial ad failed to show with error description: " + adError.getDescription());
            this.listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-5200, adError.getDescription()));
        }

        public void onAdClicked() {
            YandexMediationAdapter.this.log("Interstitial ad clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onAdDismissed() {
            YandexMediationAdapter.this.log("Interstitial ad dismissed");
            this.listener.onInterstitialAdHidden();
        }
    }

    private class MaxYandexNativeAd
    extends MaxNativeAd {
        public MaxYandexNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            if (YandexMediationAdapter.this.nativeAd == null) {
                YandexMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return;
            }
            YandexMediationAdapter.this.nativeAdView = new NativeAdView(maxNativeAdView.getContext());
            View mainView = maxNativeAdView.getMainView();
            maxNativeAdView.removeView(mainView);
            YandexMediationAdapter.this.nativeAdView.addView(mainView);
            maxNativeAdView.addView((View)YandexMediationAdapter.this.nativeAdView);
            LinearLayout disclaimerSponsoredOptionsViewContainer = (LinearLayout)maxNativeAdView.getOptionsContentViewGroup().getChildAt(0);
            NativeAdViewBinder binder = new NativeAdViewBinder.Builder(YandexMediationAdapter.this.nativeAdView).setIconView(maxNativeAdView.getIconImageView()).setTitleView(maxNativeAdView.getTitleTextView()).setDomainView(maxNativeAdView.getAdvertiserTextView()).setBodyView(maxNativeAdView.getBodyTextView()).setMediaView((MediaView)this.getMediaView()).setWarningView((TextView)disclaimerSponsoredOptionsViewContainer.getChildAt(0)).setSponsoredView((TextView)disclaimerSponsoredOptionsViewContainer.getChildAt(1)).setFeedbackView((ImageView)disclaimerSponsoredOptionsViewContainer.getChildAt(2)).setCallToActionView((TextView)maxNativeAdView.getCallToActionButton()).build();
            try {
                YandexMediationAdapter.this.nativeAd.bindNativeAd(binder);
                YandexMediationAdapter.this.nativeAdView.setVisibility(0);
            }
            catch (NativeAdException exception) {
                YandexMediationAdapter.this.e("Failed to register native ad views.", exception);
            }
        }
    }

    private class NativeAdListener
    implements NativeAdLoadListener,
    NativeAdEventListener {
        private final String placementId;
        private final Bundle serverParameters;
        private final Context applicationContext;
        private final MaxNativeAdAdapterListener listener;

        private NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.applicationContext = context;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull NativeAd nativeAd) {
            YandexMediationAdapter.this.log("Native ad loaded: " + this.placementId);
            YandexMediationAdapter.this.nativeAd = nativeAd;
            nativeAd.setNativeAdEventListener((NativeAdEventListener)this);
            final NativeAdAssets assets = nativeAd.getAdAssets();
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)assets.getTitle())) {
                YandexMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BitmapDrawable iconDrawable = null;
                    if (assets.getIcon() != null) {
                        iconDrawable = new BitmapDrawable(NativeAdListener.this.applicationContext.getResources(), assets.getIcon().getBitmap());
                    }
                    LinearLayout disclaimerSponsoredOptionsViewContainer = new LinearLayout(NativeAdListener.this.applicationContext);
                    TextView disclaimer = new TextView(NativeAdListener.this.applicationContext);
                    TextView sponsored = new TextView(NativeAdListener.this.applicationContext);
                    disclaimer.setText((CharSequence)assets.getWarning());
                    sponsored.setText((CharSequence)assets.getSponsored());
                    disclaimerSponsoredOptionsViewContainer.addView((View)disclaimer);
                    disclaimerSponsoredOptionsViewContainer.addView((View)sponsored);
                    disclaimerSponsoredOptionsViewContainer.addView((View)new ImageView(NativeAdListener.this.applicationContext));
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(assets.getTitle()).setAdvertiser(assets.getDomain()).setBody(assets.getBody()).setCallToAction(assets.getCallToAction()).setIcon(new MaxNativeAd.MaxNativeAdImage((Drawable)iconDrawable)).setOptionsView((View)disclaimerSponsoredOptionsViewContainer).setMediaView((View)new MediaView(NativeAdListener.this.applicationContext));
                    if (AppLovinSdk.VERSION_CODE >= 11070000 && assets.getRating() != null) {
                        builder.setStarRating(Double.valueOf(assets.getRating().floatValue()));
                    }
                    MaxYandexNativeAd maxNativeAd = new MaxYandexNativeAd(builder);
                    NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
                }
            });
        }

        public void onAdFailedToLoad(@NonNull AdRequestError adRequestError) {
            MaxAdapterError adapterError = YandexMediationAdapter.toMaxError(adRequestError);
            YandexMediationAdapter.this.log("Native ad (" + this.placementId + ") failed to load with error: " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onImpression(@Nullable ImpressionData impressionData) {
            YandexMediationAdapter.this.log("Native ad (" + this.placementId + ") shown");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked() {
            YandexMediationAdapter.this.log("Native ad (" + this.placementId + ") clicked");
            this.listener.onNativeAdClicked();
        }

        public void onLeftApplication() {
            YandexMediationAdapter.this.log("Native ad (" + this.placementId + ") left application");
        }

        public void onReturnedToApplication() {
            YandexMediationAdapter.this.log("Native ad (" + this.placementId + ") returned to application");
        }
    }

    private class AdViewListener
    implements BannerAdEventListener {
        private final String adFormatLabel;
        private final MaxAdViewAdapterListener listener;

        AdViewListener(String adFormatLabel, MaxAdViewAdapterListener listener) {
            this.adFormatLabel = adFormatLabel;
            this.listener = listener;
        }

        public void onAdLoaded() {
            YandexMediationAdapter.this.log(this.adFormatLabel + " ad loaded");
            this.listener.onAdViewAdLoaded((View)YandexMediationAdapter.this.adView);
        }

        public void onAdFailedToLoad(@NonNull AdRequestError adRequestError) {
            YandexMediationAdapter.this.log(this.adFormatLabel + " ad failed to load with error code " + adRequestError.getCode() + " and description: " + adRequestError.getDescription());
            MaxAdapterError adapterError = YandexMediationAdapter.toMaxError(adRequestError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdClicked() {
            YandexMediationAdapter.this.log("AdView ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onLeftApplication() {
            YandexMediationAdapter.this.log(this.adFormatLabel + " ad left application after click");
        }

        public void onReturnedToApplication() {
            YandexMediationAdapter.this.log(this.adFormatLabel + " ad returned to application");
        }

        public void onImpression(@Nullable ImpressionData impressionData) {
            YandexMediationAdapter.this.log("AdView ad impression tracked");
            this.listener.onAdViewAdDisplayed();
        }
    }
}

