/*
 * Decompiled with CFR 0.152.
 */
package com.appmattus.certificatetransparency.chaincleaner;

import android.net.http.X509TrustManagerExtensions;
import com.appmattus.certificatetransparency.chaincleaner.CertificateChainCleaner;
import com.appmattus.certificatetransparency.chaincleaner.CertificateChainCleanerFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/appmattus/certificatetransparency/chaincleaner/AndroidCertificateChainCleaner;", "Lcom/appmattus/certificatetransparency/chaincleaner/CertificateChainCleaner;", "extensions", "Landroid/net/http/X509TrustManagerExtensions;", "(Landroid/net/http/X509TrustManagerExtensions;)V", "clean", "", "Ljava/security/cert/X509Certificate;", "chain", "hostname", "", "Factory", "certificatetransparency-android_release"})
public final class AndroidCertificateChainCleaner
implements CertificateChainCleaner {
    @NotNull
    private final X509TrustManagerExtensions extensions;

    public AndroidCertificateChainCleaner(@NotNull X509TrustManagerExtensions extensions) {
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        this.extensions = extensions;
    }

    @NotNull
    public List<X509Certificate> clean(@NotNull List<? extends X509Certificate> chain, @NotNull String hostname) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Collection $this$toTypedArray$iv = chain;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        if (x509CertificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        List list = this.extensions.checkServerTrusted(x509CertificateArray, "RSA", hostname);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"extensions.checkServerTr\u2026Array(), \"RSA\", hostname)");
        return list;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/appmattus/certificatetransparency/chaincleaner/AndroidCertificateChainCleaner$Factory;", "Lcom/appmattus/certificatetransparency/chaincleaner/CertificateChainCleanerFactory;", "()V", "get", "Lcom/appmattus/certificatetransparency/chaincleaner/AndroidCertificateChainCleaner;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "certificatetransparency-android_release"})
    public static final class Factory
    implements CertificateChainCleanerFactory {
        @NotNull
        public AndroidCertificateChainCleaner get(@NotNull X509TrustManager trustManager) {
            Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
            return new AndroidCertificateChainCleaner(new X509TrustManagerExtensions(trustManager));
        }
    }
}

