/*
 * Decompiled with CFR 0.152.
 */
package com.appnexus.grafana.client;

import com.appnexus.grafana.client.GrafanaService;
import com.appnexus.grafana.client.models.AlertNotification;
import com.appnexus.grafana.client.models.DashboardMeta;
import com.appnexus.grafana.client.models.DashboardPanelAlert;
import com.appnexus.grafana.client.models.DashboardSuccessfulDelete;
import com.appnexus.grafana.client.models.GrafanaDashboard;
import com.appnexus.grafana.client.models.GrafanaMessage;
import com.appnexus.grafana.configuration.GrafanaConfiguration;
import com.appnexus.grafana.exceptions.GrafanaException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class GrafanaClient {
    private final String host;
    private final String apiKey;
    private final GrafanaService service;
    private static final ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);

    public GrafanaClient(GrafanaConfiguration configuration) {
        this(configuration, new OkHttpClient());
    }

    public GrafanaClient(GrafanaConfiguration configuration, OkHttpClient client) {
        this.apiKey = configuration.apiKey();
        this.host = configuration.host();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.host).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).build();
        this.service = (GrafanaService)retrofit.create(GrafanaService.class);
    }

    public String getHost() {
        return this.host;
    }

    public GrafanaDashboard getDashboard(String dashboardName) throws GrafanaException, IOException {
        Response response = this.service.getDashboard(this.apiKey, dashboardName).execute();
        if (response.isSuccessful()) {
            return (GrafanaDashboard)response.body();
        }
        if (response.code() == 404) {
            throw new GrafanaException("Dashboard " + dashboardName + " does not exist");
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public DashboardMeta createDashboard(GrafanaDashboard grafanaDashboard) throws GrafanaException, IOException {
        return this.updateDashboard(grafanaDashboard);
    }

    public DashboardMeta updateDashboard(GrafanaDashboard dashboard) throws GrafanaException, IOException {
        Response response = this.service.postDashboard(this.apiKey, dashboard).execute();
        if (response.isSuccessful()) {
            return (DashboardMeta)response.body();
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public String deleteDashboard(String dashboardName) throws GrafanaException, IOException {
        Response response = this.service.deleteDashboard(this.apiKey, dashboardName).execute();
        if (response.isSuccessful()) {
            return ((DashboardSuccessfulDelete)response.body()).title();
        }
        if (response.code() == 404) {
            throw new GrafanaException("Dashboard " + dashboardName + " does not exist");
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public AlertNotification getNotification(Integer id) throws GrafanaException, IOException {
        Response response = this.service.getNotification(this.apiKey, id).execute();
        if (response.isSuccessful()) {
            return (AlertNotification)response.body();
        }
        if (response.code() == 404) {
            throw new GrafanaException("Notification" + id + " does not exist");
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public List<AlertNotification> getNotifications() throws GrafanaException, IOException {
        Response response = this.service.getNotifications(this.apiKey).execute();
        if (response.isSuccessful()) {
            return (List)response.body();
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public AlertNotification createNotification(AlertNotification alertNotification) throws GrafanaException, IOException {
        Response response = this.service.postNotification(this.apiKey, alertNotification).execute();
        if (response.isSuccessful()) {
            return (AlertNotification)response.body();
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public AlertNotification updateNotification(Integer id, AlertNotification alertNotification) throws GrafanaException, IOException {
        Response response = this.service.putNotification(this.apiKey, id, alertNotification).execute();
        if (response.isSuccessful()) {
            return (AlertNotification)response.body();
        }
        if (response.code() == 404) {
            throw new GrafanaException("Notification id: " + id + " does not exist");
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public String deleteNotification(Integer id) throws GrafanaException, IOException {
        Response response = this.service.deleteNotification(this.apiKey, id).execute();
        if (response.isSuccessful()) {
            return ((GrafanaMessage)response.body()).message();
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }

    public DashboardPanelAlert getAlert(Integer id) throws GrafanaException, IOException {
        Response response = this.service.getAlert(this.apiKey, id).execute();
        if (response.isSuccessful()) {
            return (DashboardPanelAlert)response.body();
        }
        throw GrafanaException.withErrorBody(response.errorBody());
    }
}

