/*
 * Decompiled with CFR 0.152.
 */
package com.appnexus.grafana.client;

import com.appnexus.grafana.client.models.AlertNotification;
import com.appnexus.grafana.client.models.DashboardMeta;
import com.appnexus.grafana.client.models.DashboardPanelAlert;
import com.appnexus.grafana.client.models.DashboardSuccessfulDelete;
import com.appnexus.grafana.client.models.GrafanaDashboard;
import com.appnexus.grafana.client.models.GrafanaMessage;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface GrafanaService {
    public static final String GRAFANA_DASHBOARDS = "api/dashboards/db/";
    public static final String GRAFANA_NOTIFICATIONS = "api/alert-notifications/";
    public static final String GRAFANA_ALERTS = "api/alerts/";
    public static final String AUTHORIZATION = "Authorization";

    @GET(value="api/dashboards/db/{dashboard}")
    public Call<GrafanaDashboard> getDashboard(@Header(value="Authorization") String var1, @Path(value="dashboard") String var2);

    @POST(value="api/dashboards/db/")
    public Call<DashboardMeta> postDashboard(@Header(value="Authorization") String var1, @Body GrafanaDashboard var2);

    @DELETE(value="api/dashboards/db/{dashboard}")
    public Call<DashboardSuccessfulDelete> deleteDashboard(@Header(value="Authorization") String var1, @Path(value="dashboard") String var2);

    @GET(value="api/alert-notifications/{id}")
    public Call<AlertNotification> getNotification(@Header(value="Authorization") String var1, @Path(value="id") Integer var2);

    @GET(value="api/alert-notifications/")
    public Call<List<AlertNotification>> getNotifications(@Header(value="Authorization") String var1);

    @POST(value="api/alert-notifications/")
    public Call<AlertNotification> postNotification(@Header(value="Authorization") String var1, @Body AlertNotification var2);

    @PUT(value="api/alert-notifications/{id}")
    public Call<AlertNotification> putNotification(@Header(value="Authorization") String var1, @Path(value="id") Integer var2, @Body AlertNotification var3);

    @DELETE(value="api/alert-notifications/{id}")
    public Call<GrafanaMessage> deleteNotification(@Header(value="Authorization") String var1, @Path(value="id") Integer var2);

    @GET(value="api/alerts/{id}")
    public Call<DashboardPanelAlert> getAlert(@Header(value="Authorization") String var1, @Path(value="id") Integer var2);
}

