/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.api.ext;

import com.tracelytics.agent.Agent;
import com.tracelytics.joboe.StartupManager;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentChecker {
    private static Logger logger = Logger.getLogger("agent-sdk");
    public static final String REQUIRED_AGENT_VERSION = "6.9.0";
    static boolean isAgentAvailable = false;

    public static boolean isAgentAvailable() {
        return isAgentAvailable;
    }

    static int compareVersion(String currentVersion, String requiredVersion) {
        try {
            return Version.getVersion(currentVersion).compareTo(Version.getVersion(requiredVersion));
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    public static boolean waitUntilAgentReady(long timeout, TimeUnit unit) {
        if (isAgentAvailable) {
            try {
                StartupManager.isAgentReady().get(timeout, unit);
                return true;
            }
            catch (Exception e) {
                logger.warning("Agent is still not ready after waiting for " + timeout + " " + (Object)((Object)unit));
                return false;
            }
        }
        return false;
    }

    static {
        try {
            Class.forName("com.tracelytics.agent.Agent");
            if (Agent.getVersion() != null && AgentChecker.compareVersion(Agent.getVersion(), REQUIRED_AGENT_VERSION) >= 0) {
                if (Agent.getStatus() == Agent.AgentStatus.INITIALIZED_SUCCESSFUL) {
                    isAgentAvailable = true;
                    StartupManager.flagSystemStartupCompleted();
                } else {
                    logger.warning("SDK calls would be ignored. Agent was not initialized properly");
                }
            } else {
                logger.warning("SDK calls would be ignored. Require -javaagent of at least version [6.9.0] but found version [" + Agent.getVersion() + "] running");
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Java Agent not available");
        }
        catch (NoClassDefFoundError e) {
            logger.log(Level.INFO, "Java Agent not available");
        }
        catch (NoSuchMethodError e) {
            logger.log(Level.INFO, "Java Agent is older than [6.9.0]. SDK calls would be ignored");
        }
    }

    private static class Version
    implements Comparable<Version> {
        private int majorVersion;
        private int minorVersion;
        private int patchVersion;
        private String extension;

        private Version(int majorVersion, int minorVersion, int patchVersion, String extension) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.patchVersion = patchVersion;
            this.extension = extension;
        }

        public static Version getVersion(String versionString) throws IllegalArgumentException {
            String[] tokens = versionString.split("\\.");
            if (tokens.length != 3) {
                throw new IllegalArgumentException("Version String " + versionString + " is not in the expected format of x.x.x");
            }
            try {
                String extension;
                int patchVersion;
                int majorVersion = Integer.parseInt(tokens[0]);
                int minorVersion = Integer.parseInt(tokens[1]);
                int extensionIndex = tokens[2].indexOf("-");
                if (extensionIndex > 0) {
                    patchVersion = Integer.parseInt(tokens[2].substring(0, extensionIndex));
                    extension = tokens[2].substring(extensionIndex + 1);
                } else {
                    patchVersion = Integer.parseInt(tokens[2]);
                    extension = null;
                }
                return new Version(majorVersion, minorVersion, patchVersion, extension);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Version String " + versionString + " is not in the expected format of x.x.x", e);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
            result = 31 * result + this.majorVersion;
            result = 31 * result + this.minorVersion;
            result = 31 * result + this.patchVersion;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
                return false;
            }
            if (this.majorVersion != other.majorVersion) {
                return false;
            }
            if (this.minorVersion != other.minorVersion) {
                return false;
            }
            return this.patchVersion == other.patchVersion;
        }

        @Override
        public int compareTo(Version other) {
            if (this.majorVersion > other.majorVersion) {
                return 1;
            }
            if (this.majorVersion < other.majorVersion) {
                return -1;
            }
            if (this.minorVersion > other.minorVersion) {
                return 1;
            }
            if (this.minorVersion < other.minorVersion) {
                return -1;
            }
            if (this.patchVersion > other.patchVersion) {
                return 1;
            }
            if (this.patchVersion < other.patchVersion) {
                return -1;
            }
            if (this.extension != null && other.extension != null) {
                return this.extension.compareTo(other.extension);
            }
            if (this.extension == null && other.extension == null) {
                return 0;
            }
            return this.extension != null ? -1 : 1;
        }
    }
}

