/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.api.ext.impl;

import com.appoptics.api.ext.TraceContext;
import com.appoptics.api.ext.impl.ITraceContextHandler;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.span.impl.ScopeContextSnapshot;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;

public class TraceContextHandler
implements ITraceContextHandler {
    private final Logger logger = LoggerFactory.getLogger();

    @Override
    public TraceContext getDefault() {
        Metadata md = new Metadata(Context.getMetadata());
        return new TraceContextConcrete(md, ScopeManager.INSTANCE.getSnapshot());
    }

    @Override
    public void clearDefault() {
        Context.clearMetadata();
        ScopeManager.INSTANCE.removeAllScopes();
    }

    @Override
    public boolean isSampled(String xTraceID) {
        try {
            return new Metadata(xTraceID).isSampled();
        }
        catch (OboeException e) {
            this.logger.warn("X-Trace ID [" + xTraceID + "] is not valid");
            return false;
        }
    }

    class TraceContextConcrete
    extends TraceContext {
        private final Metadata md;
        private final ScopeContextSnapshot scopeContextSnapshot;

        protected TraceContextConcrete(Metadata md, ScopeContextSnapshot scopeContextSnapshot) {
            this.md = md;
            this.scopeContextSnapshot = scopeContextSnapshot;
        }

        @Override
        public void setAsDefault() {
            if (this.scopeContextSnapshot != null) {
                ScopeManager.INSTANCE.removeAllScopes();
                this.scopeContextSnapshot.restore();
            }
            Context.setMetadata((Metadata)new Metadata(this.md));
        }
    }
}

