/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.api.ext.impl;

import com.appoptics.api.ext.TraceEvent;
import com.appoptics.api.ext.impl.ITraceHandler;
import com.appoptics.api.ext.impl.Utils;
import com.appoptics.api.ext.model.EventWrapper;
import com.appoptics.api.ext.model.NoOpEvent;
import com.appoptics.api.ext.model.StartTraceEvent;
import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.span.impl.Scope;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.Tracer;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.Map;

public class TraceHandler
implements ITraceHandler {
    private final Logger logger = LoggerFactory.getLogger();
    private static final NoOpEvent NO_OP = new NoOpEvent();

    @Override
    public TraceEvent startTrace(String layer) {
        return this.startOrContinueTrace(layer, null);
    }

    @Override
    public TraceEvent continueTrace(String layer, String inXTraceID) {
        return this.startOrContinueTrace(layer, inXTraceID);
    }

    @Override
    public String endTrace(String layer) {
        return this.endTrace(layer, null);
    }

    @Override
    public String endTrace(String layer, Map<String, Object> info) {
        Scope currentScope = ScopeManager.INSTANCE.active();
        if (currentScope == null) {
            this.logger.warn("Attempt to end a Trace but there's no active scope. Ignoring the operation");
            return "";
        }
        Span currentSpan = currentScope.span();
        if (!((Boolean)currentSpan.getSpanPropertyValue(Span.SpanProperty.IS_SDK)).booleanValue()) {
            this.logger.warn("Attempt to end a Trace but the active span was not created by SDK call. Ignoring the operation");
            return "";
        }
        if (!currentSpan.getOperationName().equals(layer)) {
            this.logger.warn("Mismatching span name on entry and exit trace event, entry event: " + currentSpan.getOperationName() + " ; exit event: " + layer);
        }
        if (info != null) {
            for (Map.Entry<String, Object> entry : info.entrySet()) {
                currentSpan.setTagAsObject(entry.getKey(), entry.getValue());
            }
        }
        currentSpan.finish();
        Long spanThreadId = (Long)currentSpan.getSpanPropertyValue(Span.SpanProperty.THREAD_ID);
        if (spanThreadId != null && spanThreadId.longValue() == Thread.currentThread().getId()) {
            currentScope.close();
        } else {
            this.logger.debug("Exiting trace on different thread. Trace started at " + spanThreadId + " but ending at " + Thread.currentThread().getId());
        }
        return (String)currentSpan.getSpanPropertyValue(Span.SpanProperty.EXIT_XID);
    }

    @Override
    public String endTrace(String layer, Object ... info) {
        return this.endTrace(layer, Utils.keyValuePairsToMap(info));
    }

    @Override
    public TraceEvent createEntryEvent(String layer) {
        return this.createEvent(layer, "entry");
    }

    @Override
    public TraceEvent createExitEvent(String layer) {
        return this.createEvent(layer, "exit");
    }

    @Override
    public TraceEvent createInfoEvent(String layer) {
        return this.createEvent(layer, "info");
    }

    @Override
    public void logException(Throwable error) {
        Event event = Context.createEvent();
        event.addInfo(new Object[]{"Label", "error", "ErrorClass", error.getClass().getName(), "ErrorMsg", error.getMessage()});
        ClassInstrumentation.addBackTrace((Event)event, (int)1);
        event.report();
    }

    @Override
    public String getCurrentXTraceID() {
        return Context.getMetadata().toHexString();
    }

    @Override
    public String getCurrentLogTraceId() {
        try {
            return Context.getMetadata().getCompactTraceId();
        }
        catch (NoSuchMethodError e) {
            this.logger.warn("Cannot get the trace id for log, require agent verion 6.10.0 or later : " + e.getMessage());
            return "";
        }
    }

    private TraceEvent createEvent(String layer, String eventType) {
        if (!Context.getMetadata().isSampled()) {
            return NO_OP;
        }
        Event event = Context.createEvent();
        event.addInfo(new Object[]{"Layer", layer, "Label", eventType});
        return event == null ? NO_OP : new EventWrapper(event);
    }

    private TraceEvent startOrContinueTrace(String layer, String inXTraceID) {
        return new StartTraceEvent(layer, inXTraceID);
    }

    @Override
    public boolean setTransactionName(String transactionName) {
        if (transactionName == null || "".equals(transactionName)) {
            return false;
        }
        boolean isSet = Tracer.setTraceProperty((Span.TraceProperty)Span.TraceProperty.CUSTOM_TRANSACTION_NAME, (Object)transactionName);
        if (!isSet) {
            this.logger.debug("Transaction name [" + transactionName + "] is ignored as current execution flow is not monitored by the agent");
        }
        return isSet;
    }
}

