/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.api.ext.model;

import com.appoptics.api.ext.TraceEvent;
import com.appoptics.api.ext.impl.Utils;
import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.joboe.XTraceHeader;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.Tracer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StartTraceEvent
implements TraceEvent {
    private Map<String, Object> keyValues = new HashMap<String, Object>();
    private StackTraceElement[] backTrace;
    private boolean isAsync;
    private final String layer;
    private final String inXTraceID;

    public StartTraceEvent(String layer, String inXTraceID) {
        this.layer = layer;
        this.inXTraceID = inXTraceID;
    }

    @Override
    public void addInfo(String key, Object value) {
        this.keyValues.put(key, value);
    }

    @Override
    public void addInfo(Map<String, Object> infoMap) {
        this.keyValues.putAll(infoMap);
    }

    @Override
    public void addInfo(Object ... info) {
        this.keyValues.putAll(Utils.keyValuePairsToMap(info));
    }

    @Override
    public void setAsync() {
        this.isAsync = true;
    }

    @Override
    public void addEdge(String xTraceID) {
    }

    @Override
    public void report() {
        Tracer.SpanBuilder spanBuilder = ClassInstrumentation.getStartTraceSpanBuilder((String)this.layer, this.inXTraceID != null ? Collections.singletonMap(XTraceHeader.TRACE_ID, this.inXTraceID) : Collections.emptyMap(), null);
        spanBuilder.withTags(this.keyValues);
        spanBuilder.withSpanProperty(Span.SpanProperty.THREAD_ID, (Object)Thread.currentThread().getId());
        Span span = spanBuilder.start();
        ScopeManager.INSTANCE.activate((com.tracelytics.joboe.span.Span)span);
        if (this.isAsync) {
            span.setSpanPropertyValue(Span.SpanProperty.IS_ASYNC, (Object)true);
        }
        if (this.backTrace != null) {
            ClassInstrumentation.addBackTrace((Span)span, (StackTraceElement[])this.backTrace);
        }
        span.setSpanPropertyValue(Span.SpanProperty.IS_SDK, (Object)true);
    }

    @Override
    public void addBackTrace() {
        this.backTrace = ClassInstrumentation.getBackTrace((int)1);
    }
}

