/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.OneLinkHttpTask;
import com.appsflyer.ServerConfigHandler;
import com.appsflyer.share.LinkGenerator;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class CreateOneLinkHttpTask
extends OneLinkHttpTask {
    private static final String TRACKING_LINK_LIVE_TIME_KEY = "ttl";
    private static final String TRACKING_LINK_DATA_KEY = "data";
    private static final String BRAND_DOMAIN = "brand_domain";
    private ResponseListener responseListener;
    private Map<String, String> data;
    private String ttl;
    private String packageName = "";
    private Context context;
    private String brandDomain;
    private boolean mTrackingStopped = false;

    public CreateOneLinkHttpTask(@NonNull String string, @NonNull Map<String, String> map, AppsFlyerLibCore appsFlyerLibCore, @NonNull Context context, boolean bl) {
        super(appsFlyerLibCore);
        this.mTrackingStopped = bl;
        this.context = context;
        if (this.context != null) {
            this.packageName = context.getPackageName();
        } else {
            AFLogger.afWarnLog("CreateOneLinkHttpTask: context can't be null");
        }
        this.oneLinkId = string;
        this.ttl = "-1";
        this.data = map;
    }

    public void setListener(@NonNull ResponseListener responseListener) {
        this.responseListener = responseListener;
    }

    public void setBrandDomain(String string) {
        this.brandDomain = string;
    }

    @Override
    void initRequest(HttpsURLConnection httpsURLConnection) throws JSONException, IOException {
        if (this.mTrackingStopped) {
            return;
        }
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setUseCaches(false);
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject(this.data);
        jSONObject.put(TRACKING_LINK_LIVE_TIME_KEY, (Object)this.ttl);
        jSONObject.put(TRACKING_LINK_DATA_KEY, (Object)jSONObject2);
        if (this.brandDomain != null) {
            jSONObject.put(BRAND_DOMAIN, (Object)this.brandDomain);
        }
        httpsURLConnection.connect();
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.writeBytes(jSONObject.toString());
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    @Override
    String getOneLinkUrl() {
        return ServerConfigHandler.getUrl("https://%sonelink.%s/shortlink-sdk/v1") + "/" + this.oneLinkId;
    }

    @Override
    void handleResponse(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.responseListener.onResponse(jSONObject.optString(string2));
            }
        }
        catch (JSONException jSONException) {
            this.responseListener.onResponseError("Can't parse one link data");
            AFLogger.afErrorLog("Error while parsing to json " + string, jSONException);
        }
    }

    @Override
    void onErrorResponse() {
        String string = AppsFlyerProperties.getInstance().getString("onelinkDomain");
        LinkGenerator linkGenerator = new LinkGenerator("af_app_invites").setBaseURL(this.oneLinkId, string, this.packageName).addParameter("af_siteid", this.packageName).addParameters(this.data);
        String string2 = AppsFlyerProperties.getInstance().getString("AppUserId");
        if (string2 != null) {
            linkGenerator.setReferrerCustomerId(string2);
        }
        String string3 = linkGenerator.generateLink();
        this.responseListener.onResponse(string3);
    }

    public static interface ResponseListener {
        @WorkerThread
        public void onResponse(String var1);

        @WorkerThread
        public void onResponseError(String var1);
    }
}

