/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import com.appsflyer.AndroidUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;

class AFKeystoreWrapper {
    final Object \u0131 = new Object();
    KeyStore \u0399;
    private Context \u01c3;
    String \u03b9;
    int \u0269;

    public AFKeystoreWrapper(Context context) {
        this.\u01c3 = context;
        this.\u03b9 = "";
        this.\u0269 = 0;
        AFKeystoreWrapper aFKeystoreWrapper = this;
        AFLogger.afInfoLog("Initialising KeyStore..");
        try {
            aFKeystoreWrapper.\u0399 = KeyStore.getInstance("AndroidKeyStore");
            aFKeystoreWrapper.\u0399.load(null);
            return;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            AFLogger.afErrorLog("Couldn't load keystore instance of type: AndroidKeyStore", exception);
            return;
        }
    }

    final boolean \u03b9() {
        boolean bl = false;
        Object object = this.\u0131;
        synchronized (object) {
            if (this.\u0399 != null) {
                try {
                    Enumeration<String> enumeration = this.\u0399.aliases();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        if (string == null || !AFKeystoreWrapper.\u0269(string)) continue;
                        String[] stringArray = string.split(",");
                        if (stringArray.length == 3) {
                            AFLogger.afInfoLog("Found a matching AF key with alias:\n".concat(String.valueOf(string)));
                            bl = true;
                            String[] stringArray2 = stringArray[1].trim().split("=");
                            String[] stringArray3 = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray3.length == 2) {
                                this.\u03b9 = stringArray2[1].trim();
                                this.\u0269 = Integer.parseInt(stringArray3[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't list KeyStore Aliases: " + throwable.getClass().getName(), throwable);
                }
            }
        }
        return bl;
    }

    final void \u01c3(String string) {
        AFLogger.afInfoLog("Creating a new key with alias: ".concat(String.valueOf(string)));
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 5);
            KeyGenParameterSpec keyGenParameterSpec = null;
            Object object = this.\u0131;
            synchronized (object) {
                if (!this.\u0399.containsAlias(string)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder(string, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18 && !AndroidUtils.\u0269()) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.\u01c3).setAlias(string).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    keyPairGenerator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
                } else {
                    AFLogger.afInfoLog("Alias already exists: ".concat(String.valueOf(string)));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception " + throwable.getMessage() + " occurred", throwable);
            return;
        }
    }

    private static boolean \u0269(String string) {
        return string.startsWith("com.appsflyer");
    }

    final String \u0269() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer,");
        Object object = this.\u0131;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId=").append(this.\u03b9).append(",");
            stringBuilder.append("KSAppsFlyerRICounter=").append(this.\u0269);
        }
        return ((Object)stringBuilder).toString();
    }

    final String \u0399() {
        Object object = this.\u0131;
        synchronized (object) {
            return this.\u03b9;
        }
    }

    final int \u0131() {
        Object object = this.\u0131;
        synchronized (object) {
            return this.\u0269;
        }
    }
}

