/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal.event.uninstall;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.appsflyer.AFDateFormat;
import com.appsflyer.AFFacebookDeferredDeeplink;
import com.appsflyer.AFLogger;
import com.appsflyer.AdvertisingIdObject;
import com.appsflyer.AdvertisingIdUtil;
import com.appsflyer.AndroidUtils;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerLibCore;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.BackgroundHttpTask;
import com.appsflyer.FirebaseMessagingServiceListener;
import com.appsflyer.Installation;
import com.appsflyer.ServerConfigHandler;
import com.appsflyer.internal.model.event.BackgroundEvent;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;

public final class Register
extends BackgroundEvent {
    @VisibleForTesting
    public static final String TOKEN_PAYLOAD_KEY = "af_gcm_token";
    @VisibleForTesting
    public static final String TOKEN_PERSIST_KEY = "afUninstallToken";
    @VisibleForTesting
    public static final String TOKEN_RECEIVED_TIME_PERSIST_KEY = "afUninstallToken_received_time";
    @VisibleForTesting
    public static String URL = "https://%sregister.%s/api/v" + AppsFlyerLibCore.BUILD_URL_SUFFIX;
    private final SharedPreferences getDataFormatter;

    public Register(@NonNull Context context) {
        super(null, ServerConfigHandler.getUrl(URL) + context.getPackageName(), null, null, null, context);
        this.getDataFormatter = AppsFlyerLibCore.getSharedPreferences(context);
    }

    public static boolean didConfiguredFirebaseMessagingServiceListener(Context context) {
        if (AppsFlyerLib.getInstance().isStopped()) {
            return false;
        }
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessagingService");
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT", null, context, FirebaseMessagingServiceListener.class);
            if (AndroidUtils.isServiceAvailable(context, intent)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest declarations: ", throwable);
        }
        return false;
    }

    public static boolean isSent(@NonNull SharedPreferences sharedPreferences) {
        return sharedPreferences.getBoolean("sentRegisterRequestToAF", false);
    }

    /*
     * Unable to fully structure code
     */
    public final void send(String var1_1) {
        block3: {
            block4: {
                if (var1_1 == null) break block3;
                AFLogger.afInfoLog("Firebase Refreshed Token = ".concat(String.valueOf(var1_1)));
                var2_2 = this.values();
                if (var2_2 == null) break block4;
                var7_3 = var2_2;
                if (var1_1.equals(var7_3.valueOf)) break block3;
            }
            var3_4 = System.currentTimeMillis();
            if (!AppsFlyerLibCore.firstCallSent(this.getDataFormatter)) ** GOTO lbl-1000
            if (var2_2 == null) ** GOTO lbl-1000
            var7_3 = var2_2;
            if (var3_4 - var7_3.AFDateFormat > TimeUnit.SECONDS.toMillis(2L)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var5_5 = v0;
            v1 = var6_6 = new AFFacebookDeferredDeeplink(var1_1, var3_4, var5_5 == false);
            var7_3 = v1;
            var7_3 = var6_6;
            this.getDataFormatter.edit().putString("afUninstallToken", v1.valueOf).putLong("afUninstallToken_received_time", var7_3.AFDateFormat).putBoolean("afUninstallToken_queued", var6_6.values()).apply();
            if (var5_5) {
                this.AFDateFormat(var1_1);
            }
        }
    }

    public final void sendIfQueued() {
        AFFacebookDeferredDeeplink aFFacebookDeferredDeeplink = this.values();
        if (aFFacebookDeferredDeeplink != null && aFFacebookDeferredDeeplink.values()) {
            AFFacebookDeferredDeeplink aFFacebookDeferredDeeplink2 = aFFacebookDeferredDeeplink;
            String string = aFFacebookDeferredDeeplink2.valueOf;
            AFLogger.afDebugLog("Resending Uninstall token to AF servers: ".concat(String.valueOf(string)));
            this.AFDateFormat(string);
        }
    }

    @Nullable
    private AFFacebookDeferredDeeplink values() {
        String[] stringArray;
        String string;
        String string2 = this.getDataFormatter.getString(TOKEN_PERSIST_KEY, null);
        long l2 = this.getDataFormatter.getLong(TOKEN_RECEIVED_TIME_PERSIST_KEY, 0L);
        boolean bl = this.getDataFormatter.getBoolean("afUninstallToken_queued", false);
        this.getDataFormatter.edit().putBoolean("afUninstallToken_queued", false).apply();
        if (string2 == null && (string = AppsFlyerProperties.getInstance().getString(TOKEN_PERSIST_KEY)) != null) {
            stringArray = string.split(",");
            string2 = stringArray[stringArray.length - 1];
        }
        if (l2 == 0L && (string = AppsFlyerProperties.getInstance().getString(TOKEN_PERSIST_KEY)) != null && (stringArray = string.split(",")).length >= 2) {
            try {
                l2 = Long.parseLong(stringArray[stringArray.length - 2]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (string2 != null) {
            return new AFFacebookDeferredDeeplink(string2, l2, bl);
        }
        return null;
    }

    private void AFDateFormat(String string) {
        String string2;
        AdvertisingIdObject advertisingIdObject;
        Object object;
        Application application = this.context();
        AppsFlyerLibCore appsFlyerLibCore = AppsFlyerLibCore.getInstance();
        if (appsFlyerLibCore.waitingForId()) {
            AFLogger.afInfoLog("CustomerUserId not set, Tracking is disabled", true);
            return;
        }
        String string3 = appsFlyerLibCore.getProperty("AppsFlyerKey");
        if (string3 == null) {
            AFLogger.afWarnLog("[registerUninstall] AppsFlyer's SDK cannot send any event without providing DevKey.");
            return;
        }
        PackageManager packageManager = application.getPackageManager();
        String string4 = application.getPackageName();
        try {
            object = packageManager.getPackageInfo(string4, 0);
            this.params.put("app_version_code", Integer.toString(object.versionCode));
            this.params.put("app_version_name", object.versionName);
            String string5 = packageManager.getApplicationLabel(object.applicationInfo).toString();
            this.params.put("app_name", string5);
            long l2 = object.firstInstallTime;
            SimpleDateFormat simpleDateFormat = AFDateFormat.getDataFormatter("yyyy-MM-dd_HHmmssZ");
            this.params.put("installDate", appsFlyerLibCore.dateFormatUTC(simpleDateFormat, l2));
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception while collecting application version info.", throwable);
        }
        appsFlyerLibCore.addNetworkData((Context)application, this.params);
        object = appsFlyerLibCore.getCustomerUserId();
        if (object != null) {
            this.params.put("appUserId", object);
        }
        try {
            this.params.put("model", Build.MODEL);
            this.params.put("brand", Build.BRAND);
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception while collecting device brand and model.", throwable);
        }
        if (AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false)) {
            this.params.put("deviceTrackingDisabled", "true");
        }
        if ((advertisingIdObject = AdvertisingIdUtil.getAmazonAID(application.getContentResolver())) != null) {
            this.params.put("amazon_aid", advertisingIdObject.getAdvertisingId());
            this.params.put("amazon_aid_limit", String.valueOf(advertisingIdObject.isLimitAdTracking()));
        }
        if ((string2 = AppsFlyerProperties.getInstance().getString("advertiserId")) != null) {
            this.params.put("advertiserId", string2);
        }
        this.params.put("devkey", string3);
        this.params.put("uid", Installation.id(new WeakReference<Application>(application)));
        this.params.put(TOKEN_PAYLOAD_KEY, string);
        int n = appsFlyerLibCore.getLaunchCounter(this.getDataFormatter, false);
        this.params.put("launch_counter", Integer.toString(n));
        this.params.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
        String string6 = appsFlyerLibCore.getConfiguredChannel((Context)application);
        if (string6 != null) {
            this.params.put("channel", string6);
        }
        new Thread(new Runnable(this, appsFlyerLibCore){
            private /* synthetic */ AppsFlyerLibCore values;
            private /* synthetic */ Register AFDateFormat;
            {
                this.AFDateFormat = register;
                this.values = appsFlyerLibCore;
            }

            @Override
            public final void run() {
                try {
                    HttpURLConnection httpURLConnection = new BackgroundHttpTask(this.AFDateFormat.trackingStopped(((AppsFlyerLib)this.values).isStopped())).doInBackground();
                    if (httpURLConnection != null) {
                        if (httpURLConnection.getResponseCode() == 200) {
                            Register.$$b(this.AFDateFormat);
                        }
                        httpURLConnection.disconnect();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    AFLogger.afErrorLog(throwable.getMessage(), throwable2);
                    return;
                }
            }
        }).start();
    }

    static /* synthetic */ void $$b(Register register) {
        register.getDataFormatter.edit().putBoolean("sentRegisterRequestToAF", true).apply();
        AFLogger.afDebugLog("Successfully registered for Uninstall Tracking");
    }
}

