/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1aSDK;
import com.appsflyer.internal.AFc1dSDK;
import com.appsflyer.internal.AFc1xSDK;
import com.appsflyer.internal.AFd1dSDK;
import com.appsflyer.internal.AFd1qSDK;
import com.appsflyer.internal.AFd1sSDK;
import com.appsflyer.internal.AFd1tSDK;
import com.appsflyer.internal.AFe1oSDK;
import java.util.Map;
import org.json.JSONException;

public final class AFe1hSDK
extends AFd1qSDK<Void> {
    private final AFc1xSDK afRDLog;
    @Nullable
    private final AFc1aSDK<String> afDebugLog;
    @Nullable
    private final Throwable afErrorLog;

    public AFe1hSDK(AFd1dSDK aFd1dSDK, AFc1xSDK aFc1xSDK) {
        super(AFd1sSDK.afRDLog, new AFd1sSDK[]{AFd1sSDK.AFInAppEventParameterName}, "GCD-CHECK");
        this.afErrorLog = aFd1dSDK.afRDLog();
        this.afDebugLog = aFd1dSDK.afInfoLog;
        this.afRDLog = aFc1xSDK;
    }

    @Override
    @NonNull
    public final AFd1tSDK AFInAppEventType() throws Exception {
        Map<String, Object> map;
        int n = this.afRDLog.AFKeystoreWrapper("appsFlyerCount", 0);
        AFLogger.afDebugLog("[GCD-A01] Loading conversion data. Counter: ".concat(String.valueOf(n)));
        long l = this.afRDLog.AFKeystoreWrapper("appsflyerConversionDataCacheExpiration", 0L);
        if (l != 0L && System.currentTimeMillis() - l > 5184000000L) {
            AFLogger.afDebugLog("[GCD-E02] Cached conversion data expired");
            this.afRDLog.AFInAppEventType("sixtyDayConversionData", true);
            this.afRDLog.AFKeystoreWrapper("attributionId", null);
            this.afRDLog.AFInAppEventType("appsflyerConversionDataCacheExpiration", 0L);
        }
        if ((map = this.AFLogger()) != null) {
            try {
                if (!map.containsKey("is_first_launch")) {
                    map.put("is_first_launch", Boolean.FALSE);
                }
                AFe1oSDK.valueOf(map);
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
            }
            return AFd1tSDK.AFInAppEventType;
        }
        try {
            if (this.afErrorLog != null) {
                AFe1oSDK.AFInAppEventType("Launch exception: " + this.afErrorLog.getMessage());
                return AFd1tSDK.AFInAppEventType;
            }
            if (this.afDebugLog != null && !this.afDebugLog.isSuccessful()) {
                AFe1oSDK.AFInAppEventType("Launch status code: " + this.afDebugLog.getStatusCode());
                return AFd1tSDK.AFInAppEventType;
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
        }
        return AFd1tSDK.values;
    }

    @Override
    public final long AFInAppEventParameterName() {
        return 1000L;
    }

    @Override
    public final boolean values() {
        return false;
    }

    @Nullable
    private Map<String, Object> AFLogger() {
        String string = this.afRDLog.AFInAppEventType("attributionId", null);
        if (string == null) {
            return null;
        }
        try {
            new AFc1dSDK();
            return AFc1dSDK.AFKeystoreWrapper(string);
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLog("[GCD] Failed to parse GCD response: " + jSONException.getMessage(), jSONException);
            return null;
        }
    }
}

