/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFa1dSDK;
import com.appsflyer.internal.AFb1lSDK;

public class AFLogger {
    private static final long AFInAppEventType = System.currentTimeMillis();

    public static void afInfoLog(String string, boolean bl) {
        if (AFLogger.values(LogLevel.INFO)) {
            Log.i((String)"AppsFlyer_6.11.2", (String)AFLogger.valueOf(string, false));
        }
        if (bl) {
            AFa1dSDK.AFInAppEventType().AFInAppEventParameterName().getLevel().AFInAppEventParameterName("I", AFLogger.valueOf(string, true));
        }
    }

    @NonNull
    private static String valueOf(String string, boolean bl) {
        if (string == null) {
            string = "null";
        }
        if (bl || LogLevel.VERBOSE.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            return "(" + (System.currentTimeMillis() - AFInAppEventType) + ") [" + Thread.currentThread().getName() + "] " + string;
        }
        return string;
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            string = throwable.getClass().getSimpleName() + " at " + ((Object)throwable.getStackTrace()[0]).toString();
        }
        if (AFLogger.values(LogLevel.ERROR)) {
            String string2 = AFLogger.valueOf(string, false);
            if (bl2) {
                Log.e((String)"AppsFlyer_6.11.2", (String)string2, (Throwable)throwable);
            } else if (bl) {
                Log.d((String)"AppsFlyer_6.11.2", (String)string2);
            }
        }
        AFa1dSDK.AFInAppEventType().AFInAppEventParameterName().getLevel().AFInAppEventParameterName(throwable);
        if (AFb1lSDK.valueOf != null) {
            AFa1dSDK.AFInAppEventParameterName((Context)AFb1lSDK.valueOf).edit().putLong("exception_number", (AFb1lSDK.valueOf == null ? -1L : AFa1dSDK.AFInAppEventParameterName((Context)AFb1lSDK.valueOf).getLong("exception_number", 0L)) + 1L).apply();
        }
        if (bl3) {
            AFa1dSDK.AFInAppEventType().AFInAppEventParameterName().onDeepLinking().AFKeystoreWrapper(throwable, string);
        }
    }

    public static void valueOf(String string) {
        if (AFLogger.values(LogLevel.WARNING)) {
            Log.w((String)"AppsFlyer_6.11.2", (String)AFLogger.valueOf(string, false));
        }
        AFa1dSDK.AFInAppEventType().AFInAppEventParameterName().getLevel().AFInAppEventParameterName("W", AFLogger.valueOf(string, true));
    }

    public static void afRDLog(String string) {
        if (AFLogger.values(LogLevel.VERBOSE)) {
            Log.v((String)"AppsFlyer_6.11.2", (String)AFLogger.valueOf(string, false));
        }
        AFa1dSDK.AFInAppEventType().AFInAppEventParameterName().getLevel().AFInAppEventParameterName("V", AFLogger.valueOf(string, true));
    }

    private static boolean values(LogLevel logLevel) {
        return logLevel.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel());
    }

    public static void AFKeystoreWrapper(String string) {
        if (!AFLogger.AFKeystoreWrapper()) {
            Log.d((String)"AppsFlyer_6.11.2", (String)AFLogger.valueOf(string, false));
        }
        AFa1dSDK.AFInAppEventType().AFInAppEventParameterName().getLevel().AFInAppEventParameterName("F", string);
    }

    private static boolean AFKeystoreWrapper() {
        return AppsFlyerProperties.getInstance().isLogsDisabledCompletely();
    }

    public static void afDebugLog(String string) {
        if (AFLogger.values(LogLevel.DEBUG)) {
            Log.d((String)"AppsFlyer_6.11.2", (String)AFLogger.valueOf(string, false));
        }
        AFa1dSDK.AFInAppEventType().AFInAppEventParameterName().getLevel().AFInAppEventParameterName("D", AFLogger.valueOf(string, true));
    }

    public static void afInfoLog(String string) {
        AFLogger.afInfoLog(string, true);
    }

    public static void afErrorLog(String string, Throwable throwable) {
        AFLogger.afErrorLog(string, throwable, true, false, true);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly(string, throwable, false);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, false, false, !bl);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, true, bl, true);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2) {
        AFLogger.afErrorLog(string, throwable, true, bl, bl2);
    }

    @Deprecated
    public static void afErrorLog(Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly("Unknown", throwable);
    }

    public static void afWarnLog(String string) {
        AFLogger.valueOf(string);
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5);

        private int valueOf;

        private LogLevel(int n2) {
            this.valueOf = n2;
        }

        public final int getLevel() {
            return this.valueOf;
        }
    }
}

