/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.util.Log;
import androidx.annotation.NonNull;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFb1tSDK;

public class AFLogger {
    private static final long values = System.currentTimeMillis();

    public static void afInfoLog(String string, boolean bl) {
        if (AFLogger.values(LogLevel.INFO)) {
            Log.i((String)"AppsFlyer_6.12.5", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        if (bl) {
            AFb1tSDK.AFKeystoreWrapper().values().AFLogger$LogLevel().AFKeystoreWrapper("I", AFLogger.AFInAppEventParameterName(string, true));
        }
    }

    @NonNull
    private static String AFInAppEventParameterName(String string, boolean bl) {
        if (string == null) {
            string = "null";
        }
        if (bl || LogLevel.VERBOSE.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            return "(" + (System.currentTimeMillis() - values) + ") [" + Thread.currentThread().getName() + "] " + string;
        }
        return string;
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            string = throwable.getClass().getSimpleName() + " at " + ((Object)throwable.getStackTrace()[0]).toString();
        }
        if (AFLogger.values(LogLevel.ERROR)) {
            String string2 = AFLogger.AFInAppEventParameterName(string, false);
            if (bl2) {
                Log.e((String)"AppsFlyer_6.12.5", (String)string2, (Throwable)throwable);
            } else if (bl) {
                Log.d((String)"AppsFlyer_6.12.5", (String)string2);
            }
        }
        AFb1tSDK.AFKeystoreWrapper().values().AFLogger$LogLevel().AFInAppEventType(throwable);
        if (bl3) {
            AFb1tSDK.AFKeystoreWrapper().values().onResponseNative().AFInAppEventParameterName(throwable, string);
        }
    }

    public static void AFInAppEventParameterName(String string) {
        if (AFLogger.values(LogLevel.WARNING)) {
            Log.w((String)"AppsFlyer_6.12.5", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFb1tSDK.AFKeystoreWrapper().values().AFLogger$LogLevel().AFKeystoreWrapper("W", AFLogger.AFInAppEventParameterName(string, true));
    }

    public static void afRDLog(String string) {
        if (AFLogger.values(LogLevel.VERBOSE)) {
            Log.v((String)"AppsFlyer_6.12.5", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFb1tSDK.AFKeystoreWrapper().values().AFLogger$LogLevel().AFKeystoreWrapper("V", AFLogger.AFInAppEventParameterName(string, true));
    }

    private static boolean values(LogLevel logLevel) {
        return logLevel.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel());
    }

    public static void values(String string) {
        if (!AFLogger.AFKeystoreWrapper()) {
            Log.d((String)"AppsFlyer_6.12.5", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFb1tSDK.AFKeystoreWrapper().values().AFLogger$LogLevel().AFKeystoreWrapper("F", string);
    }

    private static boolean AFKeystoreWrapper() {
        return AppsFlyerProperties.getInstance().isLogsDisabledCompletely();
    }

    public static void afDebugLog(String string) {
        if (AFLogger.values(LogLevel.DEBUG)) {
            Log.d((String)"AppsFlyer_6.12.5", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFb1tSDK.AFKeystoreWrapper().values().AFLogger$LogLevel().AFKeystoreWrapper("D", AFLogger.AFInAppEventParameterName(string, true));
    }

    public static void afInfoLog(String string) {
        AFLogger.afInfoLog(string, true);
    }

    public static void afErrorLog(String string, Throwable throwable) {
        AFLogger.afErrorLog(string, throwable, true, false, true);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly(string, throwable, false);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, false, false, !bl);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, true, bl, true);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2) {
        AFLogger.afErrorLog(string, throwable, true, bl, bl2);
    }

    @Deprecated
    public static void afErrorLog(Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly("Unknown", throwable);
    }

    public static void afWarnLog(String string) {
        AFLogger.AFInAppEventParameterName(string);
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5);

        private int AFKeystoreWrapper;

        private LogLevel(int n2) {
            this.AFKeystoreWrapper = n2;
        }

        public final int getLevel() {
            return this.AFKeystoreWrapper;
        }
    }
}

