/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1bSDK;
import com.appsflyer.internal.AFh1eSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFh1aSDK {
    private final boolean getRevenue;
    @NonNull
    public final String getMediationNetwork;
    @NonNull
    public final String AFAdRevenueData;
    @NonNull
    public final AFh1eSDK getCurrencyIso4217Code;
    @Nullable
    public final AFh1bSDK getMonetizationNetwork;

    public AFh1aSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getMediationNetwork = jSONObject.getString("ver");
            this.getRevenue = jSONObject.optBoolean("test_mode");
            this.AFAdRevenueData = object;
            this.getCurrencyIso4217Code = this.getMediationNetwork.startsWith("default") ? AFh1eSDK.getRevenue : AFh1eSDK.getMediationNetwork;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1bSDK(jSONObject);
            }
            this.getMonetizationNetwork = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFh1aSDK aFh1aSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFh1aSDK = aFh1aSDK;
        if (this.getRevenue != aFh1aSDK.getRevenue) {
            return false;
        }
        if (!this.getMediationNetwork.equals(aFh1aSDK.getMediationNetwork)) {
            return false;
        }
        return this.AFAdRevenueData.equals(aFh1aSDK.AFAdRevenueData);
    }

    public final int hashCode() {
        int n = this.getRevenue ? 1 : 0;
        n = n * 31 + this.getMediationNetwork.hashCode();
        n = n * 31 + this.AFAdRevenueData.hashCode();
        if (this.getMonetizationNetwork != null) {
            n = n * 31 + ((Object)this.getMonetizationNetwork).hashCode();
        }
        return n;
    }
}

