/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1cSDK;
import com.appsflyer.internal.AFi1zSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1vSDK {
    private final boolean getMonetizationNetwork;
    @NonNull
    public final String getMediationNetwork;
    @NonNull
    public final String AFAdRevenueData;
    @NonNull
    public final AFi1zSDK getCurrencyIso4217Code;
    @Nullable
    public final AFh1cSDK getRevenue;

    public AFi1vSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getMediationNetwork = jSONObject.getString("ver");
            this.getMonetizationNetwork = jSONObject.optBoolean("test_mode");
            this.AFAdRevenueData = object;
            this.getCurrencyIso4217Code = this.getMediationNetwork.startsWith("default") ? AFi1zSDK.getRevenue : AFi1zSDK.getMonetizationNetwork;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1cSDK(jSONObject);
            }
            this.getRevenue = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1vSDK aFi1vSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1vSDK = aFi1vSDK;
        if (this.getMonetizationNetwork != aFi1vSDK.getMonetizationNetwork) {
            return false;
        }
        if (!this.getMediationNetwork.equals(aFi1vSDK.getMediationNetwork)) {
            return false;
        }
        return this.AFAdRevenueData.equals(aFi1vSDK.AFAdRevenueData);
    }

    public final int hashCode() {
        int n = this.getMonetizationNetwork ? 1 : 0;
        n = n * 31 + this.getMediationNetwork.hashCode();
        n = n * 31 + this.AFAdRevenueData.hashCode();
        if (this.getRevenue != null) {
            n = n * 31 + ((Object)this.getRevenue).hashCode();
        }
        return n;
    }
}

