/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFd1pSDK;
import com.appsflyer.internal.AFe1aSDK;
import com.appsflyer.internal.AFe1jSDK;
import com.appsflyer.internal.AFe1nSDK;
import com.appsflyer.internal.AFf1rSDK;
import com.appsflyer.internal.AFf1wSDK;
import com.appsflyer.internal.AFg1ySDK;
import com.appsflyer.internal.AFh1vSDK;
import java.util.Map;
import org.json.JSONException;

public final class AFh1uSDK
extends AFe1aSDK<Void> {
    private final AFd1pSDK component4;
    @Nullable
    private final AFe1jSDK<String> component1;
    @Nullable
    private final Throwable areAllFieldsValid;

    public AFh1uSDK(AFg1ySDK aFg1ySDK, AFd1pSDK aFd1pSDK) {
        super(AFf1rSDK.hashCode, new AFf1rSDK[]{AFf1rSDK.getRevenue}, "GCD-CHECK");
        this.areAllFieldsValid = aFg1ySDK.component4();
        this.component1 = aFg1ySDK.component1;
        this.component4 = aFd1pSDK;
    }

    @Override
    @NonNull
    public final AFf1wSDK getCurrencyIso4217Code() throws Exception {
        Map<String, Object> map;
        int n = this.component4.AFAdRevenueData("appsFlyerCount", 0);
        AFLogger.afDebugLog("[GCD-A01] Loading conversion data. Counter: ".concat(String.valueOf(n)));
        long l = this.component4.getMediationNetwork("appsflyerConversionDataCacheExpiration", 0L);
        if (l != 0L && System.currentTimeMillis() - l > 5184000000L) {
            AFLogger.afDebugLog("[GCD-E02] Cached conversion data expired");
            this.component4.getRevenue("sixtyDayConversionData", true);
            this.component4.getMonetizationNetwork("attributionId", null);
            this.component4.getMonetizationNetwork("appsflyerConversionDataCacheExpiration", 0L);
        }
        if ((map = this.areAllFieldsValid()) != null) {
            try {
                if (!map.containsKey("is_first_launch")) {
                    map.put("is_first_launch", Boolean.FALSE);
                }
                AFh1vSDK.getCurrencyIso4217Code(map);
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
            }
            return AFf1wSDK.getRevenue;
        }
        try {
            if (this.areAllFieldsValid != null) {
                AFh1vSDK.getMonetizationNetwork("Launch exception: " + this.areAllFieldsValid.getMessage());
                return AFf1wSDK.getRevenue;
            }
            if (this.component1 != null && !this.component1.isSuccessful()) {
                AFh1vSDK.getMonetizationNetwork("Launch status code: " + this.component1.getStatusCode());
                return AFf1wSDK.getRevenue;
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
        }
        return AFf1wSDK.getMediationNetwork;
    }

    @Override
    public final long getMonetizationNetwork() {
        return 1000L;
    }

    @Override
    public final boolean getRevenue() {
        return false;
    }

    @Nullable
    private Map<String, Object> areAllFieldsValid() {
        String string = this.component4.getCurrencyIso4217Code("attributionId", null);
        if (string == null) {
            return null;
        }
        try {
            new AFe1nSDK();
            return AFe1nSDK.getMonetizationNetwork(string);
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLog("[GCD] Failed to parse GCD response: " + jSONException.getMessage(), jSONException);
            return null;
        }
    }
}

