/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import com.appsflyer.internal.AFi1rSDK;
import com.appsflyer.internal.AFi1tSDK;
import com.appsflyer.internal.AFi1wSDK;
import java.util.ArrayList;
import java.util.List;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1xSDK {
    @Nullable
    public final AFi1wSDK getMonetizationNetwork;
    @Nullable
    public final AFi1tSDK getCurrencyIso4217Code;
    @Nullable
    public AFi1rSDK getMediationNetwork;

    public AFi1xSDK(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"");
        this.getMediationNetwork = AFi1xSDK.getCurrencyIso4217Code(jSONObject);
        this.getMonetizationNetwork = AFi1xSDK.getMediationNetwork(jSONObject);
        this.getCurrencyIso4217Code = AFi1xSDK.getMonetizationNetwork(jSONObject);
    }

    private static AFi1tSDK getMonetizationNetwork(JSONObject object) {
        try {
            AFi1tSDK aFi1tSDK;
            JSONObject jSONObject = AFi1xSDK.getCurrencyIso4217Code((JSONObject)object, "meta_data");
            if (jSONObject != null) {
                double d = jSONObject.optDouble("send_rate", 1.0);
                aFi1tSDK = new AFi1tSDK(d);
            } else {
                aFi1tSDK = null;
            }
            object = Result.constructor-impl(aFi1tSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1tSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFi1wSDK getMediationNetwork(JSONObject object) {
        try {
            AFi1wSDK aFi1wSDK;
            JSONObject jSONObject = AFi1xSDK.getCurrencyIso4217Code((JSONObject)object, "exc_mngr");
            if (jSONObject != null) {
                object = jSONObject;
                String string = jSONObject.getString("sdk_ver");
                int n = object.optInt("min", -1);
                int n2 = object.optInt("expire", -1);
                long l = object.optLong("ttl", -1L);
                aFi1wSDK = new AFi1wSDK(string, n, n2, l);
            } else {
                aFi1wSDK = null;
            }
            object = Result.constructor-impl(aFi1wSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1wSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFi1rSDK getCurrencyIso4217Code(JSONObject object) {
        try {
            AFi1rSDK aFi1rSDK;
            JSONObject jSONObject = AFi1xSDK.getCurrencyIso4217Code(object, "r_debugger");
            if (jSONObject != null) {
                List list;
                object = jSONObject;
                long l = jSONObject.getLong("ttl");
                int n = object.getInt("counter");
                String string = object.optString("app_ver", "");
                String string2 = object.optString("sdk_ver", "");
                float f = (float)object.optDouble("ratio", 1.0);
                if ((object = object.optJSONArray("tags")) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                    List list2 = new ArrayList();
                    int n2 = object.length();
                    for (int i = 0; i < n2; ++i) {
                        String string3 = object.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                        list2.add(string3);
                    }
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                aFi1rSDK = new AFi1rSDK(l, f, (List<String>)object, n, string, string2);
            } else {
                aFi1rSDK = null;
            }
            object = Result.constructor-impl(aFi1rSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1rSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static JSONObject getCurrencyIso4217Code(JSONObject jSONObject, String string) throws JSONException, NullPointerException {
        if (jSONObject.has(string)) {
            if ((jSONObject = jSONObject.getJSONArray(string).optJSONObject(0).optJSONObject("data")) != null) {
                return jSONObject.optJSONObject("v1");
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"");
        AFi1xSDK cfr_ignored_0 = (AFi1xSDK)other;
        if (!Intrinsics.areEqual((Object)this.getMonetizationNetwork, (Object)((AFi1xSDK)other).getMonetizationNetwork)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCurrencyIso4217Code, (Object)((AFi1xSDK)other).getCurrencyIso4217Code)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getMediationNetwork, (Object)((AFi1xSDK)var1_1).getMediationNetwork);
    }

    public final int hashCode() {
        AFi1wSDK aFi1wSDK = this.getMonetizationNetwork;
        int n = aFi1wSDK != null ? ((Object)aFi1wSDK).hashCode() : 0;
        AFi1tSDK aFi1tSDK = this.getCurrencyIso4217Code;
        n = n * 31 + (aFi1tSDK != null ? aFi1tSDK.hashCode() : 0);
        AFi1rSDK aFi1rSDK = this.getMediationNetwork;
        return n * 31 + (aFi1rSDK != null ? ((Object)aFi1rSDK).hashCode() : 0);
    }
}

