/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1wSDK;
import com.appsflyer.internal.AFe1hSDK;
import com.appsflyer.internal.AFe1kSDK;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class AFe1fSDK
extends AFe1kSDK {
    public final Map<String, Object> AFInAppEventParameterName = new HashMap<String, Object>();

    public AFe1fSDK(Runnable runnable) {
        super("store", "google", runnable);
    }

    private static boolean AFKeystoreWrapper(@NonNull Context context) {
        if (!AFe1fSDK.values(context)) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1wSDK.values(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(final Context context) {
        if (!AFe1fSDK.AFKeystoreWrapper(context)) {
            return;
        }
        AFe1fSDK aFe1fSDK = this;
        this.afDebugLog = System.currentTimeMillis();
        aFe1fSDK.afRDLog = AFe1hSDK.AFa1zSDK.AFInAppEventParameterName;
        aFe1fSDK.addObserver(new Observer(aFe1fSDK){
            private /* synthetic */ AFe1hSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFe1hSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFInAppEventParameterName.values.run();
            }
        });
        try {
            aFe1fSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFe1fSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFe1fSDK){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                {
                    this.val$referrerClient = installReferrerClient;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFe1fSDK.this.AFInAppEventParameterName.put("code", String.valueOf(n));
                    String string = "com.android.vending";
                    AFe1fSDK.this.AFInAppEventType.put("api_ver", AFb1wSDK.AFKeystoreWrapper(context, string));
                    AFe1fSDK.this.AFInAppEventType.put("api_ver_name", AFb1wSDK.AFInAppEventParameterName(context, string));
                    switch (n) {
                        case 0: {
                            AFe1fSDK.this.AFInAppEventType.put("response", "OK");
                            try {
                                AFLogger.afDebugLog("InstallReferrer connected");
                                if (this.val$referrerClient.isReady()) {
                                    ReferrerDetails referrerDetails = this.val$referrerClient.getInstallReferrer();
                                    String string2 = referrerDetails.getInstallReferrer();
                                    if (string2 != null) {
                                        AFe1fSDK.this.AFInAppEventParameterName.put("val", string2);
                                        AFe1fSDK.this.AFInAppEventType.put("referrer", string2);
                                    }
                                    long l = referrerDetails.getReferrerClickTimestampSeconds();
                                    AFe1fSDK.this.AFInAppEventParameterName.put("clk", Long.toString(l));
                                    AFe1fSDK.this.AFInAppEventType.put("click_ts", l);
                                    long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                                    AFe1fSDK.this.AFInAppEventParameterName.put("install", Long.toString(l2));
                                    AFe1fSDK.this.AFInAppEventType.put("install_begin_ts", l2);
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    try {
                                        boolean bl = referrerDetails.getGooglePlayInstantParam();
                                        AFe1fSDK.this.AFInAppEventParameterName.put("instant", bl);
                                        hashMap.put("instant", bl);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        // empty catch block
                                    }
                                    try {
                                        hashMap.put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                                        hashMap.put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                                        hashMap.put("install_version", referrerDetails.getInstallVersion());
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        // empty catch block
                                    }
                                    if (hashMap.isEmpty()) break;
                                    AFe1fSDK.this.AFInAppEventType.put("google_custom", hashMap);
                                    break;
                                }
                                String string3 = "ReferrerClient: InstallReferrer is not ready";
                                AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                                AFe1fSDK.this.AFInAppEventParameterName.put("err", "ReferrerClient: InstallReferrer is not ready");
                            }
                            catch (Throwable throwable) {
                                AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                                AFe1fSDK.this.AFInAppEventParameterName.put("err", throwable.getMessage());
                            }
                            break;
                        }
                        case 2: {
                            AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                            AFe1fSDK.this.AFInAppEventType.put("response", "FEATURE_NOT_SUPPORTED");
                            break;
                        }
                        case 1: {
                            AFe1fSDK.this.AFInAppEventType.put("response", "SERVICE_UNAVAILABLE");
                            AFLogger.afWarnLog("InstallReferrer not supported");
                            break;
                        }
                        case 3: {
                            AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                            AFe1fSDK.this.AFInAppEventType.put("response", "DEVELOPER_ERROR");
                            break;
                        }
                        case -1: {
                            AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                            AFe1fSDK.this.AFInAppEventType.put("response", "SERVICE_DISCONNECTED");
                            break;
                        }
                        default: {
                            AFLogger.afWarnLog("responseCode not found.");
                        }
                    }
                    AFLogger.afDebugLog("Install Referrer collected locally");
                    AFe1fSDK.this.AFKeystoreWrapper();
                    this.val$referrerClient.endConnection();
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }
}

