/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.adobeextension;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.ExtensionError;
import com.adobe.marketing.mobile.ExtensionErrorCallback;
import com.adobe.marketing.mobile.ExtensionUnexpectedError;
import com.adobe.marketing.mobile.Identity;
import com.adobe.marketing.mobile.MobileCore;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.adobeextension.AppsFlyerEventListener;
import com.appsflyer.adobeextension.AppsFlyerExtensionCallbacksListener;
import com.appsflyer.adobeextension.AppsFlyerSharedStateListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AppsFlyerAdobeExtension
extends Extension {
    public static String eventSetting = "";
    static Application af_application;
    static WeakReference<Activity> af_activity;
    private static boolean didReceiveConfigurations;
    private static boolean trackAttributionData;
    private static AppsFlyerExtensionCallbacksListener afCallbackListener;
    private static Map<String, Object> gcd;
    private final Object executorMutex = new Object();
    private boolean sdkStared = false;
    private ExecutorService executor;
    private String ecid;

    public AppsFlyerAdobeExtension(ExtensionApi extensionApi) {
        super(extensionApi);
        ExtensionErrorCallback<ExtensionError> errorCallback = new ExtensionErrorCallback<ExtensionError>(){

            public void error(ExtensionError extensionError) {
                Log.e((String)"AppsFlyerAdobeExtension", (String)("Error registering listener: " + extensionError.getErrorName()));
            }
        };
        this.getApi().registerEventListener("com.adobe.eventType.hub", "com.adobe.eventSource.sharedState", AppsFlyerSharedStateListener.class, (ExtensionErrorCallback)errorCallback);
        this.getApi().registerEventListener("com.adobe.eventType.generic.track", "com.adobe.eventSource.requestContent", AppsFlyerEventListener.class, (ExtensionErrorCallback)errorCallback);
        af_application = MobileCore.getApplication();
        AppsFlyerAdobeExtension.registerCallbacks();
    }

    @Deprecated
    public static void setApplication(Application application) {
        if (application == null) {
            Log.e((String)"AppsFlyerAdobeExtension", (String)"Cannot set null application");
        } else {
            af_application = application;
            AppsFlyerAdobeExtension.registerCallbacks();
        }
    }

    public static void registerExtension() {
        ExtensionErrorCallback<ExtensionError> errorCallback = new ExtensionErrorCallback<ExtensionError>(){

            public void error(ExtensionError extensionError) {
                Log.e((String)"AppsFlyerAdobeExtension", (String)("Error registering extension: " + extensionError.getErrorName()));
            }
        };
        if (!MobileCore.registerExtension(AppsFlyerAdobeExtension.class, (ExtensionErrorCallback)errorCallback)) {
            Log.e((String)"AppsFlyerAdobeExtension", (String)"Failed to registerAppsFlyerAdobeExtensionextension");
        }
    }

    public static void registerCallbacks() {
        Application.ActivityLifecycleCallbacks callbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                af_activity = new WeakReference<Activity>(activity);
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        };
        af_application.registerActivityLifecycleCallbacks(callbacks);
    }

    public static void registerAppsFlyerExtensionCallbacks(AppsFlyerExtensionCallbacksListener callbacksListener) {
        if (callbacksListener != null) {
            afCallbackListener = callbacksListener;
        } else {
            Log.e((String)"AppsFlyerAdobeExtension", (String)"Cannot register callbacks listener with null object");
        }
    }

    private static Map<String, String> convertConversionData(Map<String, Object> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                newMap.put(entry.getKey(), entry.getValue().toString());
                continue;
            }
            newMap.put(entry.getKey(), null);
        }
        return newMap;
    }

    public static Map<String, Object> getConversionData() {
        return gcd;
    }

    public String getName() {
        return "com.appsflyer.adobeextension";
    }

    public void onUnregistered() {
    }

    protected void onUnexpectedError(ExtensionUnexpectedError extensionUnexpectedError) {
        super.onUnexpectedError(extensionUnexpectedError);
    }

    protected String getVersion() {
        return super.getVersion();
    }

    void handleConfigurationEvent(final String appsFlyerDevKey, final boolean appsFlyerIsDebug, final boolean trackAttrData, final String inAppEventSetting, final boolean waitForECID) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (af_application != null && !didReceiveConfigurations) {
                    AppsFlyerLib.getInstance().setDebugLog(appsFlyerIsDebug);
                    AppsFlyerLib.getInstance().init(appsFlyerDevKey, AppsFlyerAdobeExtension.this.getConversionListener(), af_application.getApplicationContext());
                    if (waitForECID) {
                        AppsFlyerAdobeExtension.this.afLogger("waiting for Experience Cloud Id");
                        AppsFlyerLib.getInstance().waitForCustomerUserId(true);
                    }
                    Identity.getExperienceCloudId((AdobeCallback)new AdobeCallback<String>(){

                        public void call(String s) {
                            String id;
                            if (s != null) {
                                AppsFlyerAdobeExtension.this.ecid = s;
                            }
                            String string = id = AppsFlyerAdobeExtension.this.ecid != null ? AppsFlyerAdobeExtension.this.ecid : "";
                            if (waitForECID && AppsFlyerAdobeExtension.this.sdkStared) {
                                Context context = af_activity != null && af_activity.get() != null ? (Context)af_activity.get() : af_application.getApplicationContext();
                                AppsFlyerLib.getInstance().setCustomerIdAndLogSession(id, context);
                            } else {
                                AppsFlyerLib.getInstance().setCustomerUserId(id);
                            }
                        }
                    });
                    AppsFlyerAdobeExtension.this.startSDK();
                    trackAttributionData = trackAttrData;
                    eventSetting = inAppEventSetting;
                    didReceiveConfigurations = true;
                } else if (af_application == null) {
                    Log.e((String)"AppsFlyerAdobeExtension", (String)"Null application context error");
                }
            }
        });
    }

    private void startSDK() {
        if (this.sdkStared) {
            return;
        }
        if (af_activity != null && af_activity.get() != null) {
            this.afLogger("start with Activity context");
            AppsFlyerLib.getInstance().start((Context)af_activity.get());
            this.sdkStared = true;
        } else if (af_application != null) {
            this.afLogger("start with Application context");
            AppsFlyerLib.getInstance().start(af_application.getApplicationContext());
            this.sdkStared = true;
        } else {
            this.afLogger("no context to start the SDK");
        }
    }

    private AppsFlyerConversionListener getConversionListener() {
        return new AppsFlyerConversionListener(){

            public void onConversionDataSuccess(Map<String, Object> conversionData) {
                AppsFlyerAdobeExtension.this.afLogger("called onConversionDataSuccess");
                conversionData.put("callback_type", "onConversionDataReceived");
                if (trackAttributionData) {
                    boolean isFirstLaunch = (Boolean)conversionData.get("is_first_launch");
                    if (isFirstLaunch) {
                        AppsFlyerAdobeExtension.this.getApi().setSharedEventState(AppsFlyerAdobeExtension.this.getSaredEventState(conversionData), null, null);
                        if (af_application != null) {
                            conversionData.put("appsflyer_id", AppsFlyerLib.getInstance().getAppsFlyerUID(af_application.getApplicationContext()));
                        }
                        if (AppsFlyerAdobeExtension.this.ecid != null) {
                            conversionData.put("ecid", AppsFlyerAdobeExtension.this.ecid);
                        }
                        MobileCore.trackAction((String)"AppsFlyer Attribution Data", (Map)AppsFlyerAdobeExtension.this.setKeyPrefix(conversionData));
                    } else {
                        Log.d((String)"AppsFlyerAdobeExtension", (String)"Skipping attribution data reporting, not first launch");
                    }
                }
                if (afCallbackListener != null) {
                    afCallbackListener.onCallbackReceived(AppsFlyerAdobeExtension.convertConversionData(conversionData));
                }
                gcd = conversionData;
            }

            public void onConversionDataFail(String errorMessage) {
                AppsFlyerAdobeExtension.this.afLogger("called onConversionDataFail");
                if (afCallbackListener != null) {
                    afCallbackListener.onCallbackError(errorMessage);
                }
            }

            public void onAppOpenAttribution(Map<String, String> deepLinkData) {
                AppsFlyerAdobeExtension.this.afLogger("called onAppOpenAttribution");
                deepLinkData.put("callback_type", "onAppOpenAttribution");
                if (AppsFlyerAdobeExtension.this.ecid != null) {
                    deepLinkData.put("ecid", AppsFlyerAdobeExtension.this.ecid);
                }
                MobileCore.trackAction((String)"AppsFlyer Engagement Data", (Map)AppsFlyerAdobeExtension.this.setKeyPrefixOnAppOpenAttribution(deepLinkData));
                if (afCallbackListener != null) {
                    afCallbackListener.onCallbackReceived(deepLinkData);
                }
            }

            public void onAttributionFailure(String errorMessage) {
                AppsFlyerAdobeExtension.this.afLogger("called onAttributionFailure");
                if (afCallbackListener != null) {
                    afCallbackListener.onCallbackError(errorMessage);
                }
            }
        };
    }

    private Map<String, String> setKeyPrefix(Map<String, Object> attributionParams) {
        HashMap<String, String> newConversionMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : attributionParams.entrySet()) {
            String newKey;
            if (entry.getKey().equals("callback_type")) continue;
            if (entry.getValue() != null) {
                newKey = "appsflyer." + entry.getKey();
                newConversionMap.put(newKey, entry.getValue().toString());
                continue;
            }
            newKey = "appsflyer." + entry.getKey();
            newConversionMap.put(newKey, null);
        }
        return newConversionMap;
    }

    private Map<String, String> setKeyPrefixOnAppOpenAttribution(Map<String, String> attributionParams) {
        HashMap<String, String> newConversionMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributionParams.entrySet()) {
            if (entry.getKey().equals("callback_type")) continue;
            String newKey = "appsflyer.af_engagement_" + entry.getKey();
            newConversionMap.put(newKey, entry.getValue());
        }
        return newConversionMap;
    }

    private Map<String, Object> getSaredEventState(Map<String, Object> conversionData) {
        HashMap<String, Object> sharedEventState = new HashMap<String, Object>(conversionData);
        sharedEventState.put("appsflyer_id", AppsFlyerLib.getInstance().getAppsFlyerUID((Context)af_application));
        sharedEventState.put("sdk_version", AppsFlyerLib.getInstance().getSdkVersion());
        if (!conversionData.containsKey("media_source")) {
            sharedEventState.put("media_source", "organic");
        }
        sharedEventState.remove("is_first_launch");
        sharedEventState.remove("callback_type");
        return sharedEventState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutor() {
        Object object = this.executorMutex;
        synchronized (object) {
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadExecutor();
            }
            return this.executor;
        }
    }

    private void afLogger(String msg) {
        Log.d((String)"AppsFlyer_adobe_ext", (String)msg);
    }

    static {
        trackAttributionData = false;
        afCallbackListener = null;
    }
}

