/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.adobeextension;

import android.content.Context;
import android.util.Log;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.ExtensionListener;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.adobeextension.AppsFlyerAdobeExtension;
import java.util.HashMap;
import java.util.Map;

public class AppsFlyerEventListener
extends ExtensionListener {
    private static final String ACTION = "action";
    private static final String STATE = "state";
    private static final String TRACK_ALL_EVENTS = "all";
    private static final String TRACK_ACTION_EVENTS = "actions";
    private static final String TRACK_STATE_EVENTS = "states";
    private static final String TRACK_NO_EVENTS = "none";

    protected AppsFlyerEventListener(ExtensionApi extension, String type, String source) {
        super(extension, type, source);
    }

    public void hear(Event event) {
        boolean trackStateEvent;
        boolean trackActionEvent = AppsFlyerAdobeExtension.eventSetting.equals(TRACK_ALL_EVENTS) || AppsFlyerAdobeExtension.eventSetting.equals(TRACK_ACTION_EVENTS);
        boolean bl = trackStateEvent = AppsFlyerAdobeExtension.eventSetting.equals(TRACK_ALL_EVENTS) || AppsFlyerAdobeExtension.eventSetting.equals(TRACK_STATE_EVENTS);
        if (AppsFlyerAdobeExtension.eventSetting.equals(TRACK_NO_EVENTS)) {
            return;
        }
        if (event.getType().equals("com.adobe.eventtype.generic.track") && event.getSource().equals("com.adobe.eventsource.requestcontent")) {
            boolean is_state_event;
            Map eventData = event.getEventData();
            Object nestedData = eventData.get("contextdata");
            Object actionEventName = eventData.get(ACTION);
            Object stateEventName = eventData.get(STATE);
            boolean is_action_event = actionEventName != null;
            boolean bl2 = is_state_event = stateEventName != null;
            if (trackActionEvent && is_action_event) {
                if (actionEventName.equals("AppsFlyer Attribution Data") || actionEventName.equals("AppsFlyer Engagement Data")) {
                    Log.d((String)"AppsFlyerAdobeExtension", (String)"Discarding event binding for AppsFlyer Attribution Data event");
                    return;
                }
                if (AppsFlyerAdobeExtension.af_application != null) {
                    AppsFlyerLib.getInstance().logEvent((Context)AppsFlyerAdobeExtension.af_application, actionEventName.toString(), AppsFlyerEventListener.getAppsFlyerEventMap(nestedData));
                } else {
                    Log.e((String)"AppsFlyerAdobeExtension", (String)"Application is null, please set Application using AppsFlyerAdobeExtension.setApplication(this);");
                }
            } else if (trackStateEvent && is_state_event) {
                AppsFlyerLib.getInstance().logEvent((Context)AppsFlyerAdobeExtension.af_application, stateEventName.toString(), AppsFlyerEventListener.getAppsFlyerEventMap(nestedData));
            }
        }
    }

    private static Map<String, Object> getAppsFlyerEventMap(Object nestedData) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (nestedData != null) {
            try {
                map = (Map)nestedData;
                String revenue = (String)map.get("revenue");
                if (revenue != null) {
                    map.put("af_revenue", revenue);
                    String currency = (String)map.get("currency");
                    if (currency != null) {
                        map.put("af_currency", currency);
                    }
                }
            }
            catch (Exception ex) {
                Log.e((String)"AppsFlyerAdobeExtension", (String)("Error casting contextdata: " + ex.toString()));
            }
        }
        return map;
    }
}

