/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.adobeextension;

import android.util.Log;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.ExtensionError;
import com.adobe.marketing.mobile.ExtensionErrorCallback;
import com.adobe.marketing.mobile.ExtensionListener;
import com.appsflyer.adobeextension.AppsFlyerAdobeExtension;
import java.util.Map;

public class AppsFlyerSharedStateListener
extends ExtensionListener {
    public AppsFlyerSharedStateListener(ExtensionApi extension, String type, String source) {
        super(extension, source, type);
    }

    public void hear(Event event) {
        ExtensionErrorCallback<ExtensionError> errorCallback = new ExtensionErrorCallback<ExtensionError>(){

            public void error(ExtensionError extensionError) {
                Log.e((String)"AppsFlyerAdobeExtension", (String)("error receiving sharedState event: " + extensionError.getErrorName()));
            }
        };
        Map eventData = event.getEventData();
        String stateOwner = (String)eventData.get("stateowner");
        if ("com.adobe.module.configuration".equals(stateOwner)) {
            Map configurationSharedState = this.getParentExtension().getApi().getSharedEventState("com.adobe.module.configuration", event, (ExtensionErrorCallback)errorCallback);
            try {
                if (configurationSharedState != null) {
                    if (!configurationSharedState.isEmpty() && configurationSharedState.get("appsFlyerDevKey") != null) {
                        String appsFlyerDevKey = configurationSharedState.get("appsFlyerDevKey").toString();
                        String inAppEventSetting = null;
                        boolean isDebug = false;
                        boolean shouldTrackAttr = false;
                        boolean waitForECID = false;
                        if (configurationSharedState.get("appsFlyerIsDebug") != null) {
                            isDebug = (Boolean)configurationSharedState.get("appsFlyerIsDebug");
                        }
                        if (configurationSharedState.get("appsFlyerTrackAttrData") != null) {
                            shouldTrackAttr = (Boolean)configurationSharedState.get("appsFlyerTrackAttrData");
                        }
                        if (configurationSharedState.get("appsFlyerWaitForECID") != null) {
                            waitForECID = (Boolean)configurationSharedState.get("appsFlyerWaitForECID");
                        }
                        if (configurationSharedState.get("inAppEventSetting") != null) {
                            inAppEventSetting = configurationSharedState.get("inAppEventSetting").toString();
                        }
                        this.getParentExtension().handleConfigurationEvent(appsFlyerDevKey, isDebug, shouldTrackAttr, inAppEventSetting, waitForECID);
                    } else {
                        Log.e((String)"AppsFlyerAdobeExtension", (String)"Cannot initialize AppsFlyer tracking without a valid DevKey");
                    }
                } else {
                    Log.e((String)"AppsFlyerAdobeExtension", (String)"Cannot initialize Appsflyer tracking: null configuration json");
                }
            }
            catch (NullPointerException npx) {
                Log.e((String)"AppsFlyerAdobeExtension", (String)("Exception while casting devKey to String: " + npx));
            }
        }
    }

    protected AppsFlyerAdobeExtension getParentExtension() {
        return (AppsFlyerAdobeExtension)super.getParentExtension();
    }

    public void onUnregistered() {
        super.onUnregistered();
    }
}

