/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.lvl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.vending.licensing.ILicenseResultListener;
import com.android.vending.licensing.ILicensingService;
import com.appsflyer.lvl.AppsFlyerLVL;

public class AppsFlyerLVLImpl
implements ServiceConnection {
    private final String packageName;
    private final long afNounce;
    private ILicensingService lvlService;
    private AppsFlyerLVL.resultListener resultListener;
    private Context ctx;

    AppsFlyerLVLImpl(long afNounce, Context context, AppsFlyerLVL.resultListener listener) {
        this.ctx = context;
        this.packageName = this.ctx.getPackageName();
        this.afNounce = afNounce;
        this.resultListener = listener;
    }

    void getLVLResult() {
        if (this.lvlService == null) {
            try {
                boolean didBind = this.ctx.bindService(new Intent("com.android.vending.licensing.ILicensingService").setPackage("com.android.vending"), (ServiceConnection)this, 1);
                if (!didBind) {
                    this.resultListener.onLvlFailure(new Exception("LVLException: could not bind service"));
                }
            }
            catch (SecurityException ex) {
                this.resultListener.onLvlFailure(ex);
            }
        } else {
            try {
                this.lvlService.checkLicense(this.afNounce, this.packageName, new ResultListener());
            }
            catch (RemoteException ex) {
                this.resultListener.onLvlFailure((Exception)((Object)ex));
            }
        }
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.lvlService = ILicensingService.Stub.asInterface(service);
        try {
            this.lvlService.checkLicense(this.afNounce, this.packageName, new ResultListener());
        }
        catch (RemoteException ex) {
            this.resultListener.onLvlFailure((Exception)((Object)ex));
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.lvlService = null;
    }

    private class ResultListener
    extends ILicenseResultListener.Stub {
        private ResultListener() {
        }

        @Override
        public void verifyLicense(int responseCode, String signedData, String signature) {
            AppsFlyerLVLImpl.this.resultListener.onLvlResult(signedData, signature);
        }
    }
}

