package com.appsflyer.migration

import androidx.annotation.VisibleForTesting
import com.appsflyer.migration.internal.MigrationDelegate
import org.json.JSONObject

/**
 * A utility class designed to help with migration from other Mobile Measurement Partners (MMPs) to the AppsFlyer SDK.
 * This class allows collecting attribution and deep linking data from other SDKs and provides it internally to the AppsFlyer SDK,
 * enabling seamless integration and usage of data collected via other MMPs.
 *
 * This artifact is particularly useful for customers transitioning from other MMPs, ensuring no data loss
 * during the migration process and maintaining compatibility with deep links from those MMPs.
 *
 * Created by Taras Lozovyi on 07.01.2025
 */
object AppsFlyerMigrationHelper {
    /**
     * Internal delegate for managing migration operations.
     */
    @VisibleForTesting
    internal var delegate: MigrationDelegate = MigrationDelegate()

    /**
     * Provides attribution data to the AppsFlyer SDK.
     *
     * @param attributionData A JSON object containing attribution data collected from other SDKs.
     * If `null`, the AppsFlyer SDK will be notified that no attribution data is available in the current session.
     */
    @JvmStatic
    fun setAttributionData(attributionData: JSONObject?) {
        delegate.setAttributionData(attributionData)
    }

    /**
     * Provides deep linking data to the AppsFlyer SDK.
     *
     * @param deepLinkingData A JSON object containing deep linking data collected from other SDKs.
     * If `null`, the AppsFlyer SDK will be notified that no deep linking data is available in the current session.
     */
    @JvmStatic
    fun setDeepLinkingData(deepLinkingData: JSONObject?) {
        delegate.setDeepLinkingData(deepLinkingData)
    }
}
