/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.oaid;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.bun.miitmdid.core.JLibrary;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.supplier.IIdentifierListener;
import com.bun.supplier.IdSupplier;
import com.huawei.hms.ads.identifier.AdvertisingIdClient;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OaidClient {
    private final Logger logger = Logger.getLogger("AppsFlyerOaid5.4.0");
    private final Context context;
    private final long timeout;
    private final TimeUnit unit;

    public OaidClient(Context context, long timeout, TimeUnit unit) {
        this.context = context;
        this.timeout = timeout;
        this.unit = unit;
        this.logger.setLevel(Level.OFF);
    }

    public OaidClient(Context context) {
        this(context, 1L, TimeUnit.SECONDS);
    }

    private static boolean isHuawei() {
        try {
            return Build.BRAND.equalsIgnoreCase("huawei") || (Integer)Class.forName("com.huawei.android.os.BuildEx$VERSION").getDeclaredField("EMUI_SDK_INT").get(null) > 0;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (NoSuchFieldException ignored) {
            return false;
        }
        catch (IllegalAccessException ignored) {
            return false;
        }
    }

    @Nullable
    public Info fetch() {
        try {
            long current = System.currentTimeMillis();
            Info info = OaidClient.isHuawei() ? this.fetchHuawei() : this.fetchMsa();
            this.logger.info("Fetch " + (System.currentTimeMillis() - current) + " ms");
            return info;
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, "Fetch", t);
            return null;
        }
    }

    @Nullable
    private Info fetchMsa() throws Exception {
        String oaid;
        final LinkedBlockingQueue oaidHolder = new LinkedBlockingQueue();
        JLibrary.InitEntry((Context)this.context);
        int result = MdidSdkHelper.InitSdk((Context)this.context, (this.logger.getLevel() == null ? 1 : 0) != 0, (IIdentifierListener)new IIdentifierListener(){

            public void OnSupport(boolean support, IdSupplier supplier) {
                try {
                    oaidHolder.offer(supplier == null ? "" : supplier.getOAID());
                }
                catch (Throwable t) {
                    OaidClient.this.logger.log(Level.INFO, "IIdentifierListener", t);
                }
            }
        });
        if (result != 0) {
            String error;
            switch (result) {
                case 1008612: {
                    error = "Unsupported device";
                    break;
                }
                case 1008613: {
                    error = "Error loading configuration file";
                    break;
                }
                case 1008611: {
                    error = "Unsupported manufacturer";
                    break;
                }
                case 1008614: {
                    error = "Callback will be executed in a different thread";
                    break;
                }
                case 1008615: {
                    error = "Reflection call error";
                    break;
                }
                default: {
                    error = String.valueOf(result);
                }
            }
            this.logger.warning(error);
        }
        return TextUtils.isEmpty((CharSequence)(oaid = (String)oaidHolder.poll(this.timeout, this.unit))) ? null : new Info(oaid);
    }

    @Nullable
    private Info fetchHuawei() {
        try {
            if (AdvertisingIdClient.isAdvertisingIdAvailable((Context)this.context)) {
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
                return new Info(info.getId(), info.isLimitAdTrackingEnabled());
            }
            return null;
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, "Huawei", t);
            return null;
        }
    }

    public void setLogging(boolean logging) {
        this.logger.setLevel(logging ? null : Level.OFF);
    }

    public static class Info {
        private final Boolean lat;
        private final String id;

        @VisibleForTesting
        public Info(String id, Boolean lat) {
            this.id = id;
            this.lat = lat;
        }

        @VisibleForTesting
        public Info(String id) {
            this(id, null);
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public Boolean getLat() {
            return this.lat;
        }
    }
}

