/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.unity;

import android.content.Context;
import androidx.annotation.NonNull;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.attribution.AppsFlyerRequestListener;
import com.appsflyer.deeplink.DeepLinkListener;
import com.appsflyer.deeplink.DeepLinkResult;
import com.appsflyer.internal.platform_extension.Plugin;
import com.appsflyer.internal.platform_extension.PluginInfo;
import com.appsflyer.share.CrossPromotionHelper;
import com.appsflyer.share.LinkGenerator;
import com.appsflyer.share.ShareInviteHelper;
import com.unity3d.player.UnityPlayer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AppsFlyerAndroidWrapper {
    private static final String VALIDATE_CALLBACK = "didFinishValidateReceipt";
    private static final String VALIDATE_ERROR_CALLBACK = "didFinishValidateReceiptWithError";
    private static final String GCD_CALLBACK = "onConversionDataSuccess";
    private static final String GCD_ERROR_CALLBACK = "onConversionDataFail";
    private static final String OAOA_CALLBACK = "onAppOpenAttribution";
    private static final String OAOA_ERROR_CALLBACK = "onAppOpenAttributionFailure";
    private static final String GENERATE_LINK_CALLBACK = "onInviteLinkGenerated";
    private static final String GENERATE_LINK_ERROR_CALLBACK = "onInviteLinkGeneratedFailure";
    private static final String ON_DEEPLINKING = "onDeepLinking";
    private static final String START_REQUEST_CALLBACK = "requestResponseReceived";
    private static final String IN_APP_RESPONSE_CALLBACK = "inAppResponseReceived";
    private static final String PLUGIN_VERSION = "6.12.21";
    private static AppsFlyerConversionListener conversionListener;
    private static String devkey;

    public static void initSDK(String devKey, String objectName) {
        if (conversionListener == null && objectName != null) {
            conversionListener = AppsFlyerAndroidWrapper.getConversionListener(objectName);
        }
        devkey = devKey;
        AppsFlyerAndroidWrapper.setPluginInfo();
        AppsFlyerLib.getInstance().init(devKey, conversionListener, (Context)UnityPlayer.currentActivity);
    }

    public static void startTracking(final boolean shouldCallback, final String objectName) {
        AppsFlyerLib.getInstance().start((Context)UnityPlayer.currentActivity, devkey, new AppsFlyerRequestListener(){

            public void onSuccess() {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("statusCode", 200);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.START_REQUEST_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onError(int i, @NonNull String s) {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("statusCode", i);
                    map.put("errorDescription", s);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.START_REQUEST_CALLBACK, (String)jsonObject.toString());
                }
            }
        });
    }

    public static void startTracking() {
        AppsFlyerAndroidWrapper.startTracking(false, null);
    }

    public static void stopTracking(boolean isTrackingStopped) {
        AppsFlyerLib.getInstance().stop(isTrackingStopped, (Context)UnityPlayer.currentActivity);
    }

    public static String getSdkVersion() {
        return AppsFlyerLib.getInstance().getSdkVersion();
    }

    public static void updateServerUninstallToken(String token) {
        AppsFlyerLib.getInstance().updateServerUninstallToken((Context)UnityPlayer.currentActivity, token);
    }

    public static void setIsDebug(boolean shouldEnable) {
        AppsFlyerLib.getInstance().setDebugLog(shouldEnable);
    }

    public static void setImeiData(String aImei) {
        AppsFlyerLib.getInstance().setImeiData(aImei);
    }

    public static void setAndroidIdData(String aAndroidId) {
        AppsFlyerLib.getInstance().setAndroidIdData(aAndroidId);
    }

    public static void setCustomerUserId(String id) {
        AppsFlyerLib.getInstance().setCustomerUserId(id);
    }

    public static void waitForCustomerUserId(boolean wait) {
        AppsFlyerLib.getInstance().waitForCustomerUserId(true);
    }

    public static void setCustomerIdAndTrack(String id) {
        AppsFlyerLib.getInstance().setCustomerIdAndLogSession(id, (Context)UnityPlayer.currentActivity);
    }

    public static String getOutOfStore() {
        return AppsFlyerLib.getInstance().getOutOfStore((Context)UnityPlayer.currentActivity);
    }

    public static void setOutOfStore(String sourceName) {
        AppsFlyerLib.getInstance().setOutOfStore(sourceName);
    }

    public static void setAppInviteOneLinkID(String oneLinkId) {
        AppsFlyerLib.getInstance().setAppInviteOneLink(oneLinkId);
    }

    public static void setAdditionalData(HashMap<String, Object> customData) {
        AppsFlyerLib.getInstance().setAdditionalData(customData);
    }

    public static void setUserEmails(String ... emails) {
        AppsFlyerLib.getInstance().setUserEmails(emails);
    }

    public static void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String ... emails) {
        AppsFlyerLib.getInstance().setUserEmails(cryptMethod, emails);
    }

    public static void setCollectAndroidID(boolean isCollect) {
        AppsFlyerLib.getInstance().setCollectAndroidID(isCollect);
    }

    public static void setCollectIMEI(boolean isCollect) {
        AppsFlyerLib.getInstance().setCollectIMEI(isCollect);
    }

    public static void setResolveDeepLinkURLs(String ... urls) {
        AppsFlyerLib.getInstance().setResolveDeepLinkURLs(urls);
    }

    public static void setOneLinkCustomDomain(String ... domains) {
        AppsFlyerLib.getInstance().setOneLinkCustomDomain(domains);
    }

    public static void setIsUpdate(boolean isUpdate) {
        AppsFlyerLib.getInstance().setIsUpdate(isUpdate);
    }

    public static void setCurrencyCode(String currencyCode) {
        AppsFlyerLib.getInstance().setCurrencyCode(currencyCode);
    }

    public static void trackLocation(double latitude, double longitude) {
        AppsFlyerLib.getInstance().logLocation((Context)UnityPlayer.currentActivity, latitude, longitude);
    }

    public static void trackEvent(String eventName, HashMap<String, Object> eventValues, final boolean shouldCallback, final String objectName) {
        AppsFlyerLib.getInstance().logEvent((Context)UnityPlayer.currentActivity, eventName, eventValues, new AppsFlyerRequestListener(){

            public void onSuccess() {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("statusCode", 200);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.IN_APP_RESPONSE_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onError(int i, @NonNull String s) {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("statusCode", i);
                    map.put("errorDescription", s);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.IN_APP_RESPONSE_CALLBACK, (String)jsonObject.toString());
                }
            }
        });
    }

    public static void trackEvent(String eventName, HashMap<String, Object> eventValues) {
        AppsFlyerAndroidWrapper.trackEvent(eventName, eventValues, false, null);
    }

    public static void setDeviceTrackingDisabled(boolean isDisabled) {
        AppsFlyerLib.getInstance().anonymizeUser(isDisabled);
    }

    public static void enableFacebookDeferredApplinks(boolean isEnabled) {
        AppsFlyerLib.getInstance().enableFacebookDeferredApplinks(isEnabled);
    }

    public static void setConsumeAFDeepLinks(boolean doConsume) {
    }

    public static void setPreinstallAttribution(String mediaSource, String campaign, String siteId) {
        AppsFlyerLib.getInstance().setPreinstallAttribution(mediaSource, campaign, siteId);
    }

    public static boolean isPreInstalledApp() {
        return AppsFlyerLib.getInstance().isPreInstalledApp((Context)UnityPlayer.currentActivity);
    }

    public static String getAttributionId() {
        return AppsFlyerLib.getInstance().getAttributionId((Context)UnityPlayer.currentActivity);
    }

    public static String getAppsFlyerId() {
        return AppsFlyerLib.getInstance().getAppsFlyerUID((Context)UnityPlayer.currentActivity);
    }

    public static void validateAndTrackInAppPurchase(String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters, String objectName) {
        AppsFlyerLib.getInstance().validateAndLogInAppPurchase((Context)UnityPlayer.currentActivity, publicKey, signature, purchaseData, price, currency, additionalParameters);
        if (objectName != null) {
            AppsFlyerAndroidWrapper.initInAppPurchaseValidatorListener(objectName);
        }
    }

    public static boolean isTrackingStopped() {
        return AppsFlyerLib.getInstance().isStopped();
    }

    public static void setMinTimeBetweenSessions(int seconds) {
        AppsFlyerLib.getInstance().setMinTimeBetweenSessions(seconds);
    }

    public static void setLogLevel(AFLogger.LogLevel logLevel) {
        AppsFlyerLib.getInstance().setLogLevel(logLevel);
    }

    public static void setHost(String hostPrefixName, String hostName) {
        AppsFlyerLib.getInstance().setHost(hostPrefixName, hostName);
    }

    public static String getHostName() {
        return AppsFlyerLib.getInstance().getHostName();
    }

    public static String getHostPrefix() {
        return AppsFlyerLib.getInstance().getHostPrefix();
    }

    public static void setCollectOaid(boolean isCollect) {
        AppsFlyerLib.getInstance().setCollectOaid(isCollect);
    }

    public static void setSharingFilterForAllPartners() {
        AppsFlyerLib.getInstance().setSharingFilterForAllPartners();
    }

    public static void setSharingFilter(String ... partners) {
        AppsFlyerLib.getInstance().setSharingFilter(partners);
    }

    public static void getConversionData(String objectName) {
        if (conversionListener == null) {
            conversionListener = AppsFlyerAndroidWrapper.getConversionListener(objectName);
        }
        AppsFlyerLib.getInstance().registerConversionListener((Context)UnityPlayer.currentActivity, conversionListener);
    }

    private static AppsFlyerConversionListener getConversionListener(final String objectName) {
        return new AppsFlyerConversionListener(){

            public void onConversionDataSuccess(Map<String, Object> map) {
                if (objectName != null) {
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GCD_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onConversionDataFail(String s) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GCD_ERROR_CALLBACK, (String)s);
                }
            }

            public void onAppOpenAttribution(Map<String, String> map) {
                if (objectName != null) {
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.OAOA_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onAttributionFailure(String s) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.OAOA_ERROR_CALLBACK, (String)s);
                }
            }
        };
    }

    public static void initInAppPurchaseValidatorListener(final String objectName) {
        AppsFlyerLib.getInstance().registerValidatorListener((Context)UnityPlayer.currentActivity, new AppsFlyerInAppPurchaseValidatorListener(){

            public void onValidateInApp() {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.VALIDATE_CALLBACK, (String)"Validate success");
                }
            }

            public void onValidateInAppFailure(String error) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.VALIDATE_ERROR_CALLBACK, (String)error);
                }
            }
        });
    }

    public static void handlePushNotifications() {
        AppsFlyerLib.getInstance().sendPushNotificationData(UnityPlayer.currentActivity);
    }

    public static void setPhoneNumber(String phoneNumber) {
        AppsFlyerLib.getInstance().setPhoneNumber(phoneNumber);
    }

    public static void attributeAndOpenStore(String promoted_app_id, String campaign, Map<String, String> userParams) {
        CrossPromotionHelper.logAndOpenStore((Context)UnityPlayer.currentActivity, (String)promoted_app_id, (String)campaign, userParams);
    }

    public static void recordCrossPromoteImpression(String appID, String campaign, Map<String, String> params) {
        CrossPromotionHelper.logCrossPromoteImpression((Context)UnityPlayer.currentActivity, (String)appID, (String)campaign, params);
    }

    public static void createOneLinkInviteListener(Map<String, String> params, final String objectName) {
        LinkGenerator linkGenerator = ShareInviteHelper.generateInviteUrl((Context)UnityPlayer.currentActivity);
        linkGenerator.setChannel(params.get("channel"));
        linkGenerator.setCampaign(params.get("campaign"));
        linkGenerator.setReferrerName(params.get("referrerName"));
        linkGenerator.setReferrerImageURL(params.get("referrerImageUrl"));
        linkGenerator.setReferrerCustomerId(params.get("customerID"));
        linkGenerator.setBaseDeeplink(params.get("baseDeepLink"));
        linkGenerator.setBrandDomain(params.get("brandDomain"));
        params.remove("channel");
        params.remove("campaign");
        params.remove("referrerName");
        params.remove("referrerImageUrl");
        params.remove("customerID");
        params.remove("baseDeepLink");
        params.remove("brandDomain");
        linkGenerator.addParameters(params);
        linkGenerator.generateLink((Context)UnityPlayer.currentActivity, new LinkGenerator.ResponseListener(){

            public void onResponse(String link) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GENERATE_LINK_CALLBACK, (String)link);
                }
            }

            public void onResponseError(String error) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GENERATE_LINK_ERROR_CALLBACK, (String)error);
                }
            }
        });
    }

    public static void subscribeForDeepLink(final String objectName) {
        AppsFlyerLib.getInstance().subscribeForDeepLink(new DeepLinkListener(){

            public void onDeepLinking(@NonNull DeepLinkResult deepLinkResult) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.ON_DEEPLINKING, (String)deepLinkResult.toString());
                }
            }
        });
    }

    public static void addPushNotificationDeepLinkPath(String ... path) {
        AppsFlyerLib.getInstance().addPushNotificationDeepLinkPath(path);
    }

    public static void setDisableAdvertisingIdentifiers(boolean disable) {
        AppsFlyerLib.getInstance().setDisableAdvertisingIdentifiers(disable);
    }

    public static void setSharingFilterForPartners(String ... partners) {
        AppsFlyerLib.getInstance().setSharingFilterForPartners(partners);
    }

    public static void setDisableNetworkData(boolean disable) {
        AppsFlyerLib.getInstance().setDisableNetworkData(disable);
    }

    public static void setPluginInfo() {
        PluginInfo pluginInfo = new PluginInfo(Plugin.UNITY, PLUGIN_VERSION);
        AppsFlyerLib.getInstance().setPluginInfo(pluginInfo);
    }

    static {
        devkey = "";
    }
}

