/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.unity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.appsflyer.AFAdRevenueData;
import com.appsflyer.AFLogger;
import com.appsflyer.AFPurchaseDetails;
import com.appsflyer.AFPurchaseType;
import com.appsflyer.AppsFlyerConsent;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidationCallback;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.MediationNetwork;
import com.appsflyer.api.PurchaseClient;
import com.appsflyer.api.Store;
import com.appsflyer.attribution.AppsFlyerRequestListener;
import com.appsflyer.deeplink.DeepLinkListener;
import com.appsflyer.deeplink.DeepLinkResult;
import com.appsflyer.internal.models.InAppPurchaseValidationResult;
import com.appsflyer.internal.models.ProductPurchase;
import com.appsflyer.internal.models.SubscriptionPurchase;
import com.appsflyer.internal.models.SubscriptionPurchaseLineItem;
import com.appsflyer.internal.models.SubscriptionValidationResult;
import com.appsflyer.internal.models.ValidationFailureData;
import com.appsflyer.internal.platform_extension.Plugin;
import com.appsflyer.internal.platform_extension.PluginInfo;
import com.appsflyer.share.CrossPromotionHelper;
import com.appsflyer.share.LinkGenerator;
import com.appsflyer.share.ShareInviteHelper;
import com.appsflyer.unity.PurchaseRevenueBridge;
import com.unity3d.player.UnityPlayer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AppsFlyerAndroidWrapper {
    private static final String VALIDATE_CALLBACK = "didFinishValidateReceipt";
    private static final String VALIDATE_ERROR_CALLBACK = "didFinishValidateReceiptWithError";
    private static final String VALIDATE_AND_LOG_V2_CALLBACK = "onValidateAndLogComplete";
    private static final String VALIDATE_AND_LOG_V2__ERROR_CALLBACK = "onValidateAndLogFailure";
    private static final String GCD_CALLBACK = "onConversionDataSuccess";
    private static final String GCD_ERROR_CALLBACK = "onConversionDataFail";
    private static final String OAOA_CALLBACK = "onAppOpenAttribution";
    private static final String OAOA_ERROR_CALLBACK = "onAppOpenAttributionFailure";
    private static final String GENERATE_LINK_CALLBACK = "onInviteLinkGenerated";
    private static final String GENERATE_LINK_ERROR_CALLBACK = "onInviteLinkGeneratedFailure";
    private static final String ON_DEEPLINKING = "onDeepLinking";
    private static final String START_REQUEST_CALLBACK = "requestResponseReceived";
    private static final String IN_APP_RESPONSE_CALLBACK = "inAppResponseReceived";
    private static final String VALIDATION_CALLBACK = "didReceivePurchaseRevenueValidationInfo";
    private static final String ERROR_CALLBACK = "didReceivePurchaseRevenueError";
    private static final String PLUGIN_VERSION = "6.17.72";
    private static final long DDL_TIMEOUT_DEFAULT = 3000L;
    private static AppsFlyerConversionListener conversionListener;
    private static String devkey;
    private static long ddlTimeout;
    private static PurchaseClient purchaseClientInstance;
    private static PurchaseClient.Builder builder;
    private static String unityObjectName;

    public static void initSDK(String devKey, String objectName) {
        if (conversionListener == null && objectName != null) {
            conversionListener = AppsFlyerAndroidWrapper.getConversionListener(objectName);
        }
        devkey = devKey;
        AppsFlyerAndroidWrapper.setPluginInfo();
        AppsFlyerLib.getInstance().init(devKey, conversionListener, (Context)UnityPlayer.currentActivity);
    }

    public static void startTracking(final boolean shouldCallback, final String objectName) {
        AppsFlyerLib.getInstance().start((Context)UnityPlayer.currentActivity, devkey, new AppsFlyerRequestListener(){

            public void onSuccess() {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("statusCode", 200);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.START_REQUEST_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onError(int i, @NonNull String s) {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("statusCode", i);
                    map.put("errorDescription", s);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.START_REQUEST_CALLBACK, (String)jsonObject.toString());
                }
            }
        });
    }

    public static void startTracking() {
        AppsFlyerAndroidWrapper.startTracking(false, null);
    }

    public static void stopTracking(boolean isTrackingStopped) {
        AppsFlyerLib.getInstance().stop(isTrackingStopped, (Context)UnityPlayer.currentActivity);
    }

    public static String getSdkVersion() {
        return AppsFlyerLib.getInstance().getSdkVersion();
    }

    public static void updateServerUninstallToken(String token) {
        AppsFlyerLib.getInstance().updateServerUninstallToken((Context)UnityPlayer.currentActivity, token);
    }

    public static void setIsDebug(boolean shouldEnable) {
        AppsFlyerLib.getInstance().setDebugLog(shouldEnable);
    }

    public static void setImeiData(String aImei) {
        AppsFlyerLib.getInstance().setImeiData(aImei);
    }

    public static void setAndroidIdData(String aAndroidId) {
        AppsFlyerLib.getInstance().setAndroidIdData(aAndroidId);
    }

    public static void setCustomerUserId(String id) {
        AppsFlyerLib.getInstance().setCustomerUserId(id);
    }

    public static void waitForCustomerUserId(boolean wait) {
        AppsFlyerLib.getInstance().waitForCustomerUserId(true);
    }

    public static void setCustomerIdAndTrack(String id) {
        AppsFlyerLib.getInstance().setCustomerIdAndLogSession(id, (Context)UnityPlayer.currentActivity);
    }

    public static void enableTCFDataCollection(boolean shouldCollectTcfData) {
        AppsFlyerLib.getInstance().enableTCFDataCollection(shouldCollectTcfData);
    }

    public static void setConsentData(String isUserSubjectToGDPR, String hasConsentForDataUsage, String hasConsentForAdsPersonalization, String hasConsentForAdStorage) {
        Boolean gdprApplies = AppsFlyerAndroidWrapper.parseNullableBoolean(isUserSubjectToGDPR);
        Boolean dataUsage = AppsFlyerAndroidWrapper.parseNullableBoolean(hasConsentForDataUsage);
        Boolean adsPersonalization = AppsFlyerAndroidWrapper.parseNullableBoolean(hasConsentForAdsPersonalization);
        Boolean adStorage = AppsFlyerAndroidWrapper.parseNullableBoolean(hasConsentForAdStorage);
        AppsFlyerLib.getInstance().setConsentData(new AppsFlyerConsent(gdprApplies, dataUsage, adsPersonalization, adStorage));
    }

    public static void logAdRevenue(String monetizationNetwork, MediationNetwork mediationNetwork, String currencyIso4217Code, double revenue, HashMap<String, Object> additionalParameters) {
        AFAdRevenueData adRevenueData = new AFAdRevenueData(monetizationNetwork, mediationNetwork, currencyIso4217Code, revenue);
        AppsFlyerLib.getInstance().logAdRevenue(adRevenueData, additionalParameters);
    }

    public static String getOutOfStore() {
        return AppsFlyerLib.getInstance().getOutOfStore((Context)UnityPlayer.currentActivity);
    }

    public static void setOutOfStore(String sourceName) {
        AppsFlyerLib.getInstance().setOutOfStore(sourceName);
    }

    public static void setAppInviteOneLinkID(String oneLinkId) {
        AppsFlyerLib.getInstance().setAppInviteOneLink(oneLinkId);
    }

    public static void setAdditionalData(HashMap<String, Object> customData) {
        AppsFlyerLib.getInstance().setAdditionalData(customData);
    }

    public static void setUserEmails(String ... emails) {
        AppsFlyerLib.getInstance().setUserEmails(emails);
    }

    public static void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String ... emails) {
        AppsFlyerLib.getInstance().setUserEmails(cryptMethod, emails);
    }

    public static void setCollectAndroidID(boolean isCollect) {
        AppsFlyerLib.getInstance().setCollectAndroidID(isCollect);
    }

    public static void setCollectIMEI(boolean isCollect) {
        AppsFlyerLib.getInstance().setCollectIMEI(isCollect);
    }

    public static void setResolveDeepLinkURLs(String ... urls) {
        AppsFlyerLib.getInstance().setResolveDeepLinkURLs(urls);
    }

    public static void setOneLinkCustomDomain(String ... domains) {
        AppsFlyerLib.getInstance().setOneLinkCustomDomain(domains);
    }

    public static void setIsUpdate(boolean isUpdate) {
        AppsFlyerLib.getInstance().setIsUpdate(isUpdate);
    }

    public static void setCurrencyCode(String currencyCode) {
        AppsFlyerLib.getInstance().setCurrencyCode(currencyCode);
    }

    public static void trackLocation(double latitude, double longitude) {
        AppsFlyerLib.getInstance().logLocation((Context)UnityPlayer.currentActivity, latitude, longitude);
    }

    public static void trackEvent(String eventName, HashMap<String, Object> eventValues, final boolean shouldCallback, final String objectName) {
        AppsFlyerLib.getInstance().logEvent((Context)UnityPlayer.currentActivity, eventName, eventValues, new AppsFlyerRequestListener(){

            public void onSuccess() {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("statusCode", 200);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.IN_APP_RESPONSE_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onError(int i, @NonNull String s) {
                if (shouldCallback && objectName != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("statusCode", i);
                    map.put("errorDescription", s);
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.IN_APP_RESPONSE_CALLBACK, (String)jsonObject.toString());
                }
            }
        });
    }

    public static void trackEvent(String eventName, HashMap<String, Object> eventValues) {
        AppsFlyerAndroidWrapper.trackEvent(eventName, eventValues, false, null);
    }

    public static void setDeviceTrackingDisabled(boolean isDisabled) {
        AppsFlyerLib.getInstance().anonymizeUser(isDisabled);
    }

    public static void enableFacebookDeferredApplinks(boolean isEnabled) {
        AppsFlyerLib.getInstance().enableFacebookDeferredApplinks(isEnabled);
    }

    public static void setConsumeAFDeepLinks(boolean doConsume) {
    }

    public static void setPreinstallAttribution(String mediaSource, String campaign, String siteId) {
        AppsFlyerLib.getInstance().setPreinstallAttribution(mediaSource, campaign, siteId);
    }

    public static boolean isPreInstalledApp() {
        return AppsFlyerLib.getInstance().isPreInstalledApp((Context)UnityPlayer.currentActivity);
    }

    public static String getAttributionId() {
        return AppsFlyerLib.getInstance().getAttributionId((Context)UnityPlayer.currentActivity);
    }

    public static String getAppsFlyerId() {
        return AppsFlyerLib.getInstance().getAppsFlyerUID((Context)UnityPlayer.currentActivity);
    }

    public static void validateAndTrackInAppPurchase(String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters, String objectName) {
        AppsFlyerLib.getInstance().validateAndLogInAppPurchase((Context)UnityPlayer.currentActivity, publicKey, signature, purchaseData, price, currency, additionalParameters);
        if (objectName != null) {
            AppsFlyerAndroidWrapper.initInAppPurchaseValidatorListener(objectName);
        }
    }

    public static void validateAndTrackInAppPurchaseV2(int purchaseType, String purchaseToken, String productId, HashMap<String, String> purchaseAdditionalDetails, String objectName) {
        AFPurchaseType type = purchaseType == 0 ? AFPurchaseType.SUBSCRIPTION : AFPurchaseType.ONE_TIME_PURCHASE;
        AFPurchaseDetails details = new AFPurchaseDetails(type, purchaseToken, productId);
        if (objectName != null) {
            AppsFlyerInAppPurchaseValidationCallback listener = AppsFlyerAndroidWrapper.initInAppPurchaseValidatorV2Listener(objectName);
            AppsFlyerLib.getInstance().validateAndLogInAppPurchase(details, purchaseAdditionalDetails, listener);
        }
    }

    public static boolean isTrackingStopped() {
        return AppsFlyerLib.getInstance().isStopped();
    }

    public static void setMinTimeBetweenSessions(int seconds) {
        AppsFlyerLib.getInstance().setMinTimeBetweenSessions(seconds);
    }

    public static void setLogLevel(AFLogger.LogLevel logLevel) {
        AppsFlyerLib.getInstance().setLogLevel(logLevel);
    }

    public static void setHost(String hostPrefixName, String hostName) {
        AppsFlyerLib.getInstance().setHost(hostPrefixName, hostName);
    }

    public static String getHostName() {
        return AppsFlyerLib.getInstance().getHostName();
    }

    public static String getHostPrefix() {
        return AppsFlyerLib.getInstance().getHostPrefix();
    }

    public static void setCollectOaid(boolean isCollect) {
        AppsFlyerLib.getInstance().setCollectOaid(isCollect);
    }

    public static void setSharingFilterForAllPartners() {
        AppsFlyerLib.getInstance().setSharingFilterForAllPartners();
    }

    public static void setSharingFilter(String ... partners) {
        AppsFlyerLib.getInstance().setSharingFilter(partners);
    }

    public static void getConversionData(String objectName) {
        if (conversionListener == null) {
            conversionListener = AppsFlyerAndroidWrapper.getConversionListener(objectName);
        }
        AppsFlyerLib.getInstance().registerConversionListener((Context)UnityPlayer.currentActivity, conversionListener);
    }

    private static AppsFlyerConversionListener getConversionListener(final String objectName) {
        return new AppsFlyerConversionListener(){

            public void onConversionDataSuccess(Map<String, Object> map) {
                if (objectName != null) {
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GCD_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onConversionDataFail(String s) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GCD_ERROR_CALLBACK, (String)s);
                }
            }

            public void onAppOpenAttribution(Map<String, String> map) {
                if (objectName != null) {
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.OAOA_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onAttributionFailure(String s) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.OAOA_ERROR_CALLBACK, (String)s);
                }
            }
        };
    }

    private static Boolean parseNullableBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return null;
    }

    public static void initInAppPurchaseValidatorListener(final String objectName) {
        AppsFlyerLib.getInstance().registerValidatorListener((Context)UnityPlayer.currentActivity, new AppsFlyerInAppPurchaseValidatorListener(){

            public void onValidateInApp() {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.VALIDATE_CALLBACK, (String)"Validate success");
                }
            }

            public void onValidateInAppFailure(String error) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.VALIDATE_ERROR_CALLBACK, (String)error);
                }
            }
        });
    }

    public static AppsFlyerInAppPurchaseValidationCallback initInAppPurchaseValidatorV2Listener(final String objectName) {
        return new AppsFlyerInAppPurchaseValidationCallback(){

            public void onInAppPurchaseValidationFinished(@NonNull Map<String, ?> map) {
                if (objectName != null) {
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.VALIDATE_AND_LOG_V2_CALLBACK, (String)jsonObject.toString());
                }
            }

            public void onInAppPurchaseValidationError(@NonNull Map<String, ?> map) {
                if (objectName != null) {
                    JSONObject jsonObject = new JSONObject(map);
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.VALIDATE_AND_LOG_V2__ERROR_CALLBACK, (String)jsonObject.toString());
                }
            }
        };
    }

    public static void handlePushNotifications() {
        AppsFlyerLib.getInstance().sendPushNotificationData(UnityPlayer.currentActivity);
    }

    public static void setPhoneNumber(String phoneNumber) {
        AppsFlyerLib.getInstance().setPhoneNumber(phoneNumber);
    }

    public static void attributeAndOpenStore(String promoted_app_id, String campaign, Map<String, String> userParams) {
        CrossPromotionHelper.logAndOpenStore((Context)UnityPlayer.currentActivity, (String)promoted_app_id, (String)campaign, userParams);
    }

    public static void recordCrossPromoteImpression(String appID, String campaign, Map<String, String> params) {
        CrossPromotionHelper.logCrossPromoteImpression((Context)UnityPlayer.currentActivity, (String)appID, (String)campaign, params);
    }

    public static void createOneLinkInviteListener(Map<String, String> params, final String objectName) {
        LinkGenerator linkGenerator = ShareInviteHelper.generateInviteUrl((Context)UnityPlayer.currentActivity);
        linkGenerator.setChannel(params.get("channel"));
        linkGenerator.setCampaign(params.get("campaign"));
        linkGenerator.setReferrerName(params.get("referrerName"));
        linkGenerator.setReferrerImageURL(params.get("referrerImageUrl"));
        linkGenerator.setReferrerCustomerId(params.get("customerID"));
        linkGenerator.setBaseDeeplink(params.get("baseDeepLink"));
        linkGenerator.setBrandDomain(params.get("brandDomain"));
        params.remove("channel");
        params.remove("campaign");
        params.remove("referrerName");
        params.remove("referrerImageUrl");
        params.remove("customerID");
        params.remove("baseDeepLink");
        params.remove("brandDomain");
        linkGenerator.addParameters(params);
        linkGenerator.generateLink((Context)UnityPlayer.currentActivity, new LinkGenerator.ResponseListener(){

            public void onResponse(String link) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GENERATE_LINK_CALLBACK, (String)link);
                }
            }

            public void onResponseError(String error) {
                if (objectName != null) {
                    UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.GENERATE_LINK_ERROR_CALLBACK, (String)error);
                }
            }
        });
    }

    public static void subscribeForDeepLink(final String objectName) {
        if (ddlTimeout != 3000L) {
            AppsFlyerLib.getInstance().subscribeForDeepLink(new DeepLinkListener(){

                public void onDeepLinking(@NonNull DeepLinkResult deepLinkResult) {
                    if (objectName != null) {
                        UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.ON_DEEPLINKING, (String)deepLinkResult.toString());
                    }
                }
            }, ddlTimeout);
        } else {
            AppsFlyerLib.getInstance().subscribeForDeepLink(new DeepLinkListener(){

                public void onDeepLinking(@NonNull DeepLinkResult deepLinkResult) {
                    if (objectName != null) {
                        UnityPlayer.UnitySendMessage((String)objectName, (String)AppsFlyerAndroidWrapper.ON_DEEPLINKING, (String)deepLinkResult.toString());
                    }
                }
            });
        }
    }

    public static void addPushNotificationDeepLinkPath(String ... path) {
        AppsFlyerLib.getInstance().addPushNotificationDeepLinkPath(path);
    }

    public static void setDisableAdvertisingIdentifiers(boolean disable) {
        AppsFlyerLib.getInstance().setDisableAdvertisingIdentifiers(disable);
    }

    public static void setSharingFilterForPartners(String ... partners) {
        AppsFlyerLib.getInstance().setSharingFilterForPartners(partners);
    }

    public static void setDisableNetworkData(boolean disable) {
        AppsFlyerLib.getInstance().setDisableNetworkData(disable);
    }

    public static void setPluginInfo() {
        PluginInfo pluginInfo = new PluginInfo(Plugin.UNITY, PLUGIN_VERSION);
        AppsFlyerLib.getInstance().setPluginInfo(pluginInfo);
    }

    public static void setDeepLinkTimeout(long deepLinkTimeout) {
        ddlTimeout = deepLinkTimeout;
    }

    public static void initPurchaseConnector(String objectName, int store) {
        unityObjectName = objectName;
        Store s = AppsFlyerAndroidWrapper.mappingEnum(store);
        if (s != null) {
            builder = new PurchaseClient.Builder((Context)UnityPlayer.currentActivity, s);
            builder = PurchaseRevenueBridge.configurePurchaseClient(builder);
        } else {
            Log.w((String)"AppsFlyer_Connector", (String)"[PurchaseConnector]: Please choose a valid store.");
        }
    }

    public static void build() {
        if (builder != null) {
            purchaseClientInstance = builder.build();
        } else {
            Log.w((String)"AppsFlyer_Connector", (String)"[PurchaseConnector]: Initialization is required prior to building.");
        }
    }

    public static void setIsSandbox(boolean isSandbox) {
        if (builder != null) {
            builder.setSandbox(isSandbox);
        }
    }

    public static void setAutoLogSubscriptions(boolean logSubscriptions) {
        if (builder != null) {
            builder.logSubscriptions(logSubscriptions);
        }
    }

    public static void setAutoLogInApps(boolean autoLogInApps) {
        if (builder != null) {
            builder.autoLogInApps(autoLogInApps);
        }
    }

    public static void setPurchaseRevenueValidationListeners(boolean enableCallbacks) {
        if (builder != null && enableCallbacks) {
            builder.setSubscriptionValidationResultListener(new PurchaseClient.SubscriptionPurchaseValidationResultListener(){

                @RequiresApi(api=24)
                public void onResponse(@Nullable Map<String, ? extends SubscriptionValidationResult> result) {
                    if (unityObjectName != null) {
                        if (result == null) {
                            return;
                        }
                        result.forEach((k, v) -> {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            HashMap<String, Object> mapSubscription = new HashMap<String, Object>();
                            map.put("productId", k);
                            map.put("success", v.getSuccess() ? "true" : "false");
                            if (v.getSuccess()) {
                                SubscriptionPurchase subscriptionPurchase = v.getSubscriptionPurchase();
                                HashMap<String, String> mapCancelSurveyResult = new HashMap<String, String>();
                                if (subscriptionPurchase.getCanceledStateContext() != null) {
                                    HashMap mapCanceledStateContext = new HashMap();
                                    HashMap<String, Object> mapUserInitiatedCancellation = new HashMap<String, Object>();
                                    if (subscriptionPurchase.getCanceledStateContext().getUserInitiatedCancellation() != null) {
                                        if (subscriptionPurchase.getCanceledStateContext().getUserInitiatedCancellation().getCancelSurveyResult() != null) {
                                            mapCancelSurveyResult.put("reason", subscriptionPurchase.getCanceledStateContext().getUserInitiatedCancellation().getCancelSurveyResult().getReason());
                                            mapCancelSurveyResult.put("reasonUserInput", subscriptionPurchase.getCanceledStateContext().getUserInitiatedCancellation().getCancelSurveyResult().getReasonUserInput());
                                            mapUserInitiatedCancellation.put("cancelSurveyResult", mapCancelSurveyResult);
                                        }
                                        mapUserInitiatedCancellation.put("cancelTime", subscriptionPurchase.getCanceledStateContext().getUserInitiatedCancellation().getCancelTime());
                                    }
                                    mapCanceledStateContext.put("developerInitiatedCancellation", null);
                                    mapCanceledStateContext.put("replacementCancellation", null);
                                    mapCanceledStateContext.put("systemInitiatedCancellation", null);
                                    mapCanceledStateContext.put("userInitiatedCancellation", mapUserInitiatedCancellation);
                                }
                                if (subscriptionPurchase.getExternalAccountIdentifiers() != null) {
                                    HashMap<String, String> mapExternalAccountIdentifiers = new HashMap<String, String>();
                                    mapExternalAccountIdentifiers.put("externalAccountId", subscriptionPurchase.getExternalAccountIdentifiers().getExternalAccountId());
                                    mapExternalAccountIdentifiers.put("obfuscatedExternalAccountId", subscriptionPurchase.getExternalAccountIdentifiers().getObfuscatedExternalAccountId());
                                    mapExternalAccountIdentifiers.put("obfuscatedExternalProfileId", subscriptionPurchase.getExternalAccountIdentifiers().getObfuscatedExternalProfileId());
                                    mapSubscription.put("externalAccountIdentifiers", mapExternalAccountIdentifiers);
                                }
                                if (subscriptionPurchase.getPausedStateContext() != null) {
                                    HashMap<String, String> mapPausedStateContext = new HashMap<String, String>();
                                    mapPausedStateContext.put("autoResumeTime", subscriptionPurchase.getPausedStateContext().getAutoResumeTime());
                                    mapSubscription.put("pausedStateContext", mapPausedStateContext);
                                }
                                if (subscriptionPurchase.getSubscribeWithGoogleInfo() != null) {
                                    HashMap<String, String> mapSubscribeWithGoogleInfo = new HashMap<String, String>();
                                    mapSubscribeWithGoogleInfo.put("emailAddress", subscriptionPurchase.getSubscribeWithGoogleInfo().getEmailAddress());
                                    mapSubscribeWithGoogleInfo.put("familyName", subscriptionPurchase.getSubscribeWithGoogleInfo().getFamilyName());
                                    mapSubscribeWithGoogleInfo.put("givenName", subscriptionPurchase.getSubscribeWithGoogleInfo().getGivenName());
                                    mapSubscribeWithGoogleInfo.put("profileId", subscriptionPurchase.getSubscribeWithGoogleInfo().getProfileId());
                                    mapSubscribeWithGoogleInfo.put("profileName", subscriptionPurchase.getSubscribeWithGoogleInfo().getProfileName());
                                    mapSubscription.put("subscribeWithGoogleInfo", mapSubscribeWithGoogleInfo);
                                }
                                int sizeItems = subscriptionPurchase.getLineItems().size();
                                Map[] lineItems = new Map[sizeItems];
                                for (int i = 0; i < sizeItems; ++i) {
                                    HashMap<String, Object> mapSubscriptionPurchaseLineItem = new HashMap<String, Object>();
                                    mapSubscriptionPurchaseLineItem.put("expiryTime", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getExpiryTime());
                                    mapSubscriptionPurchaseLineItem.put("productId", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getProductId());
                                    if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan() != null) {
                                        HashMap<String, Object> mapAutoRenewingPlan = new HashMap<String, Object>();
                                        if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getAutoRenewEnabled() != null) {
                                            mapAutoRenewingPlan.put("autoRenewEnabled", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getAutoRenewEnabled() != false ? "true" : "false");
                                        }
                                        if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails() != null) {
                                            HashMap<String, Object> mapPriceChangeDetails = new HashMap<String, Object>();
                                            mapPriceChangeDetails.put("expectedNewPriceChargeTime", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails().getExpectedNewPriceChargeTime());
                                            mapPriceChangeDetails.put("priceChangeMode", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails().getPriceChangeMode());
                                            mapPriceChangeDetails.put("priceChangeState", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails().getPriceChangeState());
                                            mapAutoRenewingPlan.put("priceChangeDetails", mapPriceChangeDetails);
                                            if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails().getNewPrice() != null) {
                                                HashMap<String, Object> mapMoney = new HashMap<String, Object>();
                                                mapMoney.put("currencyCode", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails().getNewPrice().getCurrencyCode());
                                                mapMoney.put("nanos", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails().getNewPrice().getNanos());
                                                mapMoney.put("units", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getAutoRenewingPlan().getPriceChangeDetails().getNewPrice().getUnits());
                                                mapPriceChangeDetails.put("newPrice", mapMoney);
                                            }
                                        }
                                        mapSubscriptionPurchaseLineItem.put("autoRenewingPlan", mapAutoRenewingPlan);
                                    }
                                    if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getOfferDetails() != null) {
                                        HashMap<String, String> mapOfferDetails = new HashMap<String, String>();
                                        mapOfferDetails.put("basePlanId", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getOfferDetails().getBasePlanId());
                                        if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getOfferDetails().getOfferId() != null) {
                                            mapOfferDetails.put("offerId", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getOfferDetails().getOfferId());
                                        }
                                        mapSubscriptionPurchaseLineItem.put("offerDetails", mapOfferDetails);
                                    }
                                    if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getDeferredItemReplacement() != null) {
                                        HashMap<String, String> mapDeferredItemReplacement = new HashMap<String, String>();
                                        mapDeferredItemReplacement.put("productId", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getDeferredItemReplacement().getProductId());
                                        mapSubscriptionPurchaseLineItem.put("deferredItemReplacement", mapDeferredItemReplacement);
                                    }
                                    if (((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getPrepaidPlan() != null && ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getPrepaidPlan().getAllowExtendAfterTime() != null) {
                                        HashMap<String, String> mapPrepaidPlan = new HashMap<String, String>();
                                        mapPrepaidPlan.put("allowExtendAfterTime", ((SubscriptionPurchaseLineItem)subscriptionPurchase.getLineItems().get(i)).getPrepaidPlan().getAllowExtendAfterTime());
                                        mapSubscriptionPurchaseLineItem.put("prepaidPlan", mapPrepaidPlan);
                                    }
                                    lineItems[i] = mapSubscriptionPurchaseLineItem;
                                }
                                mapSubscription.put("lineItems", lineItems);
                                mapSubscription.put("acknowledgementState", subscriptionPurchase.getAcknowledgementState());
                                mapSubscription.put("canceledStateContext", subscriptionPurchase.getCanceledStateContext());
                                mapSubscription.put("kind", subscriptionPurchase.getKind());
                                mapSubscription.put("latestOrderId", subscriptionPurchase.getLatestOrderId());
                                mapSubscription.put("linkedPurchaseToken", subscriptionPurchase.getLinkedPurchaseToken());
                                mapSubscription.put("regionCode", subscriptionPurchase.getRegionCode());
                                mapSubscription.put("subscriptionState", subscriptionPurchase.getSubscriptionState());
                                mapSubscription.put("testPurchase", null);
                                mapSubscription.put("startTime", subscriptionPurchase.getStartTime());
                                map.put("subscriptionPurchase", mapSubscription);
                            } else {
                                ValidationFailureData failureData = v.getFailureData();
                                HashMap<String, Object> mapValidationFailureData = new HashMap<String, Object>();
                                mapValidationFailureData.put("status", failureData.getStatus());
                                mapValidationFailureData.put("description", failureData.getDescription());
                                map.put("failureData", mapValidationFailureData);
                            }
                            JSONObject resultObject = new JSONObject(map);
                            UnityPlayer.UnitySendMessage((String)unityObjectName, (String)AppsFlyerAndroidWrapper.VALIDATION_CALLBACK, (String)resultObject.toString());
                        });
                    }
                }

                public void onFailure(@NonNull String result, @Nullable Throwable error) {
                    if (unityObjectName != null) {
                        UnityPlayer.UnitySendMessage((String)unityObjectName, (String)AppsFlyerAndroidWrapper.ERROR_CALLBACK, (String)result);
                    }
                }
            });
            builder.setInAppValidationResultListener(new PurchaseClient.InAppPurchaseValidationResultListener(){

                @SuppressLint(value={"LongLogTag"})
                @RequiresApi(api=24)
                public void onResponse(@Nullable Map<String, ? extends InAppPurchaseValidationResult> result) {
                    if (unityObjectName != null) {
                        if (result == null) {
                            return;
                        }
                        result.forEach((k, v) -> {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            HashMap<String, Object> mapIAP = new HashMap<String, Object>();
                            map.put("token", k);
                            map.put("success", v.getSuccess() ? "true" : "false");
                            if (v.getSuccess()) {
                                ProductPurchase productPurchase = v.getProductPurchase();
                                mapIAP.put("productId", productPurchase.getProductId());
                                mapIAP.put("purchaseState", productPurchase.getPurchaseState());
                                mapIAP.put("kind", productPurchase.getKind());
                                mapIAP.put("purchaseTimeMillis", productPurchase.getPurchaseTimeMillis());
                                mapIAP.put("consumptionState", productPurchase.getConsumptionState());
                                mapIAP.put("developerPayload", productPurchase.getDeveloperPayload());
                                mapIAP.put("orderId", productPurchase.getOrderId());
                                mapIAP.put("purchaseType", productPurchase.getPurchaseType());
                                mapIAP.put("acknowledgementState", productPurchase.getAcknowledgementState());
                                mapIAP.put("purchaseToken", productPurchase.getPurchaseToken());
                                mapIAP.put("quantity", productPurchase.getQuantity());
                                mapIAP.put("obfuscatedExternalAccountId", productPurchase.getObfuscatedExternalAccountId());
                                mapIAP.put("obfuscatedExternalProfileId", productPurchase.getObfuscatedExternalProfileId());
                                mapIAP.put("regionCode", productPurchase.getRegionCode());
                                map.put("productPurchase", mapIAP);
                            } else {
                                ValidationFailureData failureData = v.getFailureData();
                                HashMap<String, Object> mapValidationFailureData = new HashMap<String, Object>();
                                mapValidationFailureData.put("status", failureData.getStatus());
                                mapValidationFailureData.put("description", failureData.getDescription());
                                map.put("failureData", mapValidationFailureData);
                            }
                            JSONObject resultObject = new JSONObject(map);
                            UnityPlayer.UnitySendMessage((String)unityObjectName, (String)AppsFlyerAndroidWrapper.VALIDATION_CALLBACK, (String)resultObject.toString());
                        });
                    }
                }

                public void onFailure(@NonNull String result, @Nullable Throwable error) {
                    if (unityObjectName != null) {
                        UnityPlayer.UnitySendMessage((String)unityObjectName, (String)AppsFlyerAndroidWrapper.ERROR_CALLBACK, (String)result);
                    }
                }
            });
        }
    }

    public static void startObservingTransactions() {
        if (purchaseClientInstance != null) {
            purchaseClientInstance.startObservingTransactions();
        } else {
            Log.w((String)"AppsFlyer_Connector", (String)"[PurchaseConnector]: startObservingTransactions was not called because the purchase client instance is null, please call build() prior to this function.");
        }
    }

    public static void stopObservingTransactions() {
        if (purchaseClientInstance != null) {
            purchaseClientInstance.stopObservingTransactions();
        } else {
            Log.w((String)"AppsFlyer_Connector", (String)"[PurchaseConnector]: stopObservingTransactions was not called because the purchase client instance is null, please call build() prior to this function.");
        }
    }

    private static Store mappingEnum(int storeEnum) {
        switch (storeEnum) {
            case 0: {
                return Store.GOOGLE;
            }
        }
        return null;
    }

    static {
        devkey = "";
        ddlTimeout = 3000L;
    }
}

