/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.unity;

import android.util.Log;
import com.appsflyer.api.PurchaseClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class PurchaseRevenueBridge {
    private static final String TAG = "AppsFlyerUnity";
    private static UnityPurchaseRevenueBridge unityBridge;

    public static void setUnityBridge(UnityPurchaseRevenueBridge bridge) {
        unityBridge = bridge;
    }

    public static PurchaseClient.Builder configurePurchaseClient(PurchaseClient.Builder builder) {
        return builder.setInAppPurchaseEventDataSource(purchaseEvents -> {
            try {
                String response;
                String eventsJson = new JSONObject(Collections.singletonMap("events", purchaseEvents)).toString();
                String string = response = unityBridge != null ? unityBridge.getAdditionalParameters(eventsJson, "") : null;
                if (response != null) {
                    JSONObject json = new JSONObject(response);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Iterator keys = json.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        map.put(key, json.get(key));
                    }
                    return map;
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed to parse additional params from Unity", (Throwable)e);
            }
            return Collections.emptyMap();
        }).setSubscriptionPurchaseEventDataSource(purchaseEvents -> {
            try {
                String response;
                String eventsJson = new JSONObject(Collections.singletonMap("events", purchaseEvents)).toString();
                String string = response = unityBridge != null ? unityBridge.getAdditionalParameters("", eventsJson) : null;
                if (response != null) {
                    JSONObject json = new JSONObject(response);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Iterator keys = json.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        map.put(key, json.get(key));
                    }
                    return map;
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed to parse additional params from Unity", (Throwable)e);
            }
            return Collections.emptyMap();
        });
    }

    public static interface UnityPurchaseRevenueBridge {
        public String getAdditionalParameters(String var1, String var2);
    }
}

