/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.Enclosure;
import com.apptasticsoftware.rssreader.Image;
import com.apptasticsoftware.rssreader.Item;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RssReader {
    private static final String LOG_GROUP = "com.apptastic.rssreader";
    private HttpClient httpClient;

    public RssReader() {
    }

    public RssReader(HttpClient httpClient) {
        Objects.requireNonNull(httpClient, "Http client must not be null");
        this.httpClient = httpClient;
    }

    public Stream<Item> read(String url) throws IOException {
        try {
            return this.readAsync(url).get(1L, TimeUnit.MINUTES);
        }
        catch (CompletionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                throw new AssertionError((Object)e2);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public Stream<Item> read(InputStream inputStream) {
        RssItemIterator itemIterator = new RssItemIterator(inputStream);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(itemIterator, 16), false);
    }

    public CompletableFuture<Stream<Item>> readAsync(String url) {
        return this.sendAsyncRequest(url).thenApply(this.processResponse());
    }

    protected CompletableFuture<HttpResponse<InputStream>> sendAsyncRequest(String url) {
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(25L)).header("Accept-Encoding", "gzip").GET().build();
        HttpClient client = this.httpClient;
        if (client == null) {
            client = this.createHttpClient();
        }
        return client.sendAsync(req, HttpResponse.BodyHandlers.ofInputStream());
    }

    private Function<HttpResponse<InputStream>, Stream<Item>> processResponse() {
        return response -> {
            try {
                if (response.statusCode() >= 400 && response.statusCode() < 600) {
                    throw new IOException("Response http status code: " + response.statusCode());
                }
                InputStream inputStream = (InputStream)response.body();
                if (Optional.of("gzip").equals(response.headers().firstValue("Content-Encoding"))) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                inputStream = new BufferedInputStream(inputStream);
                this.removeBadDate(inputStream);
                RssItemIterator itemIterator = new RssItemIterator(inputStream);
                return StreamSupport.stream(Spliterators.spliteratorUnknownSize(itemIterator, 16), false);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        };
    }

    private void removeBadDate(InputStream inputStream) throws IOException {
        int secondChar;
        inputStream.mark(2);
        int firstChar = inputStream.read();
        if (firstChar != 65279 && firstChar != 13 && firstChar != 10 && !Character.isWhitespace(firstChar)) {
            inputStream.reset();
        } else if ((firstChar == 13 || Character.isWhitespace(firstChar)) && (secondChar = inputStream.read()) != 10 && !Character.isWhitespace(secondChar)) {
            inputStream.reset();
            inputStream.read();
        }
    }

    private HttpClient createHttpClient() {
        HttpClient client;
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.3");
            context.init(null, null, null);
            client = HttpClient.newBuilder().sslContext(context).connectTimeout(Duration.ofSeconds(25L)).followRedirects(HttpClient.Redirect.NORMAL).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(25L)).followRedirects(HttpClient.Redirect.NORMAL).build();
        }
        return client;
    }

    static class RssItemIterator
    implements Iterator<Item> {
        private final StringBuilder textBuilder;
        private final InputStream is;
        private XMLStreamReader reader;
        private Channel channel;
        private Image image;
        private Item item;
        private Item nextItem;
        private boolean isChannelPart;
        private boolean isImagePart;
        private String elementName;

        public RssItemIterator(InputStream is) {
            block2: {
                this.image = null;
                this.item = null;
                this.isChannelPart = true;
                this.isImagePart = false;
                this.elementName = null;
                this.is = is;
                this.nextItem = null;
                this.textBuilder = new StringBuilder();
                try {
                    XMLInputFactory xmlInFact = XMLInputFactory.newInstance();
                    xmlInFact.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                    xmlInFact.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                    this.reader = xmlInFact.createXMLStreamReader(is);
                }
                catch (XMLStreamException e) {
                    Logger logger = Logger.getLogger(RssReader.LOG_GROUP);
                    if (!logger.isLoggable(Level.WARNING)) break block2;
                    logger.log(Level.WARNING, "Failed to process XML. ", e);
                }
            }
        }

        void peekNext() {
            if (this.nextItem == null) {
                try {
                    this.nextItem = this.next();
                }
                catch (NoSuchElementException e) {
                    this.nextItem = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.peekNext();
            return this.nextItem != null;
        }

        @Override
        public Item next() {
            block9: {
                block8: {
                    if (this.nextItem != null) {
                        Item next = this.nextItem;
                        this.nextItem = null;
                        return next;
                    }
                    try {
                        while (this.reader.hasNext()) {
                            boolean itemParsed;
                            int type = this.reader.next();
                            if (type == 4 || type == 12) {
                                this.parseCharacters();
                                continue;
                            }
                            if (type == 1) {
                                this.parseStartElement();
                                this.parseAttributes();
                                continue;
                            }
                            if (type != 2 || !(itemParsed = this.parseEndElement())) continue;
                            return this.item;
                        }
                    }
                    catch (XMLStreamException e) {
                        Logger logger = Logger.getLogger(RssReader.LOG_GROUP);
                        if (!logger.isLoggable(Level.WARNING)) break block8;
                        logger.log(Level.WARNING, "Failed to parse XML. ", e);
                    }
                }
                try {
                    this.reader.close();
                    this.is.close();
                }
                catch (IOException | XMLStreamException e) {
                    Logger logger = Logger.getLogger(RssReader.LOG_GROUP);
                    if (!logger.isLoggable(Level.WARNING)) break block9;
                    logger.log(Level.WARNING, "Failed to close XML stream. ", e);
                }
            }
            throw new NoSuchElementException();
        }

        void parseStartElement() {
            this.textBuilder.setLength(0);
            this.elementName = this.reader.getLocalName();
            if ("channel".equals(this.elementName) || "feed".equals(this.elementName)) {
                this.channel = new Channel();
                this.channel.setTitle("");
                this.channel.setDescription("");
                this.channel.setLink("");
                this.isChannelPart = true;
            } else if ("item".equals(this.elementName) || "entry".equals(this.elementName)) {
                this.item = new Item();
                this.item.setChannel(this.channel);
                this.isChannelPart = false;
            } else if ("guid".equals(this.elementName)) {
                String value = this.reader.getAttributeValue(null, "isPermaLink");
                if (this.item != null) {
                    this.item.setIsPermaLink(Boolean.parseBoolean(value));
                }
            } else if ("image".equals(this.elementName)) {
                this.image = new Image();
                this.channel.setImage(this.image);
                this.isImagePart = true;
            }
        }

        void parseAttributes() {
            if (this.reader.getLocalName().equals("link")) {
                String rel = this.reader.getAttributeValue(null, "rel");
                String link = this.reader.getAttributeValue(null, "href");
                boolean isAlternate = "alternate".equals(rel);
                if (link != null && isAlternate) {
                    if (this.isChannelPart) {
                        this.channel.setLink(link);
                    } else {
                        this.item.setLink(link);
                    }
                }
            } else if (this.reader.getLocalName().equals("enclosure")) {
                String url = this.reader.getAttributeValue(null, "url");
                String type = this.reader.getAttributeValue(null, "type");
                String length = this.reader.getAttributeValue(null, "length");
                Long parsedLength = length == null || length.isEmpty() ? null : Long.valueOf(Long.parseLong(length));
                this.item.setEclosure(new Enclosure(url, type, parsedLength));
            }
        }

        boolean parseEndElement() {
            String name = this.reader.getLocalName();
            String text = this.textBuilder.toString().trim();
            if ("image".equals(name)) {
                this.isImagePart = false;
            } else if (this.isImagePart) {
                this.parseImageCharacters(this.elementName, text);
            } else if (this.isChannelPart) {
                this.parseChannelCharacters(this.elementName, text);
            } else {
                this.parseItemCharacters(this.elementName, this.item, text);
            }
            this.textBuilder.setLength(0);
            return "item".equals(name) || "entry".equals(name);
        }

        void parseCharacters() {
            String text = this.reader.getText();
            if (text.trim().isEmpty()) {
                return;
            }
            this.textBuilder.append(text);
        }

        void parseChannelCharacters(String elementName, String text) {
            if (this.channel == null || text.isEmpty()) {
                return;
            }
            if ("title".equals(elementName)) {
                this.channel.setTitle(text);
            } else if ("description".equals(elementName) || "subtitle".equals(elementName)) {
                this.channel.setDescription(text);
            } else if ("link".equals(elementName)) {
                this.channel.setLink(text);
            } else if ("category".equals(elementName)) {
                this.channel.setCategory(text);
            } else if ("language".equals(elementName)) {
                this.channel.setLanguage(text);
            } else if ("copyright".equals(elementName) || "rights".equals(elementName)) {
                this.channel.setCopyright(text);
            } else if ("generator".equals(elementName)) {
                this.channel.setGenerator(text);
            } else if ("ttl".equals(elementName)) {
                this.channel.setTtl(text);
            } else if ("pubDate".equals(elementName)) {
                this.channel.setPubDate(text);
            } else if ("lastBuildDate".equals(elementName) || "updated".equals(elementName)) {
                this.channel.setLastBuildDate(text);
            } else if ("managingEditor".equals(elementName)) {
                this.channel.setManagingEditor(text);
            } else if ("webMaster".equals(elementName)) {
                this.channel.setWebMaster(text);
            }
        }

        void parseImageCharacters(String elementName, String text) {
            if (this.image == null || text.isEmpty()) {
                return;
            }
            if ("title".equals(elementName)) {
                this.image.setTitle(text);
            } else if ("link".equals(elementName)) {
                this.image.setLink(text);
            } else if ("url".equals(elementName)) {
                this.image.setUrl(text);
            } else if ("description".equals(elementName)) {
                this.image.setDescription(text);
            } else if ("height".equals(elementName)) {
                this.image.setHeight(Integer.valueOf(text));
            } else if ("width".equals(elementName)) {
                this.image.setWidth(Integer.valueOf(text));
            } else if ("image".equals(elementName)) {
                this.isImagePart = false;
            }
        }

        void parseItemCharacters(String elementName, Item item, String text) {
            if (text.isEmpty()) {
                return;
            }
            if ("guid".equals(elementName) || "id".equals(elementName)) {
                item.setGuid(text);
            } else if ("title".equals(elementName)) {
                item.setTitle(text);
            } else if ("description".equals(elementName) || "summary".equals(elementName) || "content".equals(elementName)) {
                item.setDescription(text);
            } else if ("link".equals(elementName)) {
                item.setLink(text);
            } else if ("author".equals(elementName)) {
                item.setAuthor(text);
            } else if ("category".equals(elementName)) {
                item.setCategory(text);
            } else if ("pubDate".equals(elementName) || "published".equals(elementName)) {
                item.setPubDate(text);
            } else if ("updated".equals(elementName) && item.getPubDate().isEmpty()) {
                item.setPubDate(text);
            }
        }
    }
}

