/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.module.mediarss;

import com.apptasticsoftware.rssreader.AbstractRssReader;
import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.module.mediarss.MediaRssItem;
import com.apptasticsoftware.rssreader.module.mediarss.MediaThumbnail;
import java.net.http.HttpClient;
import java.util.function.BiConsumer;

public class MediaRssReader
extends AbstractRssReader<Channel, MediaRssItem> {
    public MediaRssReader() {
    }

    public MediaRssReader(HttpClient httpClient) {
        super(httpClient);
    }

    @Override
    protected Channel createChannel(DateTimeParser dateTimeParser) {
        return new Channel(dateTimeParser);
    }

    @Override
    protected MediaRssItem createItem(DateTimeParser dateTimeParser) {
        return new MediaRssItem(dateTimeParser);
    }

    @Override
    protected void registerItemAttributes() {
        super.registerItemAttributes();
        super.addItemExtension("media:thumbnail", "url", this.mediaThumbnailSetterTemplateBuilder(MediaThumbnail::setUrl));
        super.addItemExtension("media:thumbnail", "height", this.mediaThumbnailSetterTemplateBuilder((mediaThumbnail, height) -> mediaThumbnail.setHeight(Integer.parseInt(height))));
        super.addItemExtension("media:thumbnail", "width", this.mediaThumbnailSetterTemplateBuilder((mediaThumbnail, width) -> mediaThumbnail.setWidth(Integer.parseInt(width))));
    }

    private BiConsumer<MediaRssItem, String> mediaThumbnailSetterTemplateBuilder(BiConsumer<MediaThumbnail, String> setter) {
        return (mediaRssItem, value) -> {
            MediaThumbnail mediaThumbnail = mediaRssItem.getMediaThumbnail().orElse(new MediaThumbnail());
            setter.accept(mediaThumbnail, (String)value);
            mediaRssItem.setMediaThumbnail(mediaThumbnail);
        };
    }
}

