/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Item;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Comparator;

public class DateTime {
    private static ZoneId defaultZone = ZoneId.of("UTC");
    public static final DateTimeFormatter RFC_1123_DATE_TIME_NO_TIMEZONE = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss").withZone(ZoneId.of("UTC"));
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME_SPECIAL = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss z");
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST;
    public static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT;

    private DateTime() {
    }

    public static void setDefaultZone(ZoneId defaultZone) {
        DateTime.defaultZone = defaultZone;
    }

    public static LocalDateTime toLocalDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        return LocalDateTime.parse(dateTime, formatter);
    }

    public static ZonedDateTime toZonedDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        if (dateTime.length() == 19 || (dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            LocalDateTime localDateTime = LocalDateTime.parse(dateTime, formatter);
            return ZonedDateTime.of(localDateTime, defaultZone);
        }
        return ZonedDateTime.parse(dateTime, formatter);
    }

    private static DateTimeFormatter getDateTimeFormatter(String dateTime) {
        if (dateTime.length() >= 20 && dateTime.length() <= 31 && dateTime.charAt(4) == '-' && dateTime.charAt(10) == 'T') {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT;
        }
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST;
        }
        if (dateTime.length() >= 28 && dateTime.length() <= 31) {
            return DateTimeFormatter.RFC_1123_DATE_TIME;
        }
        if ((dateTime.length() == 26 || dateTime.length() == 27) && dateTime.charAt(3) == ',' && dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL;
        }
        if ((dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            return RFC_1123_DATE_TIME_NO_TIMEZONE;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == 'T') {
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == ' ') {
            return ISO_LOCAL_DATE_TIME_SPECIAL;
        }
        return null;
    }

    public static Long toEpochMilli(String dateTime) {
        ZonedDateTime zonedDateTime = DateTime.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static Comparator<Item> pubDateComparator() {
        return Comparator.comparing(i -> i.getPubDate().map(DateTime::toEpochMilli).orElse(0L));
    }

    static {
        RFC_1123_DATE_TIME_SPECIAL_EDT = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'EDT'").withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'EST'").withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'CDT'").withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'CST'").withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'MDT'").withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'MST'").withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'PDT'").withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST = DateTimeFormatter.ofPattern("EEE, d LLL yyyy HH:mm:ss 'PST'").withZone(ZoneOffset.ofHours(-8));
    }
}

