/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.module.itunes;

import com.apptasticsoftware.rssreader.AbstractRssReader;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.module.itunes.ItunesChannel;
import com.apptasticsoftware.rssreader.module.itunes.ItunesItem;
import com.apptasticsoftware.rssreader.module.itunes.ItunesOwner;
import com.apptasticsoftware.rssreader.util.Mapper;

public class ItunesRssReader
extends AbstractRssReader<ItunesChannel, ItunesItem> {
    @Override
    protected void registerChannelTags() {
        super.registerChannelTags();
        this.addChannelExtension("itunes:explicit", (i, v) -> Mapper.mapBoolean(v, i::setItunesExplicit));
        this.addChannelExtension("itunes:author", ItunesChannel::setItunesAuthor);
        this.addChannelExtension("itunes:name", (i, v) -> {
            if (i.getItunesOwner().isEmpty()) {
                i.setItunesOwner(new ItunesOwner());
            }
            i.getItunesOwner().ifPresent(a -> a.setName((String)v));
        });
        this.addChannelExtension("itunes:email", (i, v) -> {
            if (i.getItunesOwner().isEmpty()) {
                i.setItunesOwner(new ItunesOwner());
            }
            i.getItunesOwner().ifPresent(a -> a.setEmail((String)v));
        });
        this.addChannelExtension("itunes:title", ItunesChannel::setItunesTitle);
        this.addChannelExtension("itunes:subtitle", ItunesChannel::setItunesSubtitle);
        this.addChannelExtension("itunes:summary", ItunesChannel::setItunesSummary);
        this.addChannelExtension("itunes:type", ItunesChannel::setItunesType);
        this.addChannelExtension("itunes:new-feed-url", ItunesChannel::setItunesNewFeedUrl);
        this.addChannelExtension("itunes:block", (i, v) -> Mapper.mapBoolean(v, i::setItunesBlock));
        this.addChannelExtension("itunes:complete", (i, v) -> Mapper.mapBoolean(v, i::setItunesComplete));
    }

    @Override
    protected void registerChannelAttributes() {
        super.registerChannelAttributes();
        this.addChannelExtension("itunes:image", "href", ItunesChannel::setItunesImage);
        this.addChannelExtension("itunes:category", "text", ItunesChannel::addItunesCategory);
    }

    @Override
    protected void registerItemTags() {
        super.registerItemTags();
        this.addItemExtension("itunes:duration", ItunesItem::setItunesDuration);
        this.addItemExtension("itunes:explicit", (i, v) -> Mapper.mapBoolean(v, i::setItunesExplicit));
        this.addItemExtension("itunes:title", ItunesItem::setItunesTitle);
        this.addItemExtension("itunes:subtitle", ItunesItem::setItunesSubtitle);
        this.addItemExtension("itunes:summary", ItunesItem::setItunesSummary);
        this.addItemExtension("itunes:keywords", ItunesItem::setItunesKeywords);
        this.addItemExtension("itunes:episode", (i, v) -> Mapper.mapInteger(v, i::setItunesEpisode));
        this.addItemExtension("itunes:season", (i, v) -> Mapper.mapInteger(v, i::setItunesSeason));
        this.addItemExtension("itunes:episodeType", ItunesItem::setItunesEpisodeType);
        this.addItemExtension("itunes:block", (i, v) -> Mapper.mapBoolean(v, i::setItunesBlock));
        this.addItemExtension("itunes:image", "href", ItunesItem::setItunesImage);
    }

    @Override
    protected ItunesChannel createChannel(DateTimeParser dateTimeParser) {
        return new ItunesChannel(dateTimeParser);
    }

    @Override
    protected ItunesItem createItem(DateTimeParser dateTimeParser) {
        return new ItunesItem(dateTimeParser);
    }
}

