/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.exception;

import com.aquenos.epics.jackie.common.exception.ErrorHandler;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilLoggingErrorHandler
implements ErrorHandler {
    private final Level exceptionLogLevel;
    private final Level noExceptionLogLevel;

    public JavaUtilLoggingErrorHandler() {
        this(Level.WARNING, Level.INFO);
    }

    public JavaUtilLoggingErrorHandler(Level exceptionLogLevel, Level noExceptionLogLevel) {
        Objects.requireNonNull(exceptionLogLevel, "exceptionLogLevel must not be null.");
        Objects.requireNonNull(noExceptionLogLevel, "noExceptionLogLevel must not be null.");
        this.exceptionLogLevel = exceptionLogLevel;
        this.noExceptionLogLevel = noExceptionLogLevel;
    }

    @Override
    public void handleError(Class<?> context, Throwable e, String description) {
        Logger logger = Logger.getLogger(context.getName());
        if (e != null) {
            logger.log(this.exceptionLogLevel, description != null ? description : "Caught an exception.", e);
        } else {
            logger.log(this.noExceptionLogLevel, description);
        }
    }
}

