/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.io;

import com.aquenos.epics.jackie.common.io.ByteSink;
import java.nio.ByteBuffer;

public abstract class AbstractByteSink
implements ByteSink {
    protected static final int SIZE_OF_BYTE = 1;
    protected static final int SIZE_OF_DOUBLE = 8;
    protected static final int SIZE_OF_FLOAT = 4;
    protected static final int SIZE_OF_INT = 4;
    protected static final int SIZE_OF_LONG = 8;
    protected static final int SIZE_OF_SHORT = 2;

    protected AbstractByteSink() {
    }

    private void checkSourceArrayLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be negative.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative.");
        }
        if ((long)offset + (long)length > (long)arrayLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public ByteSink putByte(byte b) {
        return this.putByteArray(new byte[]{b});
    }

    @Override
    public ByteSink putByteArray(byte[] source) {
        return this.putByteArray(source, 0, source.length);
    }

    @Override
    public ByteSink putDouble(double value) {
        return this.putDoubleArray(new double[]{value});
    }

    @Override
    public ByteSink putDoubleArray(double[] source) {
        return this.putDoubleArray(source, 0, source.length);
    }

    @Override
    public ByteSink putDoubleArray(double[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        byte[] byteArray = new byte[8 * length];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.asDoubleBuffer().put(source, offset, length);
        return this.putByteArray(byteArray);
    }

    @Override
    public ByteSink putFloat(float value) {
        return this.putFloatArray(new float[]{value});
    }

    @Override
    public ByteSink putFloatArray(float[] source) {
        return this.putFloatArray(source, 0, source.length);
    }

    @Override
    public ByteSink putFloatArray(float[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        byte[] byteArray = new byte[4 * length];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.asFloatBuffer().put(source, offset, length);
        return this.putByteArray(byteArray);
    }

    @Override
    public ByteSink putInt(int value) {
        return this.putIntArray(new int[]{value});
    }

    @Override
    public ByteSink putIntArray(int[] source) {
        return this.putIntArray(source, 0, source.length);
    }

    @Override
    public ByteSink putIntArray(int[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        byte[] byteArray = new byte[4 * length];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.asIntBuffer().put(source, offset, length);
        return this.putByteArray(byteArray);
    }

    @Override
    public ByteSink putShort(short value) {
        return this.putShortArray(new short[]{value});
    }

    @Override
    public ByteSink putShortArray(short[] source) {
        return this.putShortArray(source, 0, source.length);
    }

    @Override
    public ByteSink putShortArray(short[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        byte[] byteArray = new byte[2 * length];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.asShortBuffer().put(source, offset, length);
        return this.putByteArray(byteArray);
    }

    @Override
    public ByteSink putLong(long value) {
        return this.putLongArray(new long[]{value});
    }

    @Override
    public ByteSink putLongArray(long[] source) {
        return this.putLongArray(source, 0, source.length);
    }

    @Override
    public ByteSink putLongArray(long[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        byte[] byteArray = new byte[8 * length];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.asLongBuffer().put(source, offset, length);
        return this.putByteArray(byteArray);
    }
}

