/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.io;

import com.aquenos.epics.jackie.common.io.ByteSource;
import java.nio.ByteBuffer;

public abstract class AbstractByteSource
implements ByteSource {
    protected static final int SIZE_OF_BYTE = 1;
    protected static final int SIZE_OF_DOUBLE = 8;
    protected static final int SIZE_OF_FLOAT = 4;
    protected static final int SIZE_OF_INT = 4;
    protected static final int SIZE_OF_LONG = 8;
    protected static final int SIZE_OF_SHORT = 2;

    protected AbstractByteSource() {
    }

    private void checkDestinationArraySize(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be negative.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative.");
        }
        if ((long)offset + (long)length > (long)arrayLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public byte getByte() {
        byte value = this.getByteArray(1)[0];
        return value;
    }

    @Override
    public byte[] getByteArray(int length) {
        byte[] value = new byte[length];
        this.getByteArray(value, 0, length);
        return value;
    }

    @Override
    public double getDouble() {
        double value = this.getDoubleArray(1)[0];
        return value;
    }

    @Override
    public double[] getDoubleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        double[] value = new double[length];
        this.getDoubleArray(value, 0, length);
        return value;
    }

    @Override
    public AbstractByteSource getDoubleArray(double[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        byte[] bytes = this.getByteArray(length * 8);
        ByteBuffer.wrap(bytes).asDoubleBuffer().get(destination, offset, length);
        return this;
    }

    @Override
    public float getFloat() {
        float value = this.getFloatArray(1)[0];
        return value;
    }

    @Override
    public float[] getFloatArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        float[] value = new float[length];
        this.getFloatArray(value, 0, length);
        return value;
    }

    @Override
    public AbstractByteSource getFloatArray(float[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        byte[] bytes = this.getByteArray(length * 4);
        ByteBuffer.wrap(bytes).asFloatBuffer().get(destination, offset, length);
        return this;
    }

    @Override
    public int getInt() {
        int value = this.getIntArray(1)[0];
        return value;
    }

    @Override
    public int[] getIntArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        int[] value = new int[length];
        this.getIntArray(value, 0, length);
        return value;
    }

    @Override
    public AbstractByteSource getIntArray(int[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        byte[] bytes = this.getByteArray(length * 4);
        ByteBuffer.wrap(bytes).asIntBuffer().get(destination, offset, length);
        return this;
    }

    @Override
    public long getLong() {
        long value = this.getLongArray(1)[0];
        return value;
    }

    @Override
    public long[] getLongArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        long[] value = new long[length];
        this.getLongArray(value, 0, length);
        return value;
    }

    @Override
    public AbstractByteSource getLongArray(long[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        byte[] bytes = this.getByteArray(length * 8);
        ByteBuffer.wrap(bytes).asLongBuffer().get(destination, offset, length);
        return this;
    }

    @Override
    public short getShort() {
        short value = this.getShortArray(1)[0];
        return value;
    }

    @Override
    public short[] getShortArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        short[] value = new short[length];
        this.getShortArray(value, 0, length);
        return value;
    }

    @Override
    public AbstractByteSource getShortArray(short[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        byte[] bytes = this.getByteArray(length * 2);
        ByteBuffer.wrap(bytes).asShortBuffer().get(destination, offset, length);
        return this;
    }

    private static void addByteToStringBuilder(StringBuilder sb, byte b) {
        sb.append("0x");
        if (b < 16 && b >= 0) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b & 0xFF));
    }

    public String toString() {
        int remaining = this.remaining();
        final int length = remaining > 1024 ? 1024 : remaining;
        final StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[remaining=");
        sb.append(remaining);
        sb.append(", buffer=[");
        if (length != 0) {
            try {
                this.atomicGet(new ByteSource.AtomicGetOperation<Void>(){

                    @Override
                    public Void get() {
                        for (byte b : AbstractByteSource.this.getByteArray(length)) {
                            AbstractByteSource.addByteToStringBuilder(sb, b);
                            sb.append(", ");
                        }
                        throw new RuntimeException("This exception should be caught by the surrounding code.");
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (remaining == length) {
                sb.delete(sb.length() - 2, sb.length());
            } else {
                sb.append("...");
            }
        }
        sb.append("]]");
        return sb.toString();
    }
}

