/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.io;

import com.aquenos.epics.jackie.common.exception.ErrorHandler;
import com.aquenos.epics.jackie.common.io.ByteBufferByteSink;
import com.aquenos.epics.jackie.common.io.ByteBufferByteSource;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.io.ChannelProcessor;
import com.aquenos.epics.jackie.common.io.CommunicationController;
import com.aquenos.epics.jackie.common.io.TimerProcessor;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractSocketChannelConnection {
    private int bufferSize;
    private SocketChannel channel;
    private SelectionKey channelSelectionKey;
    private CommunicationController communicationController;
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private ErrorHandler errorHandler;
    private LinkedList<ByteBuffer> freeBuffers = new LinkedList();
    private int maximumNumberOfFreeBuffers;
    private ByteBuffer receiveBuffer;
    private long receiveMaxContiguousBytes = 0L;
    private long receiveBytesNeeded = 0L;
    private ByteBufferByteSource receiveSource = new ByteBufferByteSource(){

        @Override
        protected void release(ByteBuffer buffer) {
            assert (AbstractSocketChannelConnection.this.communicationController.inCommunicationThread());
            AbstractSocketChannelConnection.this.releaseBuffer(buffer);
        }
    };
    private LinkedList<ByteBuffer> sendQueue = new LinkedList();
    private long sendQueueBytes = 0L;
    private ByteBufferByteSink sendSink = new ByteBufferByteSink(){

        @Override
        protected void dataWritten() {
            assert (AbstractSocketChannelConnection.this.communicationController.inCommunicationThread());
            AbstractSocketChannelConnection.this.enableWriteEvent();
        }

        @Override
        protected ByteBuffer requestAdditionalBuffer(int requiredSpaceInBytes) {
            assert (AbstractSocketChannelConnection.this.communicationController.inCommunicationThread());
            return AbstractSocketChannelConnection.this.acquireBuffer();
        }
    };

    public AbstractSocketChannelConnection(SocketChannel channel, CommunicationController communicationController, ErrorHandler errorHandler, int bufferSize, int maximumNumberOfFreeBuffers, long maximumNumberOfContiguousBytesRead) {
        this.bufferSize = bufferSize;
        if (this.bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be greater than or equal to one.");
        }
        this.channel = channel;
        if (this.channel.isBlocking()) {
            throw new IllegalArgumentException("The socket channel must be configured for non-blocking I/O.");
        }
        if (!this.channel.isConnected() && !this.channel.isConnectionPending()) {
            throw new IllegalArgumentException("The channel must be connect or a connection must be pending.");
        }
        this.communicationController = communicationController;
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            throw new NullPointerException();
        }
        this.maximumNumberOfFreeBuffers = maximumNumberOfFreeBuffers;
        if (this.maximumNumberOfFreeBuffers < 0) {
            throw new IllegalArgumentException("Maximum number of free buffers must be greater than or equal to zero.");
        }
        this.receiveMaxContiguousBytes = maximumNumberOfContiguousBytesRead;
        try {
            this.channelSelectionKey = this.communicationController.registerChannel(new ChannelProcessor(){

                @Override
                public void processIO() {
                    AbstractSocketChannelConnection.this.processIO();
                }
            }, this.channel);
        }
        catch (ClosedChannelException e) {
            throw new IllegalArgumentException("The channel must not be closed.", e);
        }
        if (this.communicationController.inCommunicationThread()) {
            this.finishInitialization();
        } else {
            this.communicationController.registerTimer(new TimerProcessor(){

                @Override
                public void processTimer() {
                    AbstractSocketChannelConnection.this.finishInitialization();
                }
            }, 0L);
        }
    }

    private void finishInitialization() {
        if (this.channel.isConnected()) {
            this.onConnect();
        }
        this.channelSelectionKey.interestOps(1);
        if (this.channel.isConnectionPending()) {
            this.enableConnectEvent();
        }
    }

    private ByteBuffer acquireBuffer() {
        ByteBuffer buffer = this.freeBuffers.poll();
        if (buffer != null) {
            return buffer;
        }
        return ByteBuffer.allocateDirect(this.bufferSize);
    }

    private void releaseBuffer(ByteBuffer buffer) {
        if (this.freeBuffers.size() < this.maximumNumberOfFreeBuffers) {
            buffer.clear();
            this.freeBuffers.push(buffer);
        }
    }

    private void enableConnectEvent() {
        this.channelSelectionKey.interestOps(this.channelSelectionKey.interestOps() | 8);
    }

    private void disableConnectEvent() {
        this.channelSelectionKey.interestOps(this.channelSelectionKey.interestOps() & 0xFFFFFFF7);
    }

    private void enableWriteEvent() {
        this.channelSelectionKey.interestOps(this.channelSelectionKey.interestOps() | 4);
    }

    private void disableWriteEvent() {
        this.channelSelectionKey.interestOps(this.channelSelectionKey.interestOps() & 0xFFFFFFFB);
    }

    private void handleIOException(IOException e) {
        if (!(e instanceof SocketException)) {
            this.errorHandler.handleError(this.getClass(), e, "Unexpected I/O exception for socket channel.");
        }
        this.destroy();
    }

    protected void tryReceive() {
        boolean dataReceived;
        assert (this.communicationController.inCommunicationThread());
        if (this.channel.isConnectionPending()) {
            return;
        }
        long totalBytesRead = 0L;
        do {
            int bytesRead;
            dataReceived = false;
            if (this.receiveBuffer == null) {
                this.receiveBuffer = this.acquireBuffer();
            } else if (!this.receiveBuffer.hasRemaining()) {
                this.receiveBuffer.flip();
                this.receiveSource.appendBuffer(this.receiveBuffer);
                this.receiveBuffer = this.acquireBuffer();
            }
            try {
                bytesRead = this.channel.read(this.receiveBuffer);
            }
            catch (IOException e) {
                this.handleIOException(e);
                return;
            }
            if (bytesRead == -1) {
                this.destroy();
                return;
            }
            if (bytesRead != 0) {
                dataReceived = true;
                this.receiveBytesNeeded = this.receiveBytesNeeded < (long)bytesRead ? 0L : (this.receiveBytesNeeded -= (long)bytesRead);
            }
            totalBytesRead = Long.MAX_VALUE - totalBytesRead < (long)bytesRead ? Long.MAX_VALUE : (totalBytesRead += (long)bytesRead);
            if (!dataReceived || this.receiveBytesNeeded != 0L) continue;
            boolean reuseBuffer = this.receiveBuffer.hasRemaining();
            this.receiveBuffer.flip();
            this.receiveSource.appendBuffer(this.receiveBuffer);
            this.receiveBuffer = null;
            this.receiveBytesNeeded = this.onReceive();
            if (this.receiveBytesNeeded < 0L) {
                this.receiveBytesNeeded = 0L;
            }
            if (!reuseBuffer) continue;
            this.receiveBuffer = this.receiveSource.removeLastBuffer();
            if (this.receiveBuffer == null) continue;
            if (this.receiveBuffer.position() != 0) {
                this.receiveBuffer.compact();
                continue;
            }
            this.receiveBuffer.position(this.receiveBuffer.limit());
            this.receiveBuffer.limit(this.receiveBuffer.capacity());
        } while (dataReceived && (this.receiveMaxContiguousBytes <= 0L || this.receiveMaxContiguousBytes > totalBytesRead));
        this.onReceiveFinished(dataReceived);
    }

    protected void trySend() {
        assert (this.communicationController.inCommunicationThread());
        if (this.channel.isConnectionPending()) {
            return;
        }
        long writtenDataBytes = this.sendSink.getWrittenDataSizeInBytes();
        this.sendQueue.addAll(Arrays.asList(this.sendSink.getWrittenData()));
        this.sendQueueBytes = Long.MAX_VALUE - this.sendQueueBytes < writtenDataBytes ? Long.MAX_VALUE : (this.sendQueueBytes += writtenDataBytes);
        if (this.sendQueue.isEmpty()) {
            this.disableWriteEvent();
            return;
        }
        boolean dataWritten = false;
        ByteBuffer sendBuffer = this.sendQueue.poll();
        try {
            int bytesSent;
            do {
                bytesSent = this.channel.write(sendBuffer);
                if (this.sendQueueBytes != Long.MAX_VALUE) {
                    this.sendQueueBytes -= (long)bytesSent;
                }
                if (bytesSent != 0) {
                    dataWritten = true;
                }
                if (sendBuffer.hasRemaining()) continue;
                this.releaseBuffer(sendBuffer);
                sendBuffer = this.sendQueue.poll();
            } while (bytesSent != 0 && sendBuffer != null);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return;
        }
        if (sendBuffer != null) {
            this.sendQueue.push(sendBuffer);
            this.enableWriteEvent();
        } else {
            this.disableWriteEvent();
        }
        ByteBuffer lastBuffer = this.sendQueue.peekLast();
        if (lastBuffer != null && lastBuffer.hasRemaining()) {
            this.sendQueue.removeLast();
            int remainingInBuffer = lastBuffer.remaining();
            if (this.sendQueueBytes != Long.MAX_VALUE) {
                this.sendQueueBytes -= (long)remainingInBuffer;
            }
            if (lastBuffer.position() == 0) {
                lastBuffer.position(lastBuffer.limit());
                lastBuffer.limit(lastBuffer.capacity());
            } else {
                lastBuffer.compact();
            }
            this.sendSink.addBufferFirst(lastBuffer);
        }
        if (dataWritten) {
            this.onSend();
        }
    }

    protected boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected ByteSource getReceiveSource() {
        return this.receiveSource;
    }

    protected ByteSink getSendSink() {
        return this.sendSink;
    }

    protected long getSendQueueSizeInBytes() {
        long sendSinkBytes;
        assert (this.communicationController.inCommunicationThread());
        if (this.sendQueueBytes == Long.MAX_VALUE) {
            this.sendQueueBytes = 0L;
            for (ByteBuffer buffer : this.sendQueue) {
                int remaining = buffer.remaining();
                if (Long.MAX_VALUE - this.sendQueueBytes < (long)remaining) {
                    this.sendQueueBytes = Long.MAX_VALUE;
                    return Long.MAX_VALUE;
                }
                this.sendQueueBytes += (long)remaining;
            }
        }
        if (Long.MAX_VALUE - this.sendQueueBytes < (sendSinkBytes = this.sendSink.getWrittenDataSizeInBytes())) {
            return Long.MAX_VALUE;
        }
        return this.sendQueueBytes + sendSinkBytes;
    }

    protected void onConnect() {
    }

    protected void onDestroy() {
    }

    protected long onReceive() {
        int remaining;
        while ((remaining = this.receiveSource.remaining()) != 0) {
            this.receiveSource.skip(remaining);
        }
        return 0L;
    }

    protected void onReceiveFinished(boolean moreDataAvailable) {
    }

    protected void onSend() {
    }

    private void processIO() {
        try {
            if ((this.channelSelectionKey.interestOps() & 8) != 0) {
                try {
                    if (!this.channel.isConnected() && this.channel.finishConnect()) {
                        this.onConnect();
                    }
                }
                catch (IOException e) {
                    this.handleIOException(e);
                    return;
                }
                if (this.channel.isConnected()) {
                    this.disableConnectEvent();
                }
            }
            if ((this.channelSelectionKey.readyOps() & 4) != 0) {
                this.trySend();
            }
            if ((this.channelSelectionKey.readyOps() & 1) != 0) {
                this.tryReceive();
            }
        }
        catch (CancelledKeyException e) {
            return;
        }
    }

    protected void destroy() {
        if (this.destroyed.get()) {
            return;
        }
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        this.channelSelectionKey.cancel();
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.onDestroy();
    }
}

