/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.io;

import com.aquenos.epics.jackie.common.io.AbstractByteSink;
import com.aquenos.epics.jackie.common.io.ByteSink;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.ListIterator;

public class ByteBufferByteSink
extends AbstractByteSink {
    private static final ValueWriter<byte[]> BYTE_WRITER = new ValueWriter<byte[]>(){

        @Override
        public void writeValues(byte[] source, int sourceOffset, ByteBuffer destination, int numberOfBytes) {
            destination.put(source, sourceOffset, numberOfBytes);
        }
    };
    private static final ValueWriter<double[]> DOUBLE_WRITER = new ValueWriter<double[]>(){

        @Override
        public void writeValues(double[] source, int sourceOffset, ByteBuffer destination, int numberOfBytes) {
            assert (numberOfBytes % 8 == 0);
            int numberOfElements = numberOfBytes / 8;
            destination.asDoubleBuffer().put(source, sourceOffset, numberOfElements);
        }
    };
    private static final ValueWriter<float[]> FLOAT_WRITER = new ValueWriter<float[]>(){

        @Override
        public void writeValues(float[] source, int sourceOffset, ByteBuffer destination, int numberOfBytes) {
            assert (numberOfBytes % 4 == 0);
            int numberOfElements = numberOfBytes / 4;
            destination.asFloatBuffer().put(source, sourceOffset, numberOfElements);
        }
    };
    private static final ValueWriter<int[]> INT_WRITER = new ValueWriter<int[]>(){

        @Override
        public void writeValues(int[] source, int sourceOffset, ByteBuffer destination, int numberOfBytes) {
            assert (numberOfBytes % 4 == 0);
            int numberOfElements = numberOfBytes / 4;
            destination.asIntBuffer().put(source, sourceOffset, numberOfElements);
        }
    };
    private static final ValueWriter<short[]> SHORT_WRITER = new ValueWriter<short[]>(){

        @Override
        public void writeValues(short[] source, int sourceOffset, ByteBuffer destination, int numberOfBytes) {
            assert (numberOfBytes % 2 == 0);
            int numberOfElements = numberOfBytes / 2;
            destination.asShortBuffer().put(source, sourceOffset, numberOfElements);
        }
    };
    private static final ValueWriter<long[]> LONG_WRITER = new ValueWriter<long[]>(){

        @Override
        public void writeValues(long[] source, int sourceOffset, ByteBuffer destination, int numberOfBytes) {
            assert (numberOfBytes % 8 == 0);
            int numberOfElements = numberOfBytes / 8;
            destination.asLongBuffer().put(source, sourceOffset, numberOfElements);
        }
    };
    private LinkedList<ByteBuffer> nextBuffers = new LinkedList();
    private LinkedList<ByteBuffer> fullBuffers = new LinkedList();
    private boolean nextBufferIsDirty = false;
    private boolean atomicWriteInProgress = false;
    private long atomicWriteOffset = 0L;
    private LinkedList<Long> atomicWriteOffsetStack = new LinkedList();
    private long bytesWritten = 0L;

    public ByteBufferByteSink addBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.position() != 0) {
            throw new IllegalArgumentException("The byte buffer's position must be zero.");
        }
        this.nextBuffers.addLast(byteBuffer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBufferByteSink addBuffers(ByteBuffer[] byteBuffers) {
        int count;
        boolean successful = false;
        try {
            for (ByteBuffer byteBuffer : byteBuffers) {
                this.addBuffer(byteBuffer);
                ++count;
            }
            successful = true;
        }
        finally {
            if (!successful) {
                for (count = 0; count > 0; --count) {
                    this.nextBuffers.removeLast();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBufferByteSink addBuffers(Iterable<? extends ByteBuffer> byteBuffers) {
        int count;
        boolean successful = false;
        try {
            for (ByteBuffer byteBuffer : byteBuffers) {
                this.addBuffer(byteBuffer);
                ++count;
            }
            successful = true;
        }
        finally {
            if (!successful) {
                for (count = 0; count > 0; --count) {
                    this.nextBuffers.removeLast();
                }
            }
        }
        return this;
    }

    public void addBufferFirst(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (this.atomicWriteInProgress) {
            throw new IllegalStateException("A buffer cannot be prepended while an atomic put operation is in progress.");
        }
        if (this.getWrittenDataSizeInBytes() != 0L) {
            throw new IllegalStateException("A buffer cannot be prepended when the byte sink is not empty (data has already been written to the byte sink but not removed).");
        }
        this.nextBuffers.addFirst(byteBuffer);
        if (byteBuffer.position() != 0) {
            this.nextBufferIsDirty = true;
            this.bytesWritten += (long)byteBuffer.position();
        }
    }

    public ByteBuffer[] getWrittenData() {
        if (this.atomicWriteInProgress) {
            throw new IllegalStateException("This method must not be called while an atomic put operation is in progress.");
        }
        ByteBuffer[] result = new ByteBuffer[this.fullBuffers.size() + (this.nextBufferIsDirty ? 1 : 0)];
        int resultIndex = 0;
        for (ByteBuffer byteBuffer : this.fullBuffers) {
            byteBuffer.flip();
            result[resultIndex] = byteBuffer;
            ++resultIndex;
        }
        this.fullBuffers.clear();
        if (this.nextBufferIsDirty) {
            ByteBuffer nextBuffer = this.nextBuffers.pop();
            nextBuffer.flip();
            result[resultIndex] = nextBuffer;
            ++resultIndex;
            this.nextBufferIsDirty = false;
        }
        this.bytesWritten = 0L;
        return result;
    }

    public long getWrittenDataSizeInBytes() {
        return this.bytesWritten + this.atomicWriteOffset;
    }

    protected ByteBuffer requestAdditionalBuffer(int requiredSpaceInBytes) {
        return null;
    }

    private <T> void writeValues(int numberOfValues, int elementSize, T source, int sourceOffset, ValueWriter<T> valueWriter) {
        assert (numberOfValues >= 0);
        assert (sourceOffset >= 0);
        long bytesToBeWritten = (long)numberOfValues * (long)elementSize;
        if (Long.MAX_VALUE - this.atomicWriteOffset - this.bytesWritten < bytesToBeWritten) {
            throw new BufferOverflowException();
        }
        assert (elementSize >= 1);
        this.writeValuesInternal(this.atomicWriteOffset, numberOfValues, elementSize, source, sourceOffset, valueWriter);
        if (this.atomicWriteInProgress) {
            this.atomicWriteOffset += bytesToBeWritten;
        } else {
            this.commit(bytesToBeWritten);
        }
    }

    private <T> void writeValuesInternal(long offset, int numberOfValues, int elementSize, T source, int sourceOffset, ValueWriter<T> valueWriter) {
        ByteBuffer buffer;
        assert (offset >= 0L);
        assert (numberOfValues >= 0);
        assert (elementSize >= 1);
        assert (sourceOffset >= 0);
        long remainingOffset = offset;
        long remainingLength = (long)numberOfValues * (long)elementSize;
        Buffer temporaryBuffer = null;
        ListIterator<ByteBuffer> nextBuffersIterator = this.nextBuffers.listIterator();
        while ((buffer = this.bufferFromIteratorOrNewBuffer(nextBuffersIterator, remainingLength)) != null) {
            int remainingInBuffer = buffer.remaining();
            if (remainingInBuffer == 0) continue;
            if ((long)remainingInBuffer <= remainingOffset) {
                remainingOffset -= (long)remainingInBuffer;
                continue;
            }
            int remainingUsableBytesInBuffer = remainingInBuffer - (int)remainingOffset;
            int remainingDataInTemporaryBuffer = 0;
            if (temporaryBuffer != null) {
                remainingDataInTemporaryBuffer = temporaryBuffer.remaining();
            }
            if (remainingDataInTemporaryBuffer != 0) {
                int bytesToCopy = Math.min(remainingDataInTemporaryBuffer, remainingInBuffer - (int)remainingOffset);
                this.copyBytes((ByteBuffer)temporaryBuffer, buffer, buffer.position() + (int)remainingOffset, bytesToCopy);
                remainingOffset += (long)bytesToCopy;
                remainingLength -= (long)bytesToCopy;
                remainingUsableBytesInBuffer -= bytesToCopy;
                remainingDataInTemporaryBuffer -= bytesToCopy;
            }
            if (remainingLength == 0L) break;
            if (remainingUsableBytesInBuffer >= elementSize) {
                int numberOfElementsToWrite = (int)Math.min(remainingLength, (long)remainingUsableBytesInBuffer) / elementSize;
                int numberOfBytesToWrite = numberOfElementsToWrite * elementSize;
                ByteBuffer positionedBuffer = buffer.duplicate();
                positionedBuffer.position(positionedBuffer.position() + (int)remainingOffset);
                valueWriter.writeValues(source, sourceOffset, positionedBuffer, numberOfBytesToWrite);
                sourceOffset += numberOfElementsToWrite;
                remainingOffset += (long)numberOfBytesToWrite;
                remainingLength -= (long)numberOfBytesToWrite;
                remainingUsableBytesInBuffer -= numberOfBytesToWrite;
            }
            if (remainingLength == 0L) break;
            if (remainingUsableBytesInBuffer != 0) {
                assert (remainingDataInTemporaryBuffer == 0);
                if (temporaryBuffer == null) {
                    temporaryBuffer = ByteBuffer.allocate(elementSize).order(buffer.order());
                } else {
                    ((ByteBuffer)temporaryBuffer).clear();
                }
                valueWriter.writeValues(source, sourceOffset, (ByteBuffer)temporaryBuffer, elementSize);
                ++sourceOffset;
                ((ByteBuffer)temporaryBuffer).position(elementSize);
                ((ByteBuffer)temporaryBuffer).flip();
                remainingDataInTemporaryBuffer = elementSize;
                this.copyBytes((ByteBuffer)temporaryBuffer, buffer, buffer.position() + (int)remainingOffset, remainingUsableBytesInBuffer);
                remainingOffset += (long)remainingUsableBytesInBuffer;
                remainingLength -= (long)remainingUsableBytesInBuffer;
                remainingDataInTemporaryBuffer -= remainingUsableBytesInBuffer;
                remainingUsableBytesInBuffer = 0;
            }
            if (remainingLength == 0L) break;
            remainingOffset = 0L;
        }
        if (remainingLength != 0L) {
            throw new BufferOverflowException();
        }
    }

    private ByteBuffer bufferFromIteratorOrNewBuffer(ListIterator<ByteBuffer> iterator, long requiredSpaceInBytes) {
        ByteBuffer buffer;
        while (iterator.hasNext()) {
            buffer = iterator.next();
            if (buffer == null) continue;
            return buffer;
        }
        buffer = this.requestAdditionalBuffer(requiredSpaceInBytes > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)requiredSpaceInBytes);
        if (buffer != null) {
            if (buffer.position() != 0) {
                return null;
            }
            iterator.add(buffer);
        }
        return buffer;
    }

    private void copyBytes(ByteBuffer sourceBuffer, ByteBuffer destinationBuffer, int positionInDestinationBuffer, int numberOfBytes) {
        assert (destinationBuffer.remaining() >= numberOfBytes);
        assert (sourceBuffer.remaining() >= numberOfBytes);
        ByteBuffer duplicatedDestinationBuffer = destinationBuffer.duplicate();
        duplicatedDestinationBuffer.position(positionInDestinationBuffer);
        ByteBuffer duplicatedSourceBuffer = sourceBuffer.duplicate();
        int sourceBufferPosition = duplicatedSourceBuffer.position();
        duplicatedSourceBuffer.position(sourceBufferPosition + numberOfBytes);
        duplicatedSourceBuffer.flip();
        duplicatedSourceBuffer.position(sourceBufferPosition);
        duplicatedDestinationBuffer.put(duplicatedSourceBuffer);
        sourceBuffer.position(sourceBufferPosition + numberOfBytes);
    }

    protected void dataWritten() {
    }

    private void commit(long length) {
        if (length <= 0L) {
            return;
        }
        long remainingLength = length;
        while (remainingLength > 0L) {
            ByteBuffer nextBuffer = this.nextBuffers.peek();
            int remainingInNextBuffer = nextBuffer.remaining();
            if ((long)remainingInNextBuffer > remainingLength) {
                nextBuffer.position(nextBuffer.position() + (int)remainingLength);
                this.bytesWritten += remainingLength;
                this.nextBufferIsDirty = true;
                this.dataWritten();
                return;
            }
            nextBuffer.position(nextBuffer.position() + remainingInNextBuffer);
            this.fullBuffers.addLast(this.nextBuffers.pop());
            remainingLength -= (long)remainingInNextBuffer;
            this.bytesWritten += (long)remainingInNextBuffer;
            this.nextBufferIsDirty = false;
        }
        this.dataWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T atomicPut(ByteSink.AtomicPutOperation<? extends T> atomicPutOperation) {
        if (this.atomicWriteInProgress) {
            this.atomicWriteOffsetStack.push(this.atomicWriteOffset);
        } else {
            this.atomicWriteInProgress = true;
        }
        boolean successful = false;
        try {
            T result = atomicPutOperation.put();
            successful = true;
            T t = result;
            return t;
        }
        finally {
            if (successful) {
                if (this.atomicWriteOffsetStack.isEmpty()) {
                    this.commit(this.atomicWriteOffset);
                    this.atomicWriteOffset = 0L;
                    this.atomicWriteInProgress = false;
                } else {
                    this.atomicWriteOffsetStack.pop();
                }
            } else if (this.atomicWriteOffsetStack.isEmpty()) {
                this.atomicWriteOffset = 0L;
                this.atomicWriteInProgress = false;
            } else {
                this.atomicWriteOffset = this.atomicWriteOffsetStack.pop();
            }
        }
    }

    private void checkSourceArrayLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be negative.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative.");
        }
        if ((long)offset + (long)length > (long)arrayLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public ByteBufferByteSink putByteArray(byte[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        this.writeValues(length, 1, source, offset, BYTE_WRITER);
        return this;
    }

    @Override
    public ByteSink putDoubleArray(double[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        this.writeValues(length, 8, source, offset, DOUBLE_WRITER);
        return this;
    }

    @Override
    public ByteSink putFloatArray(float[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        this.writeValues(length, 4, source, offset, FLOAT_WRITER);
        return this;
    }

    @Override
    public ByteSink putIntArray(int[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        this.writeValues(length, 4, source, offset, INT_WRITER);
        return this;
    }

    @Override
    public ByteSink putShortArray(short[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        this.writeValues(length, 2, source, offset, SHORT_WRITER);
        return this;
    }

    @Override
    public ByteSink putLongArray(long[] source, int offset, int length) {
        this.checkSourceArrayLength(source.length, offset, length);
        this.writeValues(length, 8, source, offset, LONG_WRITER);
        return this;
    }

    private static void addByteToStringBuilder(StringBuilder sb, byte b) {
        sb.append("0x");
        if (b < 16 && b >= 0) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b & 0xFF));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[");
        int sizeRead = 0;
        int sizeToReadFromNextBuffers = 0;
        int sizeToReadFromFullBuffers = 1024;
        if (this.atomicWriteInProgress) {
            if (this.atomicWriteOffset > (long)sizeToReadFromFullBuffers) {
                sizeToReadFromNextBuffers = sizeToReadFromFullBuffers;
                sizeToReadFromFullBuffers = 0;
            } else {
                sizeToReadFromNextBuffers = (int)this.atomicWriteOffset;
                sizeToReadFromFullBuffers = (int)((long)sizeToReadFromFullBuffers - this.atomicWriteOffset);
            }
        }
        if (sizeToReadFromFullBuffers > 0) {
            LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
            int sizeFound = 0;
            ByteBuffer buffer = this.nextBuffers.peek();
            if (buffer != null) {
                buffer = buffer.duplicate();
                buffer.flip();
                buffers.push(buffer);
                sizeFound += buffer.remaining();
            }
            ListIterator<ByteBuffer> bufferIterator = this.fullBuffers.listIterator(this.fullBuffers.size());
            while (bufferIterator.hasPrevious() && sizeFound <= sizeToReadFromFullBuffers) {
                buffer = bufferIterator.previous();
                buffer = buffer.duplicate();
                buffer.flip();
                buffers.push(buffer);
                sizeFound += buffer.remaining();
            }
            if (sizeFound > sizeToReadFromFullBuffers) {
                sb.append("..., ");
                buffer = (ByteBuffer)buffers.peek();
                buffer.position(buffer.position() + (sizeFound - sizeToReadFromFullBuffers));
            }
            for (ByteBuffer fullBuffer : buffers) {
                while (fullBuffer.hasRemaining()) {
                    ByteBufferByteSink.addByteToStringBuilder(sb, fullBuffer.get());
                    sb.append(", ");
                    ++sizeRead;
                }
            }
        }
        if (sizeToReadFromNextBuffers > 0) {
            int sizeReadFromNextBuffers = 0;
            for (ByteBuffer buffer : this.nextBuffers) {
                if (sizeReadFromNextBuffers == sizeToReadFromNextBuffers) break;
                buffer = buffer.duplicate();
                while (buffer.hasRemaining() && sizeReadFromNextBuffers < sizeToReadFromNextBuffers) {
                    ByteBufferByteSink.addByteToStringBuilder(sb, buffer.get());
                    sb.append(", ");
                    ++sizeReadFromNextBuffers;
                }
            }
            sizeRead += sizeReadFromNextBuffers;
        }
        if (sizeRead > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }

    private static interface ValueWriter<T> {
        public void writeValues(T var1, int var2, ByteBuffer var3, int var4);
    }
}

