/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.io;

import com.aquenos.epics.jackie.common.io.AbstractByteSource;
import com.aquenos.epics.jackie.common.io.ByteSource;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedList;

public class ByteBufferByteSource
extends AbstractByteSource {
    private static final ValueReader<byte[]> BYTE_READER = new ValueReader<byte[]>(){

        @Override
        public void readValues(byte[] destination, int destinationOffset, ByteBuffer source, int numberOfBytes) {
            assert (destination.length >= destinationOffset + numberOfBytes);
            assert (source.remaining() >= numberOfBytes);
            source.get(destination, destinationOffset, numberOfBytes);
        }
    };
    private static final ValueReader<double[]> DOUBLE_READER = new ValueReader<double[]>(){

        @Override
        public void readValues(double[] destination, int destinationOffset, ByteBuffer source, int numberOfBytes) {
            int numberOfElements = numberOfBytes / 8;
            assert (destination.length >= destinationOffset + numberOfElements);
            assert (source.remaining() >= numberOfBytes);
            DoubleBuffer typedBuffer = source.asDoubleBuffer();
            typedBuffer.get(destination, destinationOffset, numberOfElements);
        }
    };
    private static final ValueReader<float[]> FLOAT_READER = new ValueReader<float[]>(){

        @Override
        public void readValues(float[] destination, int destinationOffset, ByteBuffer source, int numberOfBytes) {
            int numberOfElements = numberOfBytes / 4;
            assert (destination.length >= destinationOffset + numberOfElements);
            assert (source.remaining() >= numberOfBytes);
            FloatBuffer typedBuffer = source.asFloatBuffer();
            typedBuffer.get(destination, destinationOffset, numberOfElements);
        }
    };
    private static final ValueReader<int[]> INT_READER = new ValueReader<int[]>(){

        @Override
        public void readValues(int[] destination, int destinationOffset, ByteBuffer source, int numberOfBytes) {
            int numberOfElements = numberOfBytes / 4;
            assert (destination.length >= destinationOffset + numberOfElements);
            assert (source.remaining() >= numberOfBytes);
            IntBuffer typedBuffer = source.asIntBuffer();
            typedBuffer.get(destination, destinationOffset, numberOfElements);
        }
    };
    private static final ValueReader<long[]> LONG_READER = new ValueReader<long[]>(){

        @Override
        public void readValues(long[] destination, int destinationOffset, ByteBuffer source, int numberOfBytes) {
            int numberOfElements = numberOfBytes / 8;
            assert (destination.length >= destinationOffset + numberOfElements);
            assert (source.remaining() >= numberOfBytes);
            LongBuffer typedBuffer = source.asLongBuffer();
            typedBuffer.get(destination, destinationOffset, numberOfElements);
        }
    };
    private static final ValueReader<short[]> SHORT_READER = new ValueReader<short[]>(){

        @Override
        public void readValues(short[] destination, int destinationOffset, ByteBuffer source, int numberOfBytes) {
            int numberOfElements = numberOfBytes / 2;
            assert (destination.length >= destinationOffset + numberOfElements);
            assert (source.remaining() >= numberOfBytes);
            ShortBuffer typedBuffer = source.asShortBuffer();
            typedBuffer.get(destination, destinationOffset, numberOfElements);
        }
    };
    private LinkedList<ByteBuffer> nextBuffers = new LinkedList();
    private long remainingBytes = 0L;
    private boolean atomicReadInProgress = false;
    private long atomicReadOffset = 0L;
    private LinkedList<Long> atomicReadOffsetStack = new LinkedList();

    protected void release(ByteBuffer buffer) {
    }

    public ByteBufferByteSource appendBuffer(ByteBuffer buffer) {
        this.nextBuffers.addLast(buffer);
        int remainingInBuffer = buffer.remaining();
        if (Long.MAX_VALUE - (long)remainingInBuffer < this.remainingBytes) {
            throw new IllegalStateException("This byte source already contains " + this.remainingBytes + " bytes. Adding a buffer with " + remainingInBuffer + " would push it over the limit of " + Long.MAX_VALUE + " bytes.");
        }
        this.remainingBytes += (long)remainingInBuffer;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBufferByteSource appendBuffers(ByteBuffer[] buffers) {
        int count;
        boolean successful = false;
        try {
            for (ByteBuffer buffer : buffers) {
                this.appendBuffer(buffer);
                ++count;
            }
            successful = true;
        }
        finally {
            if (!successful) {
                for (count = 0; count > 0; --count) {
                    this.nextBuffers.removeLast();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBufferByteSource appendBuffers(Iterable<? extends ByteBuffer> buffers) {
        int count;
        boolean successful = false;
        try {
            for (ByteBuffer byteBuffer : buffers) {
                this.appendBuffer(byteBuffer);
                ++count;
            }
            successful = true;
        }
        finally {
            if (!successful) {
                for (count = 0; count > 0; --count) {
                    this.nextBuffers.removeLast();
                }
            }
        }
        return this;
    }

    public ByteBuffer removeLastBuffer() {
        if (this.atomicReadInProgress) {
            throw new IllegalStateException("Removing a buffer is not allowed while an atomic read operation is in progress.");
        }
        if (this.nextBuffers.isEmpty()) {
            return null;
        }
        ByteBuffer buffer = this.nextBuffers.removeLast();
        this.remainingBytes -= (long)buffer.remaining();
        return buffer;
    }

    private <T> void readValues(int numberOfValues, int elementSize, T destination, int destinationOffset, ValueReader<T> valueReader) {
        assert (numberOfValues >= 0);
        if (numberOfValues == 0) {
            return;
        }
        long lengthInBytes = (long)numberOfValues * (long)elementSize;
        long effectiveRemainingBytes = this.remainingBytes - this.atomicReadOffset;
        if (lengthInBytes > effectiveRemainingBytes) {
            throw new BufferUnderflowException();
        }
        assert (elementSize >= 1);
        this.readValuesInternal(this.atomicReadOffset, numberOfValues, elementSize, destination, destinationOffset, valueReader);
        if (this.atomicReadInProgress) {
            this.atomicReadOffset += (long)(numberOfValues * elementSize);
        } else {
            this.skipInternal(numberOfValues * elementSize);
        }
    }

    private <T> void readValuesInternal(long offset, int numberOfValues, int elementSize, T destination, int destinationOffset, ValueReader<T> valueReader) {
        assert (offset >= 0L);
        assert (numberOfValues >= 0);
        assert (elementSize >= 1);
        assert (destinationOffset >= 0);
        long remainingOffset = offset;
        long remainingLength = (long)numberOfValues * (long)elementSize;
        Buffer temporaryBuffer = null;
        for (ByteBuffer buffer : this.nextBuffers) {
            int remainingInBuffer = buffer.remaining();
            if (remainingInBuffer == 0) continue;
            if ((long)remainingInBuffer <= remainingOffset) {
                remainingOffset -= (long)remainingInBuffer;
                continue;
            }
            int remainingSpaceInTemporaryBuffer = elementSize;
            if (temporaryBuffer != null) {
                remainingSpaceInTemporaryBuffer = temporaryBuffer.remaining();
            }
            int remainingUsableBytesInBuffer = remainingInBuffer - (int)remainingOffset;
            if (remainingSpaceInTemporaryBuffer != elementSize) {
                int bytesToCopy = Math.min(remainingSpaceInTemporaryBuffer, remainingUsableBytesInBuffer);
                this.copyBytes(buffer, buffer.position() + (int)remainingOffset, (ByteBuffer)temporaryBuffer, bytesToCopy);
                remainingOffset += (long)bytesToCopy;
                remainingLength -= (long)bytesToCopy;
                remainingUsableBytesInBuffer -= bytesToCopy;
                if ((remainingSpaceInTemporaryBuffer -= bytesToCopy) == 0) {
                    ((ByteBuffer)temporaryBuffer).flip();
                    valueReader.readValues(destination, destinationOffset, (ByteBuffer)temporaryBuffer, elementSize);
                    ++destinationOffset;
                    ((ByteBuffer)temporaryBuffer).clear();
                    remainingSpaceInTemporaryBuffer = temporaryBuffer.remaining();
                }
            }
            if (remainingLength == 0L) {
                return;
            }
            if (remainingUsableBytesInBuffer >= elementSize) {
                int numberOfElementsToRead = (int)Math.min(remainingLength, (long)remainingUsableBytesInBuffer) / elementSize;
                int numberOfBytesToRead = numberOfElementsToRead * elementSize;
                ByteBuffer positionedBuffer = buffer.duplicate();
                positionedBuffer.position(positionedBuffer.position() + (int)remainingOffset);
                valueReader.readValues(destination, destinationOffset, positionedBuffer, numberOfBytesToRead);
                destinationOffset += numberOfElementsToRead;
                remainingOffset += (long)numberOfBytesToRead;
                remainingLength -= (long)numberOfBytesToRead;
                remainingUsableBytesInBuffer -= numberOfBytesToRead;
            }
            if (remainingLength == 0L) {
                return;
            }
            if (remainingUsableBytesInBuffer != 0) {
                assert (remainingSpaceInTemporaryBuffer == elementSize);
                if (temporaryBuffer == null) {
                    temporaryBuffer = ByteBuffer.allocate(elementSize).order(buffer.order());
                }
                this.copyBytes(buffer, buffer.position() + (int)remainingOffset, (ByteBuffer)temporaryBuffer, remainingUsableBytesInBuffer);
                remainingOffset += (long)remainingUsableBytesInBuffer;
                remainingLength -= (long)remainingUsableBytesInBuffer;
                remainingSpaceInTemporaryBuffer -= remainingUsableBytesInBuffer;
                remainingUsableBytesInBuffer = 0;
            }
            if (remainingLength == 0L) {
                return;
            }
            remainingOffset = 0L;
        }
        throw new BufferUnderflowException();
    }

    private void copyBytes(ByteBuffer sourceBuffer, int positionInSourceBuffer, ByteBuffer destinationBuffer, int numberOfBytes) {
        ByteBuffer duplicatedSourceBuffer = sourceBuffer.duplicate();
        duplicatedSourceBuffer.position(positionInSourceBuffer + numberOfBytes);
        duplicatedSourceBuffer.flip();
        duplicatedSourceBuffer.position(positionInSourceBuffer);
        destinationBuffer.put(duplicatedSourceBuffer);
    }

    @Override
    public ByteBufferByteSource skip(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative.");
        }
        long effectiveRemainingBytes = this.remainingBytes - this.atomicReadOffset;
        if ((long)length > effectiveRemainingBytes) {
            throw new BufferUnderflowException();
        }
        if (this.atomicReadInProgress) {
            this.atomicReadOffset += (long)length;
        } else {
            this.skipInternal(length);
        }
        return this;
    }

    private void skipInternal(long length) {
        int remainingInNextBuffer;
        assert (this.remainingBytes >= length);
        this.remainingBytes -= length;
        for (long remainingLength = length; remainingLength > 0L; remainingLength -= (long)remainingInNextBuffer) {
            ByteBuffer nextBuffer = this.nextBuffers.peek();
            remainingInNextBuffer = nextBuffer.remaining();
            if ((long)remainingInNextBuffer > remainingLength) {
                nextBuffer.position(nextBuffer.position() + (int)remainingLength);
                return;
            }
            nextBuffer.position(nextBuffer.position() + remainingInNextBuffer);
            this.release(this.nextBuffers.pop());
        }
        while (!this.nextBuffers.isEmpty() && !this.nextBuffers.peek().hasRemaining()) {
            this.release(this.nextBuffers.pop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T atomicGet(ByteSource.AtomicGetOperation<T> atomicGetOperation) {
        if (this.atomicReadInProgress) {
            this.atomicReadOffsetStack.push(this.atomicReadOffset);
        } else {
            this.atomicReadInProgress = true;
        }
        boolean successful = false;
        try {
            T result = atomicGetOperation.get();
            successful = true;
            T t = result;
            return t;
        }
        finally {
            if (successful) {
                if (this.atomicReadOffsetStack.isEmpty()) {
                    this.skipInternal(this.atomicReadOffset);
                    this.atomicReadOffset = 0L;
                    this.atomicReadInProgress = false;
                } else {
                    this.atomicReadOffsetStack.pop();
                }
            } else if (this.atomicReadOffsetStack.isEmpty()) {
                this.atomicReadOffset = 0L;
                this.atomicReadInProgress = false;
            } else {
                this.atomicReadOffset = this.atomicReadOffsetStack.pop();
            }
        }
    }

    @Override
    public int remaining() {
        long effectiveRemainingBytes = this.remainingBytes - this.atomicReadOffset;
        if (effectiveRemainingBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)effectiveRemainingBytes;
    }

    private void checkDestinationArraySize(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be negative.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative.");
        }
        if ((long)offset + (long)length > (long)arrayLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public ByteBufferByteSource getByteArray(byte[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        this.readValues(length, 1, destination, offset, BYTE_READER);
        return this;
    }

    @Override
    public ByteBufferByteSource getDoubleArray(double[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        this.readValues(length, 8, destination, offset, DOUBLE_READER);
        return this;
    }

    @Override
    public ByteBufferByteSource getFloatArray(float[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        this.readValues(length, 4, destination, offset, FLOAT_READER);
        return this;
    }

    @Override
    public ByteBufferByteSource getIntArray(int[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        this.readValues(length, 4, destination, offset, INT_READER);
        return this;
    }

    @Override
    public ByteBufferByteSource getLongArray(long[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        this.readValues(length, 8, destination, offset, LONG_READER);
        return this;
    }

    @Override
    public ByteBufferByteSource getShortArray(short[] destination, int offset, int length) {
        this.checkDestinationArraySize(destination.length, offset, length);
        this.readValues(length, 2, destination, offset, SHORT_READER);
        return this;
    }

    private static interface ValueReader<T> {
        public void readValues(T var1, int var2, ByteBuffer var3, int var4);
    }
}

