/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.io;

import com.aquenos.epics.jackie.common.io.ChannelProcessor;
import com.aquenos.epics.jackie.common.io.CommunicationController;
import com.aquenos.epics.jackie.common.io.TimerProcessor;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleCommunicationController
implements CommunicationController {
    private static final Object DUMMY_OBJECT = new Object();
    private final Object channelRegistrationLock = new Object();
    private ThreadLocal<Object> inControllerThread = new ThreadLocal();
    private ConcurrentLinkedQueue<TimerEvent> newTimerQueue = new ConcurrentLinkedQueue();
    private Selector selector;
    private PriorityQueue<TimerEvent> timerQueue = new PriorityQueue<TimerEvent>(11, new Comparator<TimerEvent>(){

        @Override
        public int compare(TimerEvent event1, TimerEvent event2) {
            if (event1.eventTime > event2.eventTime) {
                return 1;
            }
            if (event1.eventTime < event2.eventTime) {
                return -1;
            }
            return 0;
        }
    });

    public SimpleCommunicationController() throws IOException {
        this(SelectorProvider.provider());
    }

    public SimpleCommunicationController(SelectorProvider selectorProvider) throws IOException {
        this.inControllerThread = new ThreadLocal();
        this.selector = selectorProvider.openSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimersAndIO() throws IOException {
        this.inControllerThread.set(DUMMY_OBJECT);
        try {
            this.addNewTimerEvents();
            long waitTime = this.processTimerEvents();
            Object object = this.channelRegistrationLock;
            synchronized (object) {
            }
            this.selector.select(waitTime);
            IdentityHashMap seenProcessors = new IdentityHashMap();
            Iterator<SelectionKey> selectionKeyIterator = this.selector.selectedKeys().iterator();
            while (selectionKeyIterator.hasNext()) {
                SelectionKey selectionKey = selectionKeyIterator.next();
                ChannelProcessor processor = (ChannelProcessor)selectionKey.attachment();
                selectionKeyIterator.remove();
                if (seenProcessors.containsKey(processor)) continue;
                seenProcessors.put(processor, null);
                processor.processIO();
            }
        }
        finally {
            this.inControllerThread.remove();
        }
    }

    private void addNewTimerEvents() {
        TimerEvent event;
        while ((event = this.newTimerQueue.poll()) != null) {
            this.timerQueue.add(event);
        }
    }

    private long processTimerEvents() {
        TimerEvent nextEvent;
        IdentityHashMap seenProcessors = new IdentityHashMap();
        long currentTime = System.currentTimeMillis();
        while ((nextEvent = this.timerQueue.poll()) != null) {
            if (currentTime >= nextEvent.getEventTime()) {
                TimerProcessor processor = nextEvent.getProcessor();
                if (seenProcessors.containsKey(processor)) continue;
                seenProcessors.put(processor, null);
                processor.processTimer();
                continue;
            }
            this.timerQueue.add(nextEvent);
            currentTime = System.currentTimeMillis();
            seenProcessors.clear();
            long nextEventTime = nextEvent.getEventTime();
            if (currentTime >= nextEventTime) continue;
            return nextEventTime - currentTime;
        }
        return 0L;
    }

    public void wakeUp() {
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectionKey registerChannel(ChannelProcessor channelProcessor, SelectableChannel channel) throws ClosedChannelException {
        if (channelProcessor == null) {
            throw new NullPointerException();
        }
        if (this.inCommunicationThread()) {
            return new WrappingSelectionKey(channel.register(this.selector, 0, channelProcessor));
        }
        Object object = this.channelRegistrationLock;
        synchronized (object) {
            this.selector.wakeup();
            return new WrappingSelectionKey(channel.register(this.selector, 0, channelProcessor));
        }
    }

    @Override
    public void registerTimer(TimerProcessor timerProcessor, long eventTime) {
        if (timerProcessor == null) {
            throw new NullPointerException();
        }
        this.newTimerQueue.add(new TimerEvent(eventTime, timerProcessor));
        this.selector.wakeup();
    }

    @Override
    public boolean inCommunicationThread() {
        return this.inControllerThread.get() != null;
    }

    private static class WrappingSelectionKey
    extends SelectionKey {
        private SelectionKey wrappedSelectionKey;

        private WrappingSelectionKey(SelectionKey wrappedSelectionKey) {
            this.wrappedSelectionKey = wrappedSelectionKey;
        }

        @Override
        public SelectableChannel channel() {
            return this.wrappedSelectionKey.channel();
        }

        @Override
        public Selector selector() {
            throw new UnsupportedOperationException("The selector() method may not be called for this type of selection key.");
        }

        @Override
        public boolean isValid() {
            return this.wrappedSelectionKey.isValid();
        }

        @Override
        public void cancel() {
            this.wrappedSelectionKey.cancel();
        }

        @Override
        public int interestOps() {
            return this.wrappedSelectionKey.interestOps();
        }

        @Override
        public SelectionKey interestOps(int ops) {
            this.wrappedSelectionKey.interestOps(ops);
            return this;
        }

        @Override
        public int readyOps() {
            return this.wrappedSelectionKey.readyOps();
        }
    }

    private static class TimerEvent {
        private long eventTime;
        private TimerProcessor processor;

        private TimerEvent(long eventTime, TimerProcessor processor) {
            this.eventTime = eventTime;
            this.processor = processor;
        }

        public long getEventTime() {
            return this.eventTime;
        }

        public TimerProcessor getProcessor() {
            return this.processor;
        }
    }
}

