/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.UnsupportedInThisVersionException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessAccessRightsMessage
extends ChannelAccessMessage {
    private static final int ACCESS_RIGHT_READ = 1;
    private static final int ACCESS_RIGHT_WRITE = 2;
    private int cid;
    private boolean mayRead;
    private boolean mayWrite;

    public ChannelAccessAccessRightsMessage(int cid, boolean mayRead, boolean mayWrite) {
        super(ChannelAccessCommand.CA_PROTO_ACCESS_RIGHTS);
        this.cid = cid;
        this.mayRead = mayRead;
        this.mayWrite = mayWrite;
    }

    private ChannelAccessAccessRightsMessage(ChannelAccessMessageHeader messageHeader, int channelCID, boolean mayRead, boolean mayWrite) {
        super(ChannelAccessCommand.CA_PROTO_ACCESS_RIGHTS, messageHeader);
        this.cid = channelCID;
        this.mayRead = mayRead;
        this.mayWrite = mayWrite;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public boolean isMayRead() {
        return this.mayRead;
    }

    public boolean isMayWrite() {
        return this.mayWrite;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_1)) {
            throw new UnsupportedInThisVersionException(version, ChannelAccessCommand.CA_PROTO_ACCESS_RIGHTS);
        }
        int accessRights = 0;
        if (this.mayRead) {
            accessRights |= 1;
        }
        if (this.mayWrite) {
            accessRights |= 2;
        }
        this.serializeHeader(byteSink, 0, (short)0, 0, this.cid, accessRights, version, maxPayloadSize);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_1)) {
            throw new UnsupportedInThisVersionException(version, ChannelAccessCommand.CA_PROTO_ACCESS_RIGHTS);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessAccessRightsMessage other = (ChannelAccessAccessRightsMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append(this.mayRead, other.mayRead).append(this.mayWrite, other.mayWrite).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append(this.mayRead).append(this.mayWrite).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", mayRead=");
        sb.append(this.mayRead);
        sb.append(", mayWrite=");
        sb.append(this.mayWrite);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessAccessRightsMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_ACCESS_RIGHTS.getCommandNumber());
        byteSource.skip(messageHeader.getPayloadSize());
        int accessRights = messageHeader.getContextSpecific();
        boolean mayRead = (accessRights & 1) != 0;
        boolean mayWrite = (accessRights & 2) != 0;
        return new ChannelAccessAccessRightsMessage(messageHeader, messageHeader.getCID(), mayRead, mayWrite);
    }
}

