/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.Inet4AddressUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessBeaconMessage
extends ChannelAccessMessage {
    private Inet4Address serverAddress;
    private int serverPort;
    private ChannelAccessVersion version;
    private int sequenceNumber;

    public ChannelAccessBeaconMessage(Inet4Address serverAddress, int serverPort, ChannelAccessVersion version, int sequenceNumber) {
        super(ChannelAccessCommand.CA_PROTO_RSRV_IS_UP);
        if (serverAddress == null) {
            throw new NullPointerException("The server address must not be null.");
        }
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.version = version;
        this.sequenceNumber = sequenceNumber;
    }

    private ChannelAccessBeaconMessage(ChannelAccessMessageHeader messageHeader, Inet4Address serverAddress, int serverPort, ChannelAccessVersion version, int sequenceNumber) {
        super(ChannelAccessCommand.CA_PROTO_RSRV_IS_UP);
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.version = version;
        this.sequenceNumber = sequenceNumber;
    }

    public Inet4Address getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ChannelAccessVersion getVersion() {
        return this.version;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        this.serializeHeader(byteSink, 0, this.version.getMinorVersionAsShort(), this.serverPort, this.sequenceNumber, Inet4AddressUtil.addressToInt(this.serverAddress.getAddress()), version, maxPayloadSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessBeaconMessage other = (ChannelAccessBeaconMessage)obj;
        return new EqualsBuilder().append((Object)this.serverAddress, (Object)other.serverAddress).append(this.serverPort, other.serverPort).append((Object)this.version, (Object)other.version).append(this.sequenceNumber, other.sequenceNumber).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.serverAddress).append(this.serverPort).append((Object)this.version).append(this.sequenceNumber).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("serverAddress=");
        sb.append(this.serverAddress != null ? this.serverAddress.getHostAddress() : "null");
        sb.append(", serverPort=");
        sb.append(this.serverPort);
        sb.append(", version=");
        sb.append(this.version.toString());
        sb.append(", sequenceNumber=");
        sb.append(this.sequenceNumber);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessBeaconMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, Inet4Address originAddress) {
        Inet4Address serverAddress;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_RSRV_IS_UP.getCommandNumber());
        try {
            byteSource.skip(messageHeader.getPayloadSize());
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            InetAddress tempAddress = InetAddress.getByAddress(Inet4AddressUtil.addressToBytes(messageHeader.getContextSpecific()));
            if (!(tempAddress instanceof Inet4Address)) {
                throw new RuntimeException("Did not get IPv4 address where it was expected. Got address of type " + tempAddress.getClass().getName() + " instead.");
            }
            serverAddress = (Inet4Address)tempAddress;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot get inet address instance for address of four bytes.", e);
        }
        if (serverAddress.isAnyLocalAddress() && originAddress != null) {
            serverAddress = originAddress;
        }
        return new ChannelAccessBeaconMessage(messageHeader, serverAddress, messageHeader.getCount(), ChannelAccessVersion.forMinorVersion(messageHeader.getDataType()), messageHeader.getCID());
    }
}

