/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

public enum ChannelAccessCommand {
    CA_PROTO_VERSION(0),
    CA_PROTO_EVENT_ADD(1),
    CA_PROTO_EVENT_CANCEL(2),
    CA_PROTO_READ(3),
    CA_PROTO_WRITE(4),
    CA_PROTO_SNAPSHOT(5),
    CA_PROTO_SEARCH(6),
    CA_PROTO_BUILD(7),
    CA_PROTO_EVENTS_OFF(8),
    CA_PROTO_EVENTS_ON(9),
    CA_PROTO_READ_SYNC(10),
    CA_PROTO_ERROR(11),
    CA_PROTO_CLEAR_CHANNEL(12),
    CA_PROTO_RSRV_IS_UP(13),
    CA_PROTO_NOT_FOUND(14),
    CA_PROTO_READ_NOTIFY(15),
    CA_PROTO_READ_BUILD(16),
    REPEATER_CONFIRM(17),
    CA_PROTO_CREATE_CHAN(18),
    CA_PROTO_WRITE_NOTIFY(19),
    CA_PROTO_CLIENT_NAME(20),
    CA_PROTO_HOST_NAME(21),
    CA_PROTO_ACCESS_RIGHTS(22),
    CA_PROTO_ECHO(23),
    REPEATER_REGISTER(24),
    CA_PROTO_SIGNAL(25),
    CA_PROTO_CREATE_CH_FAIL(26),
    CA_PROTO_SERVER_DISCONN(27);

    private static final ChannelAccessCommand[] commandNumberToCommand;
    private short commandNumber;

    private ChannelAccessCommand(int commandNumber) {
        this.commandNumber = (short)commandNumber;
    }

    public short getCommandNumber() {
        return this.commandNumber;
    }

    public static ChannelAccessCommand forCommandNumber(short commandNumber) {
        int commandNumberAsInt = commandNumber & 0xFFFF;
        if (commandNumberAsInt >= commandNumberToCommand.length) {
            throw new IllegalArgumentException("Unknown command number: " + commandNumberAsInt);
        }
        return commandNumberToCommand[commandNumberAsInt];
    }

    static {
        commandNumberToCommand = new ChannelAccessCommand[]{CA_PROTO_VERSION, CA_PROTO_EVENT_ADD, CA_PROTO_EVENT_CANCEL, CA_PROTO_READ, CA_PROTO_WRITE, CA_PROTO_SNAPSHOT, CA_PROTO_SEARCH, CA_PROTO_BUILD, CA_PROTO_EVENTS_OFF, CA_PROTO_EVENTS_ON, CA_PROTO_READ_SYNC, CA_PROTO_ERROR, CA_PROTO_CLEAR_CHANNEL, CA_PROTO_RSRV_IS_UP, CA_PROTO_NOT_FOUND, CA_PROTO_READ_NOTIFY, CA_PROTO_READ_BUILD, REPEATER_CONFIRM, CA_PROTO_CREATE_CHAN, CA_PROTO_WRITE_NOTIFY, CA_PROTO_CLIENT_NAME, CA_PROTO_HOST_NAME, CA_PROTO_ACCESS_RIGHTS, CA_PROTO_ECHO, REPEATER_REGISTER, CA_PROTO_SIGNAL, CA_PROTO_CREATE_CH_FAIL, CA_PROTO_SERVER_DISCONN};
    }
}

