/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.SerializedChannelNameTooLargeException;
import com.aquenos.epics.jackie.common.exception.UnsupportedProtocolVersionException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessConnectChannelMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.util.NullTerminatedStringUtil;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;

public final class ChannelAccessConnectChannelClientMessage
extends ChannelAccessConnectChannelMessage {
    private int cid;
    private ChannelAccessVersion version;
    private String channelName;

    public ChannelAccessConnectChannelClientMessage(int cid, ChannelAccessVersion version, String channelName) {
        if (cid == -1) {
            throw new IllegalArgumentException("The channel CID 0xffffffff is reserved for special purposes and must not be used when connecting a channel.");
        }
        if (version == null) {
            throw new NullPointerException("Channel Acccess version must not be null.");
        }
        if (channelName == null) {
            throw new NullPointerException("Channel name must not be null.");
        }
        this.cid = cid;
        this.version = version;
        this.channelName = channelName;
    }

    private ChannelAccessConnectChannelClientMessage(ChannelAccessMessageHeader messageHeader, int cid, ChannelAccessVersion version, String channelName) {
        super(messageHeader);
        this.cid = cid;
        this.version = version;
        this.channelName = channelName;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public ChannelAccessVersion getVersion() {
        return this.version;
    }

    public String getChannelName() {
        return this.channelName;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("Connections to servers that do not at least support Channel Access version " + ChannelAccessVersion.V4_4 + " are not supported by this library.");
        }
        if (this.channelName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        Pair<byte[], Integer> channelNameBytesWithLength = NullTerminatedStringUtil.stringToSizeLimitedNullTerminatedBytesOrNull(this.channelName, 488, 8, charset);
        if (channelNameBytesWithLength == null) {
            throw new SerializedChannelNameTooLargeException("The serialized form of the channel name must not be longer than 488 bytes.");
        }
        byte[] channelNameAsBytes = (byte[])channelNameBytesWithLength.getLeft();
        int channelNameLength = (Integer)channelNameBytesWithLength.getRight();
        this.serializeHeader(byteSink, channelNameLength, (short)0, 0, this.cid, this.version.getMinorVersionAsShort(), version, maxPayloadSize);
        byteSink.putByteArray(channelNameAsBytes, 0, channelNameLength);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("Connections to servers that do not at least support Channel Access version " + ChannelAccessVersion.V4_4 + " are not supported by this library.");
        }
        if (this.channelName == null) {
            throw new UnsupportedOperationException("Cannot serialize the message payload for a message that has been constructed without the payload.");
        }
        Pair<byte[], Integer> channelNameBytesWithLength = NullTerminatedStringUtil.stringToSizeLimitedNullTerminatedBytesOrNull(this.channelName, 488, 8, charset);
        if (channelNameBytesWithLength == null) {
            throw new SerializedChannelNameTooLargeException("The serialized form of the channel name must not be longer than 488 bytes.");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessConnectChannelClientMessage other = (ChannelAccessConnectChannelClientMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append((Object)this.version, (Object)other.version).append((Object)this.channelName, (Object)other.channelName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append((Object)this.version).append((Object)this.channelName).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", version=");
        sb.append(this.version.toString());
        sb.append(", channelName=");
        if (this.channelName != null) {
            sb.append('\"');
            sb.append(StringEscapeUtils.escapeJava((String)this.channelName));
            sb.append('\"');
        } else {
            sb.append("null");
        }
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessConnectChannelClientMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource, boolean headerOnly, Charset charset) {
        String channelName;
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_CREATE_CHAN.getCommandNumber());
        if (!headerOnly) {
            byte[] channelNameAsBytes = byteSource.getByteArray(messageHeader.getPayloadSize());
            channelName = NullTerminatedStringUtil.nullTerminatedBytesToString(channelNameAsBytes, charset);
        } else {
            channelName = null;
        }
        return new ChannelAccessConnectChannelClientMessage(messageHeader, messageHeader.getCID(), ChannelAccessVersion.forMinorVersion(messageHeader.getContextSpecific()), channelName);
    }
}

