/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.protocol;

import com.aquenos.epics.jackie.common.exception.UnsupportedProtocolVersionException;
import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessCommand;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessConnectChannelMessage;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessMessageHeader;
import com.aquenos.epics.jackie.common.protocol.ChannelAccessVersion;
import com.aquenos.epics.jackie.common.value.ChannelAccessValueType;
import java.nio.charset.Charset;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ChannelAccessConnectChannelServerMessage
extends ChannelAccessConnectChannelMessage {
    private int cid;
    private int sid;
    private short dataType;
    private int count;

    public ChannelAccessConnectChannelServerMessage(int cid, int sid, ChannelAccessValueType dataType, int count) {
        this.cid = cid;
        this.sid = sid;
        this.dataType = dataType.toTypeCode();
        this.count = count;
    }

    private ChannelAccessConnectChannelServerMessage(ChannelAccessMessageHeader messageHeader, int cid, int sid, short dataType, int count) {
        super(messageHeader);
        this.cid = cid;
        this.sid = sid;
        this.dataType = dataType;
        this.count = count;
    }

    public int getChannelCID() {
        return this.cid;
    }

    public int getChannelSID() {
        return this.sid;
    }

    public ChannelAccessValueType getNativeDataType() {
        try {
            return ChannelAccessValueType.forTypeNumber(this.dataType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getNativeCount() {
        return this.count;
    }

    @Override
    protected void serialize(ByteSink byteSink, ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("Connections from clients that do not at least support Channel Access version " + ChannelAccessVersion.V4_4 + " are not supported by this library.");
        }
        this.serializeHeader(byteSink, 0, this.dataType, this.count, this.cid, this.sid, version, maxPayloadSize);
    }

    @Override
    protected void verify(ChannelAccessVersion version, int maxPayloadSize, Charset charset) {
        if (!version.includes(ChannelAccessVersion.V4_4)) {
            throw new UnsupportedProtocolVersionException("Connections from clients that do not at least support Channel Access version " + ChannelAccessVersion.V4_4 + " are not supported by this library.");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChannelAccessConnectChannelServerMessage other = (ChannelAccessConnectChannelServerMessage)obj;
        return new EqualsBuilder().append(this.cid, other.cid).append(this.sid, other.sid).append(this.dataType, other.dataType).append(this.count, other.count).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cid).append(this.sid).append(this.dataType).append(this.count).toHashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.toString());
        sb.append('{');
        sb.append("cid=");
        sb.append(this.cid);
        sb.append(", sid=");
        sb.append(this.sid);
        sb.append(", dataType=");
        try {
            sb.append((Object)ChannelAccessValueType.forTypeNumber(this.dataType));
        }
        catch (IllegalArgumentException e) {
            sb.append("UNKNOWN(");
            sb.append(this.dataType);
            sb.append(')');
        }
        sb.append(", count=");
        sb.append(this.count);
        sb.append('}');
        return sb.toString();
    }

    protected static ChannelAccessConnectChannelServerMessage deserialize(ChannelAccessMessageHeader messageHeader, ByteSource byteSource) {
        assert (messageHeader.getCommand() == ChannelAccessCommand.CA_PROTO_CREATE_CHAN.getCommandNumber());
        byteSource.skip(messageHeader.getPayloadSize());
        return new ChannelAccessConnectChannelServerMessage(messageHeader, messageHeader.getCID(), messageHeader.getContextSpecific(), messageHeader.getDataType(), messageHeader.getCount());
    }
}

